/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.csv.service;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.csv.service.ExportCSVParameters;
import org.gvsig.export.csv.service.ExportCSVServiceFactory;
import org.gvsig.export.spi.AbstractExportParametersGeometryFile;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.ListBuilder;

public class ExportCSVParametersImpl
extends AbstractExportParametersGeometryFile
implements ExportCSVParameters {
    private String encoding;
    private File file;
    private String profile;
    private String charset;
    private String escapeCharacter;
    private String commentStartMarker;
    private String quoteCharacter;
    private String delimiter;
    private String recordSeparator;
    private String locale;
    private String quotePolicy;
    private boolean includeMetadataInHeader = true;
    private final List<String> countriesNorth = ListBuilder.create((Object[])new Object[]{"es", "it", "fr", "dl"});
    private String geometryFormat;

    public ExportCSVParametersImpl(ExportCSVServiceFactory factory) {
        super((ExportServiceFactory)factory);
        this.fileHelper.setFileExtension("csv");
        Locale defaultLocale = Locale.getDefault();
        String countryLocale = defaultLocale.getCountry();
        if (StringUtils.isBlank((CharSequence)countryLocale)) {
            countryLocale = defaultLocale.getLanguage();
        }
        if (this.countriesNorth.contains(countryLocale)) {
            this.profile = "EXCEL_NORTH_EUROPE_PREFERENCE";
        }
        this.geometryFormat = "WKT";
    }

    public ExportCSVParametersImpl() {
        this(null);
    }

    public String getServiceName() {
        return "CSV";
    }

    public void setSourceFeatureType(FeatureType sourceFeatureType) {
        super.setSourceFeatureType(sourceFeatureType);
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Override
    public String getQuotePolicy() {
        return this.quotePolicy;
    }

    @Override
    public void setQuotePolicy(String quotePolicy) {
        this.quotePolicy = quotePolicy;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    @Override
    public void setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    @Override
    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    @Override
    public String getCommentStartMarker() {
        return this.commentStartMarker;
    }

    @Override
    public void setCommentStartMarker(String commentStartMarker) {
        this.commentStartMarker = commentStartMarker;
    }

    @Override
    public String getEscapeCharacter() {
        return this.escapeCharacter;
    }

    @Override
    public void setEscapeCharacter(String escapeCharacer) {
        this.escapeCharacter = escapeCharacer;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        String label = StringUtils.join((Object[])new String[]{super.getLabel(), ",", this.getProfile()});
        return label;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("ExportCSVParametersImpl") == null) {
            DynStruct definition = manager.addDefinition(ExportCSVParametersImpl.class, "ExportCSVParametersImpl", "ExportCSVParametersImpl persistence definition", null, null);
            definition.addDynFieldString("encoding");
            definition.addDynFieldFile("file");
            definition.addDynFieldString("profile");
            definition.addDynFieldString("charset");
            definition.addDynFieldString("escapeCharacter");
            definition.addDynFieldString("commentStartMarker");
            definition.addDynFieldString("quoteCharacter");
            definition.addDynFieldString("delimiter");
            definition.addDynFieldString("recordSeparator");
            definition.addDynFieldString("locale");
            definition.addDynFieldString("quotePolicy");
            definition.addDynFieldBoolean("includeMetadataInHeader");
            definition.extend(manager.getDefinition("AbstractExportParametersGeometryFile"));
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("encoding", this.encoding);
        state.set("file", this.file);
        state.set("profile", this.profile);
        state.set("charset", this.charset);
        state.set("escapeCharacter", this.escapeCharacter);
        state.set("commentStartMarker", this.commentStartMarker);
        state.set("quoteCharacter", this.quoteCharacter);
        state.set("delimiter", this.delimiter);
        state.set("recordSeparator", this.recordSeparator);
        state.set("locale", this.locale);
        state.set("quotePolicy", this.quotePolicy);
        state.set("includeMetadataInHeader", this.includeMetadataInHeader);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.encoding = state.getString("encoding");
        this.file = state.getFile("file");
        this.profile = state.getString("profile");
        this.charset = state.getString("charset");
        this.escapeCharacter = state.getString("escapeCharacter");
        this.commentStartMarker = state.getString("commentStartMarker");
        this.quoteCharacter = state.getString("quoteCharacter");
        this.delimiter = state.getString("delimiter");
        this.recordSeparator = state.getString("recordSeparator");
        this.locale = state.getString("locale");
        this.quotePolicy = state.getString("quotePolicy");
        this.includeMetadataInHeader = state.getBoolean("includeMetadataInHeader");
    }

    @Override
    public boolean getIncludeMetadataInHeader() {
        return this.includeMetadataInHeader;
    }

    @Override
    public void setIncludeMetadataInHeader(boolean includeMetadataInHeader) {
        this.includeMetadataInHeader = includeMetadataInHeader;
    }

    @Override
    public String getGeometryFormat() {
        return this.geometryFormat;
    }

    @Override
    public void setGeometryFormat(String geometryFormat) {
        this.geometryFormat = geometryFormat;
    }
}

