/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.RasterStore;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.lib.buffer.api.TileStruct;
import org.gvsig.raster.tilecache.provider.AbstractTileCacheStoreProvider;
import org.gvsig.raster.tilecache.provider.MemoryTileCacheStoreProviderParameters;
import org.gvsig.raster.tilecache.provider.MemoryTileStructImage;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTileCacheStoreProvider
extends AbstractTileCacheStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MemoryTileCacheStoreProvider.class);
    public static String NAME = "MemoryTileCache";
    public static String DESCRIPTION = "Memory Tile cache provider";
    public static final String METADATA_DEFINITION_NAME = NAME;
    private final SimpleTaskStatus taskStatus;

    protected static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition(METADATA_DEFINITION_NAME) == null) {
            manager.addDefinition(METADATA_DEFINITION_NAME, MemoryTileCacheStoreProviderParameters.class.getResourceAsStream("TileCacheMetadata.xml"), MemoryTileCacheStoreProviderParameters.class.getClassLoader());
        }
    }

    public MemoryTileCacheStoreProvider(MemoryTileCacheStoreProviderParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)params, storeServices, FileHelper.newMetadataContainer((String)METADATA_DEFINITION_NAME));
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("MemoryTileCache");
        this.init(params, storeServices);
    }

    protected MemoryTileCacheStoreProvider(MemoryTileCacheStoreProviderParameters params, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super((DataStoreParameters)params, storeServices, metadata);
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("MemoryTileCache");
        this.init(params, storeServices);
    }

    protected void init(MemoryTileCacheStoreProviderParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.bandsNumber = ((RasterStore)storeServices).getBands();
        if (params == null) {
            throw new InitializeException((Throwable)new NullPointerException("params is null"));
        }
    }

    public MemoryTileCacheStoreProviderParameters getParameters() {
        return (MemoryTileCacheStoreProviderParameters)super.getParameters();
    }

    public ResourceProvider getResource() {
        return null;
    }

    public Object getSourceId() {
        return this.innerProvider.getSourceId() + "_MemoryTileCache";
    }

    public String getProviderName() {
        return NAME;
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", resource);
    }

    @Override
    public void apply(RasterStoreProvider provider, IProjection crs, RasterQuery query) throws DataException {
        super.apply(provider, crs, query);
        this.setTileStructImage(new MemoryTileStructImage(provider, query));
    }

    @Override
    public RasterStoreProvider getInnerProvider() {
        return this.innerProvider;
    }

    @Override
    public TileStruct getTileStruct() {
        return this.innerProvider.getTileStruct();
    }
}

