/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tilecache.provider;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.FileUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.raster.RasterQuery;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProvider;
import org.gvsig.fmap.dal.raster.spi.RasterStoreProviderServices;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.metadata.MetadataManager;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.raster.tilecache.provider.AbstractTileCacheStoreProvider;
import org.gvsig.raster.tilecache.provider.FileTileCacheStructImage;
import org.gvsig.raster.tilecache.provider.TileCacheStoreProviderParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.DynObjectEncoder;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileCacheStoreProvider
extends AbstractTileCacheStoreProvider
implements ResourceConsumer {
    private static final Logger logger = LoggerFactory.getLogger(TileCacheStoreProvider.class);
    public static String NAME = "TileCache";
    public static String DESCRIPTION = "Tile cache provider";
    public static final String METADATA_DEFINITION_NAME = NAME;
    private ResourceProvider resource;
    private final SimpleTaskStatus taskStatus;

    protected static void registerMetadataDefinition() throws MetadataException {
        MetadataManager manager = MetadataLocator.getMetadataManager();
        if (manager.getDefinition(METADATA_DEFINITION_NAME) == null) {
            manager.addDefinition(METADATA_DEFINITION_NAME, TileCacheStoreProviderParameters.class.getResourceAsStream("TileCacheMetadata.xml"), TileCacheStoreProviderParameters.class.getClassLoader());
        }
    }

    public TileCacheStoreProvider(TileCacheStoreProviderParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)params, storeServices, FileHelper.newMetadataContainer((String)METADATA_DEFINITION_NAME));
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("TileCache");
        this.init(params, storeServices);
    }

    protected TileCacheStoreProvider(TileCacheStoreProviderParameters params, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super((DataStoreParameters)params, storeServices, metadata);
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus("TileCache");
        this.init(params, storeServices);
    }

    protected void init(TileCacheStoreProviderParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.bandsNumber = ((RasterStoreProviderServices)storeServices).getProvider().getBands();
        if (params == null) {
            throw new InitializeException((Throwable)new NullPointerException("params is null"));
        }
    }

    public TileCacheStoreProviderParameters getParameters() {
        return (TileCacheStoreProviderParameters)super.getParameters();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    public Object getSourceId() {
        File folder = this.getParameters().getFolder();
        if (folder == null) {
            folder = this.getParameters().getRootFolder();
        }
        return folder;
    }

    public String getProviderName() {
        return NAME;
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", resource);
    }

    @Override
    protected void doDispose() throws BaseException {
        super.doDispose();
        this.resource.removeConsumer((ResourceConsumer)this);
    }

    @Override
    public void apply(RasterStoreProvider provider, IProjection crs, RasterQuery query) throws DataException {
        super.apply(provider, crs, query);
        TileCacheStoreProviderParameters params = this.getParameters();
        File folder = (File)params.getDynValue("folder");
        if (folder == null) {
            folder = (File)params.getDynValue("rootFolder");
            DynObjectManager dynObjectManager = ToolsLocator.getDynObjectManager();
            DynObjectEncoder encoder = dynObjectManager.createSimpleDynObjectEncoder();
            MessageDigest md = null;
            String hex = "";
            try {
                md = MessageDigest.getInstance("MD5");
                md.update(encoder.encode((DynObject)provider.getParameters()).getBytes());
                hex = this.convertToHex(md.digest());
            }
            catch (NoSuchAlgorithmException e) {
                logger.warn("Can't get a MD5 instance.", (Throwable)e);
            }
            folder = new File(folder.getAbsolutePath() + File.separator + hex + "-" + this.getName());
            try {
                FileUtils.write((File)new File(folder, "parameters.txt"), (CharSequence)encoder.encode((DynObject)provider.getParameters()));
            }
            catch (IOException e) {
                logger.warn("Can't create parameters file of store '" + this.getName() + "' for the cache.", (Throwable)e);
            }
        }
        this.resource = this.createResource("file", new Object[]{folder.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.setTileStructImage(new FileTileCacheStructImage(folder, crs, provider, query));
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

