/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.multifile.app.panel.BandSelectorPanel;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileFormat;
import org.gvsig.raster.swing.RasterSwingLibrary;

public class MainDialogActions
implements IProcessActions {
    private String file = null;
    private String folder = null;
    private BandSelectorPanel panel = null;
    private AbstractViewPanel selectedView = null;

    public MainDialogActions(BandSelectorPanel panel, String file, String folder) {
        this.file = file;
        this.folder = folder;
        this.panel = panel;
    }

    public void buildOneLayer() {
        RasterDataStore mainRasterStore = this.panel.getResult();
        this.saveMetadata();
        DataProcess clippingProcess = null;
        try {
            clippingProcess = RasterBaseAlgorithmLibrary.getManager().createRasterTask("ClippingProcess");
        }
        catch (ProcessException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_processing_layer"), (Object)this.panel, (Exception)((Object)e));
        }
        clippingProcess.setActions((IProcessActions)this);
        String tit = PluginServices.getMDIManager().getWindowInfo((IWindow)this.getView()).getTitle();
        clippingProcess.addParam("viewname", (Object)tit);
        clippingProcess.addParam("pixelcoordinates", (Object)new int[]{0, (int)mainRasterStore.getHeight(), (int)mainRasterStore.getWidth(), 0});
        clippingProcess.addParam("resolution", (Object)new int[]{(int)mainRasterStore.getWidth(), (int)mainRasterStore.getHeight()});
        clippingProcess.addParam("suffix", (Object)".tif");
        clippingProcess.addParam("filename", (Object)(this.folder + File.separator + this.file));
        clippingProcess.addParam("layer", (Object)mainRasterStore);
        int[] drawableBands = new int[mainRasterStore.getBandCount()];
        for (int i = 0; i < drawableBands.length; ++i) {
            drawableBands[i] = i;
        }
        clippingProcess.addParam("drawablebands", (Object)drawableBands);
        clippingProcess.addParam("onelayerperband", (Object)new Boolean(false));
        clippingProcess.addParam("interpolationmethod", (Object)new Integer(1));
        clippingProcess.addParam("affinetransform", (Object)mainRasterStore.getAffineTransform());
        clippingProcess.start();
    }

    public void loadLayer() {
        RasterDataStore mainRasterStore = this.panel.getResult();
        if (mainRasterStore == null) {
            return;
        }
        this.saveMff(mainRasterStore);
        this.saveMetadata();
        try {
            this.loadLayerInView(mainRasterStore);
        }
        catch (LoadLayerException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_loading_layer"), (Object)this.panel, (Exception)((Object)e));
        }
    }

    private void saveMff(RasterDataStore mainRasterStore) {
        MultiFileDataParameters params = (MultiFileDataParameters)mainRasterStore.getParameters();
        ArrayList<File> uriList = new ArrayList<File>();
        List providers = params.getProviders();
        for (int i = 0; i < providers.size(); ++i) {
            uriList.add(new File(((RasterProvider)providers.get(i)).getURI()));
        }
        try {
            MultiFileFormat.saveMultiFileFormat((String)this.file, (String)this.folder, uriList);
        }
        catch (IOException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_salvando_mff"), (Object)this.panel, (Exception)e);
        }
    }

    private void saveMetadata() {
        int aBand;
        int bBand;
        int gBand;
        RasterDataStore mainRasterStore = this.panel.getResult();
        int rBand = this.panel.getColorInterpretationByColorBandBand(1);
        if (!this.isCorrectAssignedBand(rBand, gBand = this.panel.getColorInterpretationByColorBandBand(2), bBand = this.panel.getColorInterpretationByColorBandBand(4), aBand = this.panel.getColorInterpretationByColorBandBand(8))) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"combinacion_no_asignable"), (Object)this.panel);
            return;
        }
        try {
            ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation(new String[mainRasterStore.getBandCount()]);
            if (rBand == gBand && rBand == bBand && rBand >= 0) {
                for (int iBand = 0; iBand < this.panel.getARGBTable().getRowCount(); ++iBand) {
                    ci.setColorInterpValue(iBand, "Undefined");
                }
                ci.setColorInterpValue(rBand, "Gray");
                ci.setColorInterpValue(aBand, "Alpha");
            } else {
                ci.setColorInterpValue(aBand, "Alpha");
                ci.setColorInterpValue(rBand, "Red");
                ci.setColorInterpValue(gBand, "Green");
                ci.setColorInterpValue(bBand, "Blue");
            }
            RasterLocator.getManager().getProviderServices().saveObjectToRmfFile(this.folder + File.separator + this.file, (Object)ci);
        }
        catch (RmfSerializerException exc) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"error_salvando_rmf"), (Object)this.panel, (Exception)((Object)exc));
        }
        catch (NotInitializeException exc) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"table_not_initialize"), (Object)this.panel, (Exception)((Object)exc));
        }
    }

    private void loadLayerInView(RasterDataStore mainRasterStore) throws LoadLayerException {
        MapContextManager mcm = MapContextLocator.getMapContextManager();
        FLyrRaster lyr = (FLyrRaster)mcm.createLayer(this.file, (DataStore)mainRasterStore);
        lyr.reload();
        this.getView().getMapControl().getMapContext().beginAtomicEvent();
        this.getView().getMapControl().getMapContext().getLayers().addLayer((FLayer)lyr);
        this.getView().getMapControl().getMapContext().invalidate();
        this.getView().getMapControl().getMapContext().endAtomicEvent();
    }

    private AbstractViewPanel getView() {
        if (this.selectedView == null) {
            IWindow[] wList = PluginServices.getMDIManager().getAllWindows();
            for (int i = 0; i < wList.length; ++i) {
                if (!(wList[i] instanceof AbstractViewPanel)) continue;
                this.selectedView = (AbstractViewPanel)wList[i];
            }
        }
        return this.selectedView;
    }

    private boolean isCorrectAssignedBand(int r, int g, int b, int a) {
        if (r == g && r == b && r >= 0) {
            return r != a;
        }
        int[] list = new int[]{r, g, b, a};
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                if (i == j || list[i] != list[j] || list[i] <= -1) continue;
                return false;
            }
        }
        return true;
    }

    public void interrupted() {
    }

    public void end(Object param) {
    }

    public void updateProgress(int current, int total) {
    }
}

