/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JRadioButton;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.multifile.app.panel.AbstractBandSelectorListener;
import org.gvsig.raster.multifile.app.panel.BandSelectorPanel;
import org.gvsig.raster.multifile.io.MultiFileDataParameters;
import org.gvsig.raster.multifile.io.MultiFileProvider;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;
import org.gvsig.tools.locator.LocatorException;

public class BandSelectorNewLayerListener
extends AbstractBandSelectorListener {
    protected RasterDataStore mainRasterStore = null;

    public BandSelectorNewLayerListener(BandSelectorPanel bs) {
        super(bs);
    }

    @Override
    public RasterDataStore getResult() {
        return this.mainRasterStore;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.bandSetupPanel.getFileList().getJButtonAdd())) {
            this.addFileBand();
            return;
        }
        if (e.getSource().equals(this.bandSetupPanel.getFileList().getJButtonRemove())) {
            this.delFileBand();
            return;
        }
        if (e.getSource() instanceof JRadioButton) {
            return;
        }
        this.apply();
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
    }

    @Override
    public void setNewBandsPositionInRendering() {
    }

    @Override
    public void apply() {
    }

    @Override
    public void addFileBand() {
        JFileChooser fileChooser = this.createJFileChooser();
        int result = fileChooser.showOpenDialog((Component)((Object)this.bandSetupPanel));
        if (result == 0) {
            int i;
            File[] files = fileChooser.getSelectedFiles();
            if (files == null || files.length <= 0) {
                return;
            }
            JFileChooser.setLastPath((String)"OPEN_LAYER_FILE_CHOOSER_ID", (File)files[0]);
            int initPosition = 0;
            if (this.mainRasterStore == null) {
                initPosition = 1;
                MultiFileProvider provider = this.createMultiFileProvider(this.file, this.folder);
                MultiFileDataParameters newParamsMultifile = (MultiFileDataParameters)provider.getDataParameters();
                try {
                    RasterDataStore firstDataStore = RasterLocator.getManager().getProviderServices().open(files[0].getAbsolutePath());
                    newParamsMultifile.addProvider(firstDataStore);
                    this.mainRasterStore = RasterLocator.getManager().getProviderServices().open((CoverageStoreProvider)provider, provider.getDataStoreParameters());
                }
                catch (RasterDriverException e) {
                    this.log.debug("Error loading the main store", (Throwable)e);
                }
                catch (LocatorException e) {
                    this.log.debug("Error loading the main store", (Throwable)e);
                }
                catch (NotSupportedExtensionException e) {
                    this.log.debug("Error loading the main store", (Throwable)e);
                }
                catch (InitializeException e) {
                    this.log.debug("Error loading the main store", (Throwable)e);
                }
                catch (ProviderNotRegisteredException e) {
                    this.log.debug("Error loading the main store", (Throwable)e);
                }
            }
            ArrayList<File> fileList = new ArrayList<File>();
            for (i = initPosition; i < files.length; ++i) {
                URI[] uris = this.mainRasterStore.getURIByProvider();
                boolean exists = false;
                for (int j = 0; j < uris.length; ++j) {
                    if (!new File(uris[j]).getAbsolutePath().endsWith(files[i].getName())) continue;
                    RasterSwingLibrary.messageBoxError((String)(Messages.getText((String)"fichero_existe") + ": " + files[i].getAbsolutePath()), (Object)this.bandSetupPanel);
                    exists = true;
                    break;
                }
                if (exists) continue;
                fileList.add(files[i]);
            }
            if (!this.checkStoresCompatibility(this.mainRasterStore, fileList)) {
                return;
            }
            if (this.mainRasterStore.isMultiFile()) {
                for (i = 0; i < fileList.size(); ++i) {
                    try {
                        this.mainRasterStore.addFile((File)fileList.get(i));
                        continue;
                    }
                    catch (InvalidSourceException e) {
                        RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"addband_error"), (Object)this.bandSetupPanel, (Exception)((Object)e));
                    }
                }
                this.mainRasterStore.setProvider(this.mainRasterStore.getProvider());
                try {
                    this.bandSetupPanel.addFiles(this.mainRasterStore);
                }
                catch (NotInitializeException e) {
                    RasterSwingLibrary.messageBoxError((String)"table_not_initialize", (Object)this, (Exception)((Object)e));
                }
            }
        }
    }

    @Override
    public void delFileBand() {
        if (this.mainRasterStore == null) {
            return;
        }
        Object[] objects = this.bandSetupPanel.getFileList().getJList().getSelectedValues();
        for (int i = objects.length - 1; i >= 0; --i) {
            if (this.bandSetupPanel.getFileList().getNFiles() <= 1) continue;
            String pathName = objects[i].toString();
            this.mainRasterStore.removeFile(new File(pathName));
            String file = pathName.substring(pathName.lastIndexOf(File.separator) + 1);
            file = file.substring(file.lastIndexOf("\\") + 1);
            this.bandSetupPanel.removeFile(file);
        }
        this.setNewBandsPositionInRendering();
    }
}

