/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.basepanel.AbstractButtonsPanel;
import org.gvsig.raster.swing.basepanel.ButtonsPanelEvent;
import org.gvsig.raster.swing.basepanel.ButtonsPanelListener;

public class LayerNameDialog
extends AbstractButtonsPanel
implements IWindow,
ButtonsPanelListener {
    private static final long serialVersionUID = 7362459094802955247L;
    private JPanel panel = null;
    private String layerName = null;
    private JTextField name = null;
    private ButtonsPanelListener listener = null;
    private Point2D position = null;

    public LayerNameDialog(Point2D position, int width, int height, ButtonsPanelListener listener) {
        super(2);
        this.position = position;
        this.layerName = null;
        this.listener = listener;
        this.setSize(width, height);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.getMainPanel(), "Center");
        this.addButtonPressedListener(this);
    }

    public LayerNameDialog(int width, int height, ButtonsPanelListener listener) {
        this(new Point2D.Double(), width, height, listener);
    }

    public JPanel getMainPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.fill = 2;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            this.panel.add((Component)this.getNameField(), gbc);
        }
        return this.panel;
    }

    private JTextField getNameField() {
        if (this.name == null) {
            this.name = new JTextField();
        }
        return this.name;
    }

    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(9);
        m_viewinfo.setTitle(Messages.getText((String)"layer_name"));
        m_viewinfo.setHeight(this.getHeight());
        m_viewinfo.setWidth(this.getWidth());
        m_viewinfo.setX((int)this.position.getX());
        m_viewinfo.setY((int)this.position.getY());
        return m_viewinfo;
    }

    private void close() {
        try {
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void accept() {
        String txt = this.getNameField().getText();
        if (txt == null || txt.compareTo("") == 0) {
            JOptionPane.showMessageDialog(null, Messages.getText((String)"character_not_valid"), "", 0);
            return;
        }
        byte[] byteList = txt.getBytes();
        for (int i = 0; i < byteList.length; ++i) {
            if (!(byteList[i] < 45 || byteList[i] > 45 && byteList[i] < 48 || byteList[i] > 57 && byteList[i] < 65 || byteList[i] > 90 && byteList[i] < 95 || byteList[i] > 95 && byteList[i] < 97 || byteList[i] > 122 && byteList[i] < 126) && byteList[i] <= 126) continue;
            JOptionPane.showMessageDialog(null, Messages.getText((String)"character_not_valid"), "", 0);
            return;
        }
        this.layerName = txt;
        this.close();
        this.listener.actionButtonPressed(new ButtonsPanelEvent((Object)this.layerName, 1));
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 2) {
            this.close();
        }
        if (e.getButton() == 1) {
            this.accept();
        }
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }
}

