/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.cache.buffer;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import org.gvsig.raster.cache.buffer.Band;
import org.gvsig.raster.cache.buffer.BufferNoData;
import org.gvsig.raster.cache.buffer.BufferStats;
import org.gvsig.raster.cache.buffer.exception.BandNotCompatibleException;
import org.gvsig.raster.cache.buffer.exception.OperationNotSupportedException;
import org.gvsig.raster.cache.buffer.exception.ProcessInterruptedException;
import org.gvsig.raster.cache.buffer.exception.WrongParameterException;
import org.gvsig.raster.cache.buffer.histogram.Histogramable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Buffer
extends Histogramable {
    public static final boolean noDataValueEnable = false;
    public static final double defaultNoDataValue = -99999.0;
    public static final int TYPE_UNDEFINED = 32;
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_SHORT = 2;
    public static final int TYPE_USHORT = 1;
    public static final int TYPE_INT = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DOUBLE = 5;
    public static final int READ_ONLY = 0;
    public static final int READ_WRITE = 1;
    public static final int READ_WRITE_CVERT = 2;

    public int getWidth();

    public int getHeight();

    public int getBandCount();

    public int getDataType();

    public void setDataType(int var1);

    public BufferNoData getNoDataValue();

    public void setNoDataValue(BufferNoData var1);

    public boolean isWritable();

    public boolean isInside(int var1, int var2);

    public Rectangle2D getDataExtent();

    public void setDataExtent(Rectangle2D var1);

    public void free() throws IOException;

    public void setStore(Object var1);

    public Object getStore();

    public byte[][] getLineByte(int var1) throws OperationNotSupportedException;

    public short[][] getLineShort(int var1) throws OperationNotSupportedException;

    public int[][] getLineInt(int var1) throws OperationNotSupportedException;

    public float[][] getLineFloat(int var1) throws OperationNotSupportedException;

    public double[][] getLineDouble(int var1) throws OperationNotSupportedException;

    public byte[] getLineFromBandByte(int var1, int var2) throws OperationNotSupportedException;

    public short[] getLineFromBandShort(int var1, int var2) throws OperationNotSupportedException;

    public int[] getLineFromBandInt(int var1, int var2) throws OperationNotSupportedException;

    public float[] getLineFromBandFloat(int var1, int var2) throws OperationNotSupportedException;

    public double[] getLineFromBandDouble(int var1, int var2) throws OperationNotSupportedException;

    public byte getElemByte(int var1, int var2, int var3);

    public short getElemShort(int var1, int var2, int var3);

    public int getElemInt(int var1, int var2, int var3);

    public float getElemFloat(int var1, int var2, int var3);

    public double getElemDouble(int var1, int var2, int var3);

    public void getElemByte(int var1, int var2, byte[] var3);

    public void getElemShort(int var1, int var2, short[] var3);

    public void getElemInt(int var1, int var2, int[] var3);

    public void getElemFloat(int var1, int var2, float[] var3);

    public void getElemDouble(int var1, int var2, double[] var3);

    public void setLineInBandByte(byte[] var1, int var2, int var3) throws OperationNotSupportedException;

    public void setLineInBandShort(short[] var1, int var2, int var3) throws OperationNotSupportedException;

    public void setLineInBandInt(int[] var1, int var2, int var3) throws OperationNotSupportedException;

    public void setLineInBandFloat(float[] var1, int var2, int var3) throws OperationNotSupportedException;

    public void setLineInBandDouble(double[] var1, int var2, int var3) throws OperationNotSupportedException;

    public void setLineByte(byte[][] var1, int var2) throws OperationNotSupportedException;

    public void setLineShort(short[][] var1, int var2) throws OperationNotSupportedException;

    public void setLineInt(int[][] var1, int var2) throws OperationNotSupportedException;

    public void setLineFloat(float[][] var1, int var2) throws OperationNotSupportedException;

    public void setLineDouble(double[][] var1, int var2) throws OperationNotSupportedException;

    public void setElem(int var1, int var2, int var3, byte var4) throws OperationNotSupportedException;

    public void setElem(int var1, int var2, int var3, short var4) throws OperationNotSupportedException;

    public void setElem(int var1, int var2, int var3, int var4) throws OperationNotSupportedException;

    public void setElem(int var1, int var2, int var3, float var4) throws OperationNotSupportedException;

    public void setElem(int var1, int var2, int var3, double var4) throws OperationNotSupportedException;

    public void setElemByte(int var1, int var2, byte[] var3) throws OperationNotSupportedException;

    public void setElemShort(int var1, int var2, short[] var3) throws OperationNotSupportedException;

    public void setElemInt(int var1, int var2, int[] var3) throws OperationNotSupportedException;

    public void setElemFloat(int var1, int var2, float[] var3) throws OperationNotSupportedException;

    public void setElemDouble(int var1, int var2, double[] var3) throws OperationNotSupportedException;

    public void assign(int var1, byte var2) throws OperationNotSupportedException;

    public void assign(int var1, short var2) throws OperationNotSupportedException;

    public void assign(int var1, int var2) throws OperationNotSupportedException;

    public void assign(int var1, float var2) throws OperationNotSupportedException;

    public void assign(int var1, double var2) throws OperationNotSupportedException;

    public void removeBand(int var1) throws IOException;

    public Band addBand(int var1) throws IOException;

    public void copyBand(int var1, Band var2) throws BandNotCompatibleException, OperationNotSupportedException;

    public void assignBand(int var1, Band var2) throws IOException, BandNotCompatibleException;

    public Band getBand(int var1);

    public Band getBandCopy(int var1);

    public Band[] getBands();

    public ArrayList<Band> getBandList();

    public Buffer getBufferWithOneBand(int var1) throws IOException, OperationNotSupportedException;

    public Band createBand(double var1) throws OperationNotSupportedException;

    public void replicateBand(int var1, int var2) throws IOException;

    public Buffer cloneBuffer();

    public void swapBands(int var1, int var2) throws WrongParameterException, IOException;

    public void swapBands(int[] var1) throws WrongParameterException, IOException;

    public void setNotValidValue(double var1);

    public double getNotValidValue();

    public void assignBandToNotValid(int var1) throws OperationNotSupportedException;

    public BufferStats getStatistics();

    public Buffer getAdjustedWindow(int var1, int var2, int var3) throws ProcessInterruptedException;

    public void addDrawableBands(int[] var1);
}

