/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.serverexplorer.wfs;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;

public class WFSServerExplorerParameters
extends AbstractDataServerExplorerParameters
implements DataServerExplorerParameters {
    public static final String DYNCLASS_NAME = "WFSServerExplorerParameters";
    public static final String DYNFIELDNAME_URL = "url";
    public static final String DYNFIELDNAME_VERSION = "version";
    public static final String DYNFIELDNAME_IGNORE_CACHE = "ignoreCache";
    private DelegatedDynObject delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject((DynStruct)this.registerDynClass());

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    private DynClass registerDynClass() {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        DynClass dynClass = dynman.get(DYNCLASS_NAME);
        if (dynClass == null) {
            dynClass = dynman.add(DYNCLASS_NAME);
            DynField field = dynClass.addDynFieldString(DYNFIELDNAME_URL);
            field.setDescription("Path of the remote service");
            field.setMandatory(true);
            field = dynClass.addDynFieldString(DYNFIELDNAME_VERSION);
            field.setDescription("Version of the remote service");
            field.setMandatory(false);
            field = dynClass.addDynFieldBoolean(DYNFIELDNAME_IGNORE_CACHE);
            field.setDescription("If this is true download al files in the next access.");
            field.setMandatory(false);
            field.setDefaultFieldValue((Object)Boolean.FALSE);
        }
        return dynClass;
    }

    public String getExplorerName() {
        return "WFSServerExplorer";
    }

    public String getUrl() {
        return (String)this.getDynValue(DYNFIELDNAME_URL);
    }

    public void setUrl(String url) {
        this.setDynValue(DYNFIELDNAME_URL, url);
    }

    public String getVersion() {
        return (String)this.getDynValue(DYNFIELDNAME_VERSION);
    }

    public void setVersion(String version) {
        this.setDynValue(DYNFIELDNAME_VERSION, version);
    }

    public boolean getIgnoreChace() {
        return BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue(DYNFIELDNAME_IGNORE_CACHE)));
    }

    public void setIgnoreCache(Boolean ignoreCache) {
        this.setDynValue(DYNFIELDNAME_IGNORE_CACHE, new Boolean(ignoreCache));
    }

    public boolean isTheSameServerExplorer(DataServerExplorerParameters params) {
        if (!(params instanceof WFSServerExplorerParameters)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getUrl(), (CharSequence)((WFSServerExplorerParameters)params).getUrl());
    }
}

