/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.wfs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.gvsig.remoteclient.wfs.WFSFeature;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.xmlschema.lib.api.XMLSchemaLocator;
import org.gvsig.xmlschema.lib.api.XMLSchemaManager;
import org.gvsig.xmlschema.lib.api.exceptions.SchemaCreationException;
import org.gvsig.xmlschema.lib.api.som.IXSComplexContent;
import org.gvsig.xmlschema.lib.api.som.IXSComplexTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSContentType;
import org.gvsig.xmlschema.lib.api.som.IXSElementDeclaration;
import org.gvsig.xmlschema.lib.api.som.IXSExtension;
import org.gvsig.xmlschema.lib.api.som.IXSGroup;
import org.gvsig.xmlschema.lib.api.som.IXSRestriction;
import org.gvsig.xmlschema.lib.api.som.IXSSchema;
import org.gvsig.xmlschema.lib.api.som.IXSSimpleContent;
import org.gvsig.xmlschema.lib.api.som.IXSSimpleTypeDefinition;
import org.gvsig.xmlschema.lib.api.som.IXSTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFSFeatureFiller {
    private static final Logger LOG = LoggerFactory.getLogger(WFSFeatureFiller.class);
    private XMLSchemaManager xmlSchemaManager = XMLSchemaLocator.getXMLSchemaManager();
    private static final String XMLSCHEMA_PARSER_PROVIDER_NAME = "xmlschema.providers.kxml";
    private WFSFeature feature;

    public WFSFeatureFiller(WFSFeature feature) {
        this.feature = feature;
    }

    public void fill(File describeFeatureTypeFile) throws SchemaCreationException, FileNotFoundException {
        IXSSchema schema = this.xmlSchemaManager.parse(XMLSCHEMA_PARSER_PROVIDER_NAME, (InputStream)new FileInputStream(describeFeatureTypeFile));
        IXSElementDeclaration elementDeclaration = null;
        elementDeclaration = this.feature.getNamespace() == null ? schema.getElementDeclarationByName(null, this.feature.getName()) : schema.getElementDeclarationByName(this.feature.getNamespace().getLocation(), this.feature.getLocalName());
        if (elementDeclaration == null) {
            return;
        }
        IXSTypeDefinition typeDefinition = elementDeclaration.getTypeDefinition();
        if (typeDefinition == null) {
            return;
        }
        if (!(typeDefinition instanceof IXSSimpleTypeDefinition) && typeDefinition instanceof IXSComplexTypeDefinition) {
            this.fill((IXSComplexTypeDefinition)typeDefinition);
        }
        this.feature.setCompleted(true);
    }

    private void fill(IXSComplexTypeDefinition complexTypeDefinition) {
        IXSGroup group;
        IXSContentType contentType = complexTypeDefinition.getContentType();
        if (contentType != null) {
            this.fill(contentType);
        }
        if ((group = complexTypeDefinition.getGroup()) != null) {
            this.fill((IXSGroup)contentType);
        }
    }

    private void fill(IXSGroup group) {
        for (Object item : group.getItems()) {
            if (item instanceof IXSElementDeclaration) {
                IXSElementDeclaration elementDeclaration = (IXSElementDeclaration)item;
                DataType dataType = null;
                if (elementDeclaration.getTypeDefinition() != null) {
                    dataType = elementDeclaration.getTypeDefinition().getDataType();
                }
                if (dataType == null || elementDeclaration.getNodeName() == null) {
                    LOG.info("Feature attribute type not recognized: " + elementDeclaration.toString(), (Throwable)new Exception("Feature attribute type not recognized: " + elementDeclaration.toString()));
                    continue;
                }
                this.feature.addField(elementDeclaration.getNodeName(), elementDeclaration.getTypeName(), dataType);
                continue;
            }
            LOG.info("Feature attribute not recognized: " + (item == null ? "NULL" : item.getClass().getName()), (Throwable)new Exception("Feature attribute not recognized"));
        }
    }

    private void fill(IXSContentType contentType) {
        if (contentType instanceof IXSSimpleContent) {
            this.fill((IXSSimpleContent)contentType);
        } else if (contentType instanceof IXSComplexContent) {
            this.fill((IXSComplexContent)contentType);
        } else if (contentType instanceof IXSGroup) {
            this.fill((IXSGroup)contentType);
        }
    }

    private void fill(IXSSimpleContent simpleContent) {
        IXSExtension extension;
        IXSRestriction restriction = simpleContent.getRestriction();
        if (restriction != null) {
            this.fill(restriction);
        }
        if ((extension = simpleContent.getExtension()) != null) {
            this.fill(extension);
        }
    }

    private void fill(IXSComplexContent complexContent) {
        IXSExtension extension;
        IXSRestriction restriction = complexContent.getRestriction();
        if (restriction != null) {
            this.fill(restriction);
        }
        if ((extension = complexContent.getExtension()) != null) {
            this.fill(extension);
        }
    }

    private void fill(IXSExtension extension) {
        IXSGroup group = extension.getGroup();
        if (group != null) {
            this.fill(group);
        }
    }

    private void fill(IXSRestriction restriction) {
        IXSGroup group = restriction.getGroup();
        if (group != null) {
            this.fill(group);
        }
    }
}

