/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.wfs_1_0_0;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wfs.WFSProtocolHandler;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.ExceptionsFactory;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.remoteclient.wfs.exceptions.WFSGetFeatureException;
import org.gvsig.remoteclient.wfs.request.WFSDescribeFeatureTypeRequest;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSTLockFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequest;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequestInformation;
import org.gvsig.remoteclient.wfs.schema.XMLSchemaParser;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.WFSFeature1_0_0;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.request.WFSDescribeFeatureTypeRequest1_0_0;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.request.WFSGetFeatureRequest1_0_0;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.request.WFSTLockFeatureRequest1_0_0;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.request.WFSTransactionRequest1_0_0;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WFSProtocolHandler1_0_0
extends WFSProtocolHandler {
    private static Logger logger = LoggerFactory.getLogger(WFSProtocolHandler1_0_0.class);
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();

    public WFSProtocolHandler1_0_0() {
        this.version = "1.0.0";
        this.name = "WFS1.0.0";
    }

    public boolean parseCapabilities(File f) {
        XMLSchemaParser parser = null;
        parser = new XMLSchemaParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "WFS_Capabilities");
                this.parseNamespaces((KXmlParser)parser);
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("Service") == 0) {
                                this.parseServiceTag((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("Capability") == 0) {
                                this.parseCapabilityTag((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("FeatureTypeList") != 0) break;
                            this.parseFeatureTypeListTag((KXmlParser)parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("Can't parse capabilities '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)parser_ex);
            return false;
        }
        catch (IOException ioe) {
            logger.warn("Can't parse capabilities '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    private void parseServiceTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Service");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareToIgnoreCase("Name") == 0) {
                        this.serviceInfo.name = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Title") == 0) {
                        this.serviceInfo.title = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") == 0) {
                        this.serviceInfo.abstr = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("OnlineResource") != 0) break;
                    this.serviceInfo.online_resource = parser.nextText();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Service") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseCapabilityTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Capability");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Request") == 0) {
                        this.parseRequestTag(parser);
                        break;
                    }
                    if (parser.getName().compareTo("Exception") == 0) {
                        parser.skipSubTree();
                        break;
                    }
                    if (parser.getName().compareTo("VendorSpecificCapabilities") != 0 && parser.getName().compareTo("UserDefinedSymbolization") != 0) break;
                    parser.skipSubTree();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Capability") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseRequestTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "Request");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("GetCapabilities") == 0) {
                        this.parserDcpType(parser, "GetCapabilities");
                        break;
                    }
                    if (parser.getName().compareTo("DescribeFeatureType") == 0) {
                        this.parserDcpType(parser, "DescribeFeatureType");
                        break;
                    }
                    if (parser.getName().compareTo("GetFeature") == 0) {
                        this.parserDcpType(parser, "GetFeature");
                        break;
                    }
                    if (parser.getName().compareTo("LockFeature") == 0) {
                        this.parserDcpType(parser, "LockFeature");
                        break;
                    }
                    if (parser.getName().compareTo("Transaction") != 0) break;
                    this.parserDcpType(parser, "Transaction");
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Request") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseFeatureTypeListTag(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        parser.require(2, null, "FeatureTypeList");
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareToIgnoreCase("FeatureType") != 0) break;
                    this.parseNamespaces(parser);
                    WFSFeature1_0_0 feature = new WFSFeature1_0_0(this.serviceInfo);
                    feature.parse(parser);
                    this.features.put(feature.getName(), feature);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("FeatureTypeList") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    @Override
    protected boolean parseGetFeature(File f, String nameSpace) throws WFSException {
        XMLSchemaParser parser = null;
        parser = new XMLSchemaParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getName().compareTo("ServiceExceptionReport") == 0) {
                throw ExceptionsFactory.parseServiceExceptionReport((KXmlParser)parser);
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("Can't get feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "' with namaspace '" + nameSpace + "'.", (Throwable)e);
            throw new WFSGetFeatureException(e);
        }
        catch (XmlPullParserException e) {
            logger.warn("Can't get feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "' with namaspace '" + nameSpace + "'.", (Throwable)e);
            throw new WFSGetFeatureException(e);
        }
        catch (IOException e) {
            logger.warn("Can't get feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "' with namaspace '" + nameSpace + "'.", (Throwable)e);
            throw new WFSGetFeatureException(e);
        }
        return true;
    }

    @Override
    protected boolean parseTransaction(File f, WFSStatus status) throws WFSException {
        XMLSchemaParser parser = null;
        parser = new XMLSchemaParser();
        WFSTransactionRequestInformation transactionRequestInformation = (WFSTransactionRequestInformation)this.getLastWfsRequestInformation();
        try {
            parser.setInput(f);
            parser.nextTag();
            if ("ServiceExceptionReport".equals(parser.getName())) {
                throw ExceptionsFactory.parseServiceExceptionReport((KXmlParser)parser);
            }
            if (parser.getName().equals("ExceptionReport")) {
                throw ExceptionsFactory.parseExceptionReport((KXmlParser)parser);
            }
            if (parser.getEventType() != 1) {
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("TransactionResult") == 0) {
                                this.parseTransactionResult(parser, transactionRequestInformation);
                                break;
                            }
                            if (parser.getName().compareTo("WFS_TransactionResponse") != 0) break;
                            this.parseFeaturesLocked(parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("Can't parse transaction from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)parser_ex);
            return false;
        }
        catch (IOException ioe) {
            logger.warn("Can't parse transaction from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    private void parseTransactionResult(XMLSchemaParser parser, WFSTransactionRequestInformation transactionRequestInformation) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Status") == 0) {
                        this.parseStatus(parser, transactionRequestInformation);
                        break;
                    }
                    if (parser.getName().compareTo("Message") != 0) break;
                    parser.next();
                    transactionRequestInformation.setMessage(parser.getText());
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("TransactionResult") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseStatus(XMLSchemaParser parser, WFSTransactionRequestInformation transactionRequestInformation) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("SUCCESS") == 0) {
                        transactionRequestInformation.setStatus(2);
                        break;
                    }
                    if (parser.getName().compareTo("FAILED") != 0) break;
                    transactionRequestInformation.setStatus(1);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Status") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    @Override
    protected boolean parseLockFeature(File f, String nameSpace, WFSStatus status) throws WFSException {
        XMLSchemaParser parser = null;
        parser = new XMLSchemaParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getName().compareTo("ServiceExceptionReport") == 0) {
                throw ExceptionsFactory.parseServiceExceptionReport((KXmlParser)parser);
            }
            if (parser.getEventType() != 1) {
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("LockId") == 0) {
                                parser.next();
                                status.addFeatureLocked(parser.getText());
                                break;
                            }
                            if (parser.getName().compareTo("FeaturesLocked") != 0) break;
                            this.parseFeaturesLocked(parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException parser_ex) {
            logger.warn("Can't parse lock-feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)parser_ex);
            return false;
        }
        catch (IOException ioe) {
            logger.warn("Can't parse lock-feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", (Throwable)ioe);
            return false;
        }
        return true;
    }

    private void parseFeaturesLocked(XMLSchemaParser parser) throws XmlPullParserException, IOException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("FeatureId") != 0) break;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("FeaturesLocked") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    @Override
    protected WFSDescribeFeatureTypeRequest createDescribeFeatureTypeRequest(WFSStatus status) {
        return new WFSDescribeFeatureTypeRequest1_0_0(status, this);
    }

    @Override
    protected WFSGetFeatureRequest createGetFeatureRequest(WFSStatus status) {
        return new WFSGetFeatureRequest1_0_0(status, this);
    }

    @Override
    protected WFSTLockFeatureRequest createLockFeatureRequest(WFSStatus status) {
        return new WFSTLockFeatureRequest1_0_0(status, this);
    }

    @Override
    protected WFSTransactionRequest createTransactionRequest(WFSStatus status) {
        return new WFSTransactionRequest1_0_0(status, this);
    }
}

