/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.wfs_1_1_0;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.exceptions.ExceptionsFactory;
import org.gvsig.remoteclient.wfs.exceptions.WFSException;
import org.gvsig.remoteclient.wfs.exceptions.WFSGetFeatureException;
import org.gvsig.remoteclient.wfs.request.WFSDescribeFeatureTypeRequest;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequestInformation;
import org.gvsig.remoteclient.wfs.request.WFSTLockFeatureRequest;
import org.gvsig.remoteclient.wfs.request.WFSTransactionRequest;
import org.gvsig.remoteclient.wfs.schema.XMLSchemaParser;
import org.gvsig.remoteclient.wfs.wfs_1_0_0.WFSProtocolHandler1_0_0;
import org.gvsig.remoteclient.wfs.wfs_1_1_0.WFSFeature1_1_0;
import org.gvsig.remoteclient.wfs.wfs_1_1_0.request.WFSDescribeFeatureTypeRequest1_1_0;
import org.gvsig.remoteclient.wfs.wfs_1_1_0.request.WFSGetFeatureRequest1_1_0;
import org.gvsig.remoteclient.wfs.wfs_1_1_0.request.WFSTLockFeatureRequest1_1_0;
import org.gvsig.remoteclient.wfs.wfs_1_1_0.request.WFSTransactionRequest1_1_0;
import org.kxml2.io.KXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WFSProtocolHandler1_1_0
extends WFSProtocolHandler1_0_0 {
    private static final Logger logger = LoggerFactory.getLogger(WFSProtocolHandler1_1_0.class);

    public WFSProtocolHandler1_1_0() {
        this.version = "1.1.0";
        this.name = "WFS1.1.0";
    }

    @Override
    public boolean parseCapabilities(File f) {
        XMLSchemaParser parser = new XMLSchemaParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, "WFS_Capabilities");
                this.parseNamespaces((KXmlParser)parser);
                int tag = parser.nextTag();
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo("ServiceIdentification") == 0) {
                                this.parseServiceIdentification((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("ServiceProvider") == 0) {
                                this.parseServiceProvider((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("OperationsMetadata") == 0) {
                                this.parseOperationsMetadata((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("FeatureTypeList") == 0) {
                                this.parseFeatureTypeList((KXmlParser)parser);
                                break;
                            }
                            if (parser.getName().compareTo("Filter_Capabilities") != 0) break;
                            this.parseFilterCapabilities((KXmlParser)parser);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (parser.getName() == null) break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (IOException | XmlPullParserException parser_ex) {
            logger.warn("Can't parse capabilities from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "'.", parser_ex);
            return false;
        }
        return true;
    }

    private void parseServiceIdentification(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Title") == 0) {
                        this.serviceInfo.title = parser.nextText();
                        break;
                    }
                    if (parser.getName().compareTo("Abstract") != 0) break;
                    this.serviceInfo.abstr = parser.nextText();
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("ServiceIdentification") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseServiceProvider(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("ServiceProvider") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseOperationsMetadata(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareTo("Operation") != 0) break;
                    this.parseOperation(parser);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("OperationsMetadata") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseOperation(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.getEventType();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    int i;
                    if (parser.getName().compareTo("Operation") != 0) break;
                    String operation = null;
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        if (parser.getAttributeName(i).compareTo("name") != 0) continue;
                        operation = parser.getAttributeValue(i);
                    }
                    currentTag = parser.nextTag();
                    if (parser.getName().compareTo("DCP") == 0) {
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("HTTP") != 0) break;
                        currentTag = parser.nextTag();
                        if (parser.getName().compareTo("Get") != 0) break;
                        String value = null;
                        for (int i2 = 0; i2 < parser.getAttributeCount(); ++i2) {
                            if (parser.getAttributeName(i2).compareTo("xlink:href") != 0) continue;
                            value = parser.getAttributeValue(i2);
                        }
                        if (operation == null) break;
                        if (value == null) {
                            this.serviceInfo.addOperation(operation, 0);
                            break;
                        }
                        this.serviceInfo.addOperation(operation, 0, value);
                        break;
                    }
                    if (!"Constraint".equals(parser.getName())) break;
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        String constraint;
                        if (parser.getAttributeName(i).compareTo("name") != 0 || !"DefaultMaxFeatures".equals(constraint = parser.getAttributeValue(i))) continue;
                        currentTag = parser.nextTag();
                        if (!"value".equals(parser.getName())) continue;
                        Integer defaultMaxFeatures = new Integer(parser.nextText());
                        this.serviceInfo.setMaxFeatures(defaultMaxFeatures);
                    }
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Operation") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseFeatureTypeList(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (parser.getName().compareToIgnoreCase("FeatureType") != 0) break;
                    this.parseNamespaces(parser);
                    WFSFeature1_1_0 feature = new WFSFeature1_1_0(this.serviceInfo);
                    feature.parse(parser);
                    this.features.put(feature.getName(), feature);
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("FeatureTypeList") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void parseFilterCapabilities(KXmlParser parser) throws IOException, XmlPullParserException {
        boolean end = false;
        int currentTag = parser.next();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo("Filter_Capabilities") != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    @Override
    protected boolean parseGetFeature(File f, String nameSpace) throws WFSException {
        XMLSchemaParser parser = new XMLSchemaParser();
        try {
            parser.setInput(f);
            parser.nextTag();
            if (parser.getName().equals("ServiceExceptionReport")) {
                throw ExceptionsFactory.parseServiceExceptionReport((KXmlParser)parser);
            }
            if (parser.getName().equals("FeatureCollection") || parser.getName().equals("ResultCollection")) {
                WFSGetFeatureRequestInformation requestInformation = (WFSGetFeatureRequestInformation)this.getLastWfsRequestInformation();
                for (int i = 0; i < parser.getAttributeCount(); ++i) {
                    String attName = parser.getAttributeName(i);
                    if ("numberOfFeatures".equals(attName)) {
                        requestInformation.setNumberOfFeatures(new Integer(parser.getAttributeValue(i)));
                        continue;
                    }
                    if (!"timeStamp".equals(attName)) continue;
                    requestInformation.setTimeStamp(parser.getAttributeValue(i));
                }
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("Can't get feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "' with namaspace '" + nameSpace + "'.", (Throwable)e);
            throw new WFSGetFeatureException(this.getServerError(f), e);
        }
        catch (IOException | XmlPullParserException e) {
            logger.warn("Can't get feature from file '" + Utilities.getAbsolutePathOrEmpty((File)f) + "' with namaspace '" + nameSpace + "'.", e);
            throw new WFSGetFeatureException(this.getServerError(f), e);
        }
        return true;
    }

    private String getServerError(File f) {
        try {
            String s = FileUtils.readFileToString((File)f, (Charset)StandardCharsets.US_ASCII);
            int n = StringUtils.indexOf((CharSequence)s, (CharSequence)"<html");
            if (n < 0 || n > 200) {
                return null;
            }
            int n1 = StringUtils.indexOf((CharSequence)s, (CharSequence)"HTTP Status");
            if (n1 < 0 || n1 > 200) {
                return null;
            }
            int n2 = StringUtils.indexOf((CharSequence)s, (CharSequence)"<", (int)n1);
            if (n2 < 0) {
                return StringUtils.substring((String)s, (int)n1, (int)(n1 + 27));
            }
            return StringUtils.substring((String)s, (int)n1, (int)n2);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    protected boolean parseTransaction(File f, WFSStatus status) throws WFSException {
        return super.parseTransaction(f, status);
    }

    @Override
    protected boolean parseLockFeature(File f, String nameSpace, WFSStatus status) throws WFSException {
        return false;
    }

    @Override
    protected WFSDescribeFeatureTypeRequest createDescribeFeatureTypeRequest(WFSStatus status) {
        return new WFSDescribeFeatureTypeRequest1_1_0(status, this);
    }

    @Override
    protected WFSGetFeatureRequest createGetFeatureRequest(WFSStatus status) {
        return new WFSGetFeatureRequest1_1_0(status, this);
    }

    @Override
    protected WFSTLockFeatureRequest createLockFeatureRequest(WFSStatus status) {
        return new WFSTLockFeatureRequest1_1_0(status, this);
    }

    @Override
    protected WFSTransactionRequest createTransactionRequest(WFSStatus status) {
        return new WFSTransactionRequest1_1_0(status, this);
    }
}

