/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.math.regression;

import java.text.DecimalFormat;
import java.util.ArrayList;

public class Regression {
    public static final int REGRESSION_Best_Fit = 0;
    public static final int REGRESSION_Linear = 1;
    public static final int REGRESSION_Rez_X = 2;
    public static final int REGRESSION_Rez_Y = 3;
    public static final int REGRESSION_Pow = 4;
    public static final int REGRESSION_Exp = 5;
    public static final int REGRESSION_Log = 6;
    private static final double ALMOST_ZERO = 1.0E-4;
    private final ArrayList m_X = new ArrayList();
    private final ArrayList m_Y = new ArrayList();
    private double m_dR;
    private double m_dCoeff;
    private double m_dConst;
    private double m_dXMin;
    private double m_dXMax;
    private double m_dYMin;
    private double m_dYMax;
    private double m_dXMean;
    private double m_dYMean;
    private double m_dXVar;
    private double m_dYVar;
    private int m_iType;

    private double _X_Transform(double x) {
        switch (this.m_iType) {
            default: {
                return x;
            }
            case 2: {
                if (x == 0.0) {
                    x = 1.0E-4;
                }
                return 1.0 / x;
            }
            case 4: 
            case 6: 
        }
        if (x <= 0.0) {
            x = 1.0E-4;
        }
        return Math.log(x);
    }

    private double _Y_Transform(double y) {
        switch (this.m_iType) {
            default: {
                return y;
            }
            case 3: {
                if (y == 0.0) {
                    y = 1.0E-4;
                }
                return 1.0 / y;
            }
            case 4: 
            case 5: 
        }
        if (y <= 0.0) {
            y = 1.0E-4;
        }
        return Math.log(y);
    }

    public void addValue(double dX, double dY) {
        this.m_X.add(new Double(dX));
        this.m_Y.add(new Double(dY));
    }

    public boolean calculate() {
        return this.calculateLinear();
    }

    public boolean calculate(double[] x, double[] y) {
        if (x.length == y.length) {
            this.m_X.clear();
            this.m_Y.clear();
            for (int i = 0; i < y.length; ++i) {
                this.addValue(x[i], y[i]);
            }
            return this.calculate();
        }
        return false;
    }

    public boolean calculate(int iRegressionType) {
        this.m_iType = iRegressionType == 0 ? this.getBestFitType() : iRegressionType;
        if (this.calculateLinear()) {
            switch (this.m_iType) {
                default: {
                    break;
                }
                case 2: {
                    this.m_dXVar = 1.0 / this.m_dXVar;
                    break;
                }
                case 3: {
                    double d = this.m_dConst;
                    this.m_dConst = 1.0 / this.m_dCoeff;
                    this.m_dCoeff = d * this.m_dCoeff;
                    this.m_dYVar = 1.0 / this.m_dYVar;
                    break;
                }
                case 4: {
                    this.m_dConst = Math.exp(this.m_dConst);
                    this.m_dXVar = Math.exp(this.m_dXVar);
                    this.m_dYVar = Math.exp(this.m_dYVar);
                    break;
                }
                case 5: {
                    this.m_dConst = Math.exp(this.m_dConst);
                    this.m_dYVar = Math.exp(this.m_dYVar);
                    break;
                }
                case 6: {
                    this.m_dXVar = Math.exp(this.m_dXVar);
                }
            }
            if (this.m_iType != 1) {
                this.calculateMinMaxMean();
            }
            return true;
        }
        return false;
    }

    private boolean calculateLinear() {
        if (this.m_X.size() > 1) {
            double y;
            double x;
            int i;
            this.m_dXMin = this.m_dXMax = this._X_Transform((Double)this.m_X.get(0));
            this.m_dXMean = this.m_dXMax;
            this.m_dYMin = this.m_dYMax = this._Y_Transform((Double)this.m_Y.get(0));
            this.m_dYMean = this.m_dYMax;
            for (i = 1; i < this.m_X.size(); ++i) {
                x = this._X_Transform((Double)this.m_X.get(i));
                this.m_dXMean += x;
                y = this._Y_Transform((Double)this.m_Y.get(i));
                this.m_dYMean += y;
                this.setMinMaxX(x);
                this.setMinMaxY(y);
            }
            this.m_dXMean /= (double)this.m_X.size();
            this.m_dYMean /= (double)this.m_X.size();
            if (this.m_dXMin < this.m_dXMax && this.m_dYMin < this.m_dYMax) {
                double s_dxdy = 0.0;
                double s_dy2 = 0.0;
                double s_dx2 = 0.0;
                double s_xy = 0.0;
                double s_xx = 0.0;
                double s_y = 0.0;
                double s_x = 0.0;
                for (i = 0; i < this.m_X.size(); ++i) {
                    x = this._X_Transform((Double)this.m_X.get(i));
                    y = this._Y_Transform((Double)this.m_Y.get(i));
                    s_x += x;
                    s_y += y;
                    s_xx += x * x;
                    s_xy += x * y;
                    s_dx2 += (x -= this.m_dXMean) * x;
                    s_dy2 += (y -= this.m_dYMean) * y;
                    s_dxdy += x * y;
                }
                this.m_dXVar = s_dx2 / (double)this.m_X.size();
                this.m_dYVar = s_dy2 / (double)this.m_X.size();
                this.m_dCoeff = s_dxdy / s_dx2;
                this.m_dConst = (double)this.m_X.size() * s_xx - s_x * s_x != 0.0 ? (s_xx * s_y - s_x * s_xy) / ((double)this.m_X.size() * s_xx - s_x * s_x) : 0.0;
                this.m_dR = s_dxdy / Math.sqrt(s_dx2 * s_dy2);
                return true;
            }
        }
        return false;
    }

    private void calculateMinMaxMean() {
        if (this.m_X.size() > 1) {
            this.m_dXMin = this.m_dXMax = this._X_Transform((Double)this.m_X.get(0));
            this.m_dXMean = this.m_dXMax;
            this.m_dYMin = this.m_dYMax = this._Y_Transform((Double)this.m_Y.get(0));
            this.m_dYMean = this.m_dYMax;
            for (int i = 1; i < this.m_X.size(); ++i) {
                double x = (Double)this.m_X.get(i);
                this.m_dXMean += x;
                double y = (Double)this.m_Y.get(i);
                this.m_dYMean += y;
                this.setMinMaxX(x);
                this.setMinMaxY(y);
            }
            this.m_dXMean /= (double)this.m_X.size();
            this.m_dYMean /= (double)this.m_X.size();
        }
    }

    private int getBestFitType() {
        int iType = 1;
        int iTypes = 6;
        double m_dBestR = 0.0;
        this.m_dR = 0.0;
        for (int i = 1; i < 7; ++i) {
            this.calculate(i);
            if (!(this.m_dR > m_dBestR)) continue;
            iType = i;
            m_dBestR = this.m_dR;
        }
        return iType;
    }

    public double getCoeff() {
        return this.m_dCoeff;
    }

    public double getConstant() {
        return this.m_dConst;
    }

    public String getExpression() {
        DecimalFormat df = new DecimalFormat("####.####");
        switch (this.m_iType) {
            case 1: {
                return " y = " + df.format(this.m_dConst) + " + " + df.format(this.m_dCoeff) + "x";
            }
            case 2: {
                return " y = " + df.format(this.m_dConst) + " + " + df.format(this.m_dCoeff) + "/x";
            }
            case 3: {
                return " y = " + df.format(this.m_dConst) + " / (" + df.format(this.m_dCoeff) + "- x)";
            }
            case 4: {
                return " y = " + df.format(this.m_dConst) + "x^" + df.format(this.m_dCoeff);
            }
            case 5: {
                return " y = " + df.format(this.m_dConst) + " \u00ef\u00bf\u00bd e^(" + df.format(this.m_dCoeff) + "x)";
            }
            case 6: {
                return " y = " + df.format(this.m_dConst) + " + " + df.format(this.m_dCoeff) + " \u00ef\u00bf\u00bd ln(x)";
            }
        }
        return "";
    }

    public double getR() {
        return this.m_dR;
    }

    public double getR2() {
        return this.m_dR * this.m_dR;
    }

    public void getRestrictedSample(double[] x, double[] y, int nPoints) {
        for (int i = 0; i < nPoints; ++i) {
            int iIndex = (int)(Math.random() * (double)this.m_X.size());
            x[i] = (Double)this.m_X.get(iIndex);
            y[i] = (Double)this.m_Y.get(iIndex);
        }
    }

    public double getX(double y) {
        if ((double)this.m_X.size() > 0.0) {
            switch (this.m_iType) {
                case 1: {
                    if (this.m_dCoeff != 0.0) {
                        return this.m_dConst * y / this.m_dCoeff;
                    }
                }
                case 2: {
                    if ((y -= this.m_dConst) != 0.0) {
                        return this.m_dCoeff / y;
                    }
                }
                case 3: {
                    if (y != 0.0) {
                        return this.m_dCoeff - this.m_dConst / y;
                    }
                }
                case 4: {
                    if (this.m_dConst != 0.0 && this.m_dCoeff != 0.0) {
                        return Math.pow(y / this.m_dConst, 1.0 / this.m_dCoeff);
                    }
                }
                case 5: {
                    if (this.m_dConst != 0.0) {
                        double d;
                        y /= this.m_dConst;
                        if (d > 0.0 && this.m_dCoeff != 0.0) {
                            return Math.log(y) / this.m_dCoeff;
                        }
                    }
                }
                case 6: {
                    if (this.m_dCoeff == 0.0) break;
                    return Math.exp((y - this.m_dConst) / this.m_dCoeff);
                }
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getXMax() {
        return this.m_dXMax;
    }

    public double getXMin() {
        return this.m_dXMin;
    }

    public double getXVar() {
        return this.m_dXVar;
    }

    public double getY(double x) {
        if ((double)this.m_X.size() > 0.0) {
            switch (this.m_iType) {
                case 1: {
                    return this.m_dConst + this.m_dCoeff * x;
                }
                case 2: {
                    if (x != 0.0) {
                        return this.m_dConst + this.m_dCoeff / x;
                    }
                }
                case 3: {
                    x = this.m_dCoeff - x;
                    if (x != 0.0) {
                        return this.m_dConst / x;
                    }
                }
                case 4: {
                    return this.m_dConst * Math.pow(x, this.m_dCoeff);
                }
                case 5: {
                    return this.m_dConst * Math.exp(this.m_dCoeff * x);
                }
                case 6: {
                    if (!(x > 0.0)) break;
                    return this.m_dConst + this.m_dCoeff * Math.log(x);
                }
            }
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double getYMax() {
        return this.m_dYMax;
    }

    public double getYMin() {
        return this.m_dYMin;
    }

    public double getYVar() {
        return this.m_dYVar;
    }

    private void setMinMaxX(double x) {
        if (x > this.m_dXMax) {
            this.m_dXMax = x;
        }
        if (x < this.m_dXMin) {
            this.m_dXMin = x;
        }
    }

    private void setMinMaxY(double y) {
        if (y > this.m_dYMax) {
            this.m_dYMax = y;
        }
        if (y < this.m_dYMin) {
            this.m_dYMin = y;
        }
    }
}

