/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DatabaseWorkspaceManager;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.PersonalDatabaseServerExplorerFactory;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.xml2db.lib.api.Xml2dbManager;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.lib.impl.CopyXML2dbImpl;
import org.gvsig.xml2db.lib.impl.ProjectionExtractorImpl;
import org.gvsig.xml2db.lib.impl.StructureExtractorImpl;
import org.gvsig.xml2db.lib.impl.Xml2dbCommons;

public class DefaultXml2dbManager
implements Xml2dbManager {
    public XMLInfo extractStructure(File xml, Charset encoding, IProjection projection, Locale locale, String tablePrefix, SimpleTaskStatus status) throws IOException, FileNotFoundException {
        StructureExtractorImpl extractor = new StructureExtractorImpl();
        extractor.setTablePrefix(tablePrefix);
        XMLInfo xmlinfo = extractor.extractStructure(xml, encoding, projection, locale, SimpleTaskStatus.get((SimpleTaskStatus)status));
        return xmlinfo;
    }

    public XMLInfo extractStructure(InputStream xml, Charset encoding, IProjection projection, Locale locale, String tablePrefix, SimpleTaskStatus status) throws IOException {
        StructureExtractorImpl extractor = new StructureExtractorImpl();
        extractor.setTablePrefix(tablePrefix);
        XMLInfo xmlinfo = extractor.extractStructure(xml, encoding, projection, locale, SimpleTaskStatus.get((SimpleTaskStatus)status));
        return xmlinfo;
    }

    public XMLInfo extractStructure(Reader xml, IProjection projection, Locale locale, String tablePrefix, SimpleTaskStatus status) throws IOException {
        StructureExtractorImpl extractor = new StructureExtractorImpl();
        extractor.setTablePrefix(tablePrefix);
        XMLInfo xmlinfo = extractor.extractStructure(xml, projection, locale, SimpleTaskStatus.get((SimpleTaskStatus)status));
        return xmlinfo;
    }

    public void copyXml2Db(File xml, Charset encoding, JDBCServerExplorerParameters dbparams, String tablePrefix, SimpleTaskStatus taskStatus) {
        CopyXML2dbImpl helper = new CopyXML2dbImpl();
        taskStatus = SimpleTaskStatus.get((SimpleTaskStatus)taskStatus);
        helper.copyData(xml, encoding, dbparams, tablePrefix, taskStatus);
    }

    public void copyXml2Db(InputStream xml, Charset encoding, JDBCServerExplorerParameters dbparams, String tablePrefix, SimpleTaskStatus taskStatus) {
        CopyXML2dbImpl helper = new CopyXML2dbImpl();
        taskStatus = SimpleTaskStatus.get((SimpleTaskStatus)taskStatus);
        helper.copyData(xml, encoding, dbparams, tablePrefix, taskStatus);
    }

    public JDBCServerExplorerParameters createDatabase(String dbprovider, File dbfile, XMLInfo xmlinfo, SimpleTaskStatus taskStatus) {
        return this.addToDatabase(dbprovider, dbfile, xmlinfo, taskStatus, true);
    }

    public JDBCServerExplorerParameters addToDatabase(String dbprovider, File dbfile, XMLInfo xmlinfo, SimpleTaskStatus taskStatus) {
        return this.addToDatabase(dbprovider, dbfile, xmlinfo, taskStatus, false);
    }

    private JDBCServerExplorerParameters addToDatabase(String dbprovider, File dbfile, XMLInfo xmlinfo, SimpleTaskStatus taskStatus, boolean createDB) {
        try {
            taskStatus = SimpleTaskStatus.get((SimpleTaskStatus)taskStatus);
            DataManager dataManager = DALLocator.getDataManager();
            String repoID = xmlinfo.getRepositoryID();
            if (StringUtils.isBlank((CharSequence)repoID)) {
                repoID = FilenameUtils.getBaseName((String)dbfile.getName());
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            taskStatus.message(i18n.getTranslation("_Creating_database"));
            taskStatus.setIndeterminate();
            if (StringUtils.isBlank((CharSequence)dbprovider)) {
                dbprovider = "H2Spatial";
            }
            PersonalDatabaseServerExplorerFactory factory = (PersonalDatabaseServerExplorerFactory)dataManager.getServerExplorerRegister().getFactory(dbprovider);
            JDBCServerExplorerParameters serverParams = (JDBCServerExplorerParameters)dataManager.createServerExplorerParameters(dbprovider);
            ((HasAFile)serverParams).setFile(dbfile);
            DatabaseWorkspaceManager dbworkspace = dataManager.createDatabaseWorkspaceManager((DataServerExplorerParameters)serverParams);
            JDBCServerExplorer server = (JDBCServerExplorer)dbworkspace.getServerExplorer();
            if (!factory.existsdb(dbfile)) {
                server.dropCaches();
            }
            if (createDB) {
                dbworkspace.create(repoID, null);
            }
            taskStatus.message(i18n.getTranslation("_Creating_tables"));
            taskStatus.setRangeOfValues(0L, (long)xmlinfo.size());
            for (XMLTableInfo tableInfo : xmlinfo) {
                String tablename = xmlinfo.getNameWithPrefix(tableInfo.getName());
                EditableFeatureType ftype = tableInfo.getFeatureType();
                JDBCNewStoreParameters tableParams = server.getAddParameters();
                tableParams.setTable(tablename);
                tableParams.setDefaultFeatureType((FeatureType)ftype);
                server.add(tableParams.getProviderName(), (NewDataStoreParameters)tableParams, false);
                taskStatus.incrementCurrentValue();
            }
            taskStatus.message(i18n.getTranslation("_Registering_tables_in_the_repository"));
            taskStatus.setRangeOfValues(0L, (long)xmlinfo.size());
            for (DataStoreParameters storeParams : server.list()) {
                JDBCStoreParameters featureStoreParams = (JDBCStoreParameters)storeParams;
                String tableName = featureStoreParams.getTable();
                if (xmlinfo.get((Object)tableName) == null) continue;
                dbworkspace.writeStoresRepositoryEntry(tableName, (DataStoreParameters)featureStoreParams);
                taskStatus.incrementCurrentValue();
            }
            return serverParams;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't create databse '" + dbfile.getAbsolutePath() + "'.", ex);
        }
    }

    public Charset detectCharset(InputStream is) {
        return Xml2dbCommons.detectCharset(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Charset detectCharset(File file) {
        Charset charset;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            charset = this.detectCharset(is);
        }
        catch (Exception ex) {
            Charset charset2;
            try {
                charset2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return charset2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return charset;
    }

    public IProjection detectProjection(File file, SimpleTaskStatus status) {
        return new ProjectionExtractorImpl().extractProjection(file, null, status);
    }
}

