/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.xml2db.lib.impl.Xml2dbCommons;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectionExtractorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectionExtractorImpl.class);

    private IProjection extractProjection(InputSource is, SimpleTaskStatus status) {
        if (is == null || is.getCharacterStream() == null) {
            throw new IllegalArgumentException("input source is null");
        }
        final MutableObject proj = new MutableObject();
        try {
            DataManager dataManager = DALLocator.getDataManager();
            I18nManager i18n = ToolsLocator.getI18nManager();
            status.message(i18n.getTranslation("_Reading_xml"));
            status.setIndeterminate();
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            SAXParser saxParser = spf.newSAXParser();
            ArrayList path = new ArrayList();
            saxParser.parse(is, new DefaultHandler(){
                private Locator locator;
                int size;
                int refreshInterval = 1;
                StringBuilder chars = new StringBuilder();

                @Override
                public void setDocumentLocator(Locator locator) {
                    this.locator = locator;
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getLocalName(i);
                        String value = attributes.getValue(i);
                        if (!StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"srid")) continue;
                        proj.setValue((Object)ProjectionExtractorImpl.this.getProjection(value));
                        if (proj.getValue() == null) continue;
                        throw new ProjectionExtractorException();
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    String value = this.chars.toString();
                    if (StringUtils.containsIgnoreCase((CharSequence)localName, (CharSequence)"srid")) {
                        proj.setValue((Object)ProjectionExtractorImpl.this.getProjection(value));
                        if (proj.getValue() != null) {
                            throw new ProjectionExtractorException();
                        }
                    }
                    this.chars.setLength(0);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    this.chars.append(ch, start, length);
                }
            });
            return null;
        }
        catch (ProjectionExtractorException ex) {
            return (IProjection)proj.getValue();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't extract projection.", ex);
        }
    }

    private IProjection getProjection(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        IProjection proj = null;
        try {
            proj = CRSFactory.getCRS((String)value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (proj != null) {
            return proj;
        }
        try {
            proj = CRSFactory.getCRS((String)("EPSG:" + value));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return proj;
    }

    public IProjection extractProjection(File xml, Charset charset, SimpleTaskStatus status) {
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        return this.extractProjection(is, status);
    }

    public IProjection extractProjection(InputStream xml, Charset charset, SimpleTaskStatus status) {
        InputSource is = Xml2dbCommons.openReader(xml, charset);
        return this.extractProjection(is, status);
    }

    public IProjection extractProjection(Reader reader, SimpleTaskStatus status) {
        InputSource is = new InputSource(reader);
        return this.extractProjection(is, status);
    }

    private static class ProjectionExtractorException
    extends RuntimeException {
        private ProjectionExtractorException() {
        }
    }
}

