/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.lib.impl.xmlinfo;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.tools.util.CompareUtils;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLInfo;
import org.gvsig.xml2db.lib.api.xmlinfo.XMLTableInfo;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLAttributeInfoImpl;
import org.gvsig.xml2db.lib.impl.xmlinfo.XMLTableInfoImpl;

public class XMLInfoImpl
implements XMLInfo {
    private final Map<String, XMLAttributeInfoImpl> tags = new LinkedHashMap<String, XMLAttributeInfoImpl>();
    private final Map<String, XMLTableInfo> tables = new LinkedHashMap<String, XMLTableInfo>();
    private IProjection srid;
    private long countLines = -1L;
    private String repositoryID;
    private Charset charset;
    private Locale locale;
    private String tablePrefix;

    public IProjection getSrid() {
        return this.srid;
    }

    public void setSrid(IProjection srid) {
        this.srid = srid;
    }

    public XMLAttributeInfoImpl getTag(String path) {
        return this.tags.get(path);
    }

    public Collection<String> getTagsPaths() {
        return this.tags.keySet();
    }

    public void addTag(XMLAttributeInfoImpl info) {
        this.tags.put(info.getPath(), info);
    }

    public XMLAttributeInfoImpl getTagInfo(String path) {
        return this.tags.get(path);
    }

    public void addTable(XMLTableInfoImpl tableInfo) {
        this.tables.put(tableInfo.getPath(), tableInfo);
    }

    public XMLTableInfoImpl getTableByPath(String path) {
        return (XMLTableInfoImpl)this.tables.get(path);
    }

    public boolean existsTableByPath(String path) {
        return this.tables.containsKey(path);
    }

    public int size() {
        return this.tables.size();
    }

    public XMLTableInfo get(String name) {
        XMLTableInfo tableInfo;
        Iterator<XMLTableInfo> iterator = this.iterator();
        while (iterator.hasNext()) {
            tableInfo = iterator.next();
            if (!StringUtils.equals((CharSequence)name, (CharSequence)tableInfo.getName())) continue;
            return tableInfo;
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            tableInfo = iterator.next();
            if (!StringUtils.equals((CharSequence)name, (CharSequence)this.getNameWithPrefix(tableInfo.getName()))) continue;
            return tableInfo;
        }
        return null;
    }

    public List<String> getKeys() {
        ArrayList<String> names = new ArrayList<String>(this.tables.keySet());
        names.sort(CompareUtils.EQUALS_IGNORECASE_COMPARATOR);
        return names;
    }

    public Iterator<XMLTableInfo> iterator() {
        return this.tables.values().iterator();
    }

    public boolean isEmpty() {
        return this.tables.isEmpty();
    }

    public void setCountLines(long countlines) {
        this.countLines = countlines;
    }

    public long getCountLines() {
        return this.countLines;
    }

    public String getRepositoryID() {
        return this.repositoryID;
    }

    public void setRepositoryID(String id) {
        this.repositoryID = id;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public boolean hasGeometries() {
        Iterator<XMLTableInfo> iterator = this.iterator();
        while (iterator.hasNext()) {
            XMLTableInfo tableInfo = iterator.next();
            for (FeatureAttributeDescriptor ft : tableInfo.getFeatureType()) {
                if (ft.getType() != 66) continue;
                return true;
            }
        }
        return false;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public String getNameWithPrefix(String name) {
        return StringUtils.join((Object[])new String[]{this.tablePrefix, name});
    }
}

