/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.util.Observer;
import org.gvsig.tools.swing.impl.ClipboardMonitor;
import org.gvsig.tools.util.Invocable;

public class ClipboardImpl {
    private Invocable cutAction = null;

    public void put(String data) {
        this.cutAction = null;
        ClipboardMonitor.getMonitor().put(data);
    }

    public String get() {
        String n = ClipboardMonitor.getMonitor().getString();
        return n;
    }

    public void copy(String data) {
        this.put(data);
    }

    public void cut(String data, Invocable action) {
        this.put(data);
        this.cutAction = action;
    }

    public Invocable getCutAction() {
        return this.cutAction;
    }

    public Invocable resetCutAction() {
        Invocable action = this.cutAction;
        this.cutAction = null;
        return action;
    }

    public String paste() {
        String n = this.get();
        Invocable cut = this.getCutAction();
        if (cut != null) {
            try {
                cut.call(new Object[]{n});
            }
            catch (Throwable th) {
                throw new RuntimeException("Can't cut clipboard element.", th);
            }
            finally {
                this.resetCutAction();
            }
        }
        return n;
    }

    public boolean isEmpty() {
        return ClipboardMonitor.getMonitor().hasString();
    }

    public void addObserver(Observer observer) {
        ClipboardMonitor.getMonitor().addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        ClipboardMonitor.getMonitor().deleteObserver(observer);
    }
}

