/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.FilteredModel;
import org.gvsig.tools.swing.api.FilteredTreeModel;
import org.gvsig.tools.swing.api.TreeModelRecursiveWildcarMatchFilter;

public final class FilteredTreeModelImpl
implements FilteredTreeModel {
    private final TreeModel treeModel;
    private FilteredModel.FilterFunction filterfn;
    protected EventListenerList listenerList = new EventListenerList();
    private String filter;
    private boolean caseSensitive;

    public FilteredTreeModelImpl(TreeModel treeModel) {
        this.treeModel = treeModel;
        this.filterfn = new TreeModelRecursiveWildcarMatchFilter((FilteredTreeModel)this);
    }

    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    public Object getRoot() {
        return this.treeModel.getRoot();
    }

    public Object getChild(Object parent, int index) {
        int count = 0;
        int childCount = this.treeModel.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.treeModel.getChild(parent, i);
            if (!this.filterfn.test((Object)this.treeModel, child, this.filter)) continue;
            if (count == index) {
                return child;
            }
            ++count;
        }
        return null;
    }

    public int getChildCount(Object parent) {
        int count = 0;
        int childCount = this.treeModel.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.treeModel.getChild(parent, i);
            if (!this.filterfn.test((Object)this.treeModel, child, this.filter)) continue;
            ++count;
        }
        return count;
    }

    public boolean isLeaf(Object node) {
        return this.treeModel.isLeaf(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.treeModel.valueForPathChanged(path, newValue);
    }

    public int getIndexOfChild(Object parent, Object childToFind) {
        int childCount = this.treeModel.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object child = this.treeModel.getChild(parent, i);
            if (!this.filterfn.test((Object)this.treeModel, child, this.filter) || !childToFind.equals(child)) continue;
            return i;
        }
        return -1;
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
        this.treeModel.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
        this.treeModel.removeTreeModelListener(l);
    }

    private void fireTreeStructureChanged(Object source, TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (e == null) {
                e = new TreeModelEvent(source, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = StringUtils.isBlank((CharSequence)filter) ? null : (StringUtils.containsAny((CharSequence)filter, (CharSequence)"*?") ? filter : "*" + filter + "*");
        TreePath tp = new TreePath(new Object[]{this.getRoot()});
        this.fireTreeStructureChanged(this, tp);
    }

    public void setFilterFunction(FilteredModel.FilterFunction filter) {
        this.filterfn = filter == null ? (model, value, filter1) -> true : filter;
        TreePath tp = new TreePath(new Object[]{this.getRoot()});
        this.fireTreeStructureChanged(this, tp);
    }

    public void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

