/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bookmarkshistory;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultBookmarksController;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultHistoryPanel;
import org.gvsig.tools.util.LabeledValue;

public class DefaultHistoryController<T>
extends DefaultActionListenerSupport
implements HistoryController<T> {
    private final JButton button;
    private History<T> history;
    private Predicate filter;

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(DefaultBookmarksController.class, (String)"/org/gvsig/tools/swing/bookmarkandhistory", (String)"ToolsSwing", (String[][])new String[][]{{"picker", "picker-history", "Historico"}});
        ToolsSwingUtils.registerSubgroupIconDescription((String)"picker", (String)"Historico", (String)"Permite acceder al hist\u00f3rico del dialogo o componente en el que se encuentra. Por ejemplo en la ficha de b\u00fasqueda permite acceder a las b\u00fasquedas anteriores, o junto al bot\u00f3n del constructor de expresiones permite acceder al hist\u00f3rico de las expresiones introducidas.");
    }

    public DefaultHistoryController(History<T> history, JButton button) {
        this.history = history;
        this.button = button;
        if (this.button != null) {
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.button, null, (String)"picker-history", e -> this.doHistory(), null);
        }
    }

    public void setHistory(History<T> history) {
        this.history = history;
    }

    private void doHistory() {
        JPopupMenu popup = this.createMenu().getPopupMenu();
        Point p = this.button.getLocationOnScreen();
        popup.show(this.button, 0, this.button.getHeight());
    }

    public JMenu createMenu() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        JMenu menu = new JMenu(i18n.getTranslation("_History"));
        boolean needSeparator = false;
        if (!this.history.isEmpty()) {
            for (Object value : this.history.toList()) {
                if (value == null) continue;
                JMenuItem item = this.createHistoryMenuItem(value);
                if (this.filter != null && !this.filter.test(value)) {
                    item.setEnabled(false);
                }
                menu.add(item);
                needSeparator = true;
            }
        }
        if (needSeparator) {
            menu.addSeparator();
            needSeparator = false;
        }
        JMenuItem showAllHistory = new JMenuItem(i18n.getTranslation("_Show_all_history"));
        showAllHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultHistoryController.this.doShowHistoryDialog();
            }
        });
        menu.add(showAllHistory);
        needSeparator = true;
        return menu;
    }

    private JMenuItem createHistoryMenuItem(final T value) {
        String label = value instanceof LabeledValue ? ((LabeledValue)value).getLabel() : value.toString();
        label = StringUtils.abbreviate((String)label, (int)45);
        JMenuItem item = new JMenuItem(label);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryEventImpl<Object> event = new HistoryEventImpl<Object>(this, 1001, "set-value");
                if (value != null) {
                    event.setCurrentValue(value);
                    DefaultHistoryController.this.fireActionEvent(event);
                }
            }
        });
        return item;
    }

    private void doShowHistoryDialog() {
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final DefaultHistoryPanel<T> panel = new DefaultHistoryPanel<T>(this.history);
        I18nManager i18n = ToolsLocator.getI18nManager();
        final Dialog dialog = winManager.createDialog(panel, i18n.getTranslation("History"), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() != 1) {
                    return;
                }
                Object currentValue = panel.getSelectedValue();
                if (currentValue != null) {
                    HistoryEventImpl event = new HistoryEventImpl(this, 1001, "set-value");
                    event.setCurrentValue(currentValue);
                    DefaultHistoryController.this.fireActionEvent(event);
                }
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public void setFilter(Predicate filter) {
        this.filter = filter;
    }

    public History<T> get() {
        return this.history;
    }

    public class HistoryEventImpl<T>
    extends ActionEvent
    implements HistoryController.HistoryEvent<T> {
        private T currentValue;

        public HistoryEventImpl(Object source, int id, String command) {
            super(source, id, command);
        }

        public void setCurrentValue(T value) {
            this.currentValue = value;
        }

        public T getCurrentValue() {
            return this.currentValue;
        }
    }
}

