/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bookmarkshistory;

import java.awt.Dimension;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultHistoryPanelView;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class DefaultHistoryPanel<T>
extends DefaultHistoryPanelView {
    private T currentValue;
    private final History<T> history;

    public DefaultHistoryPanel(History<T> history) {
        this.history = history;
        this.initComponents();
    }

    private void initComponents() {
        this.txtFormula.setLineWrap(true);
        this.txtFormula.setEditable(false);
        DefaultListModel<LabeledValueImpl> model = new DefaultListModel<LabeledValueImpl>();
        for (Object value : this.history) {
            String label = value instanceof LabeledValue ? ((LabeledValue)value).getLabel() : value.toString();
            label = StringUtils.abbreviate((String)label, (int)45);
            model.addElement(new LabeledValueImpl(label, value));
        }
        this.currentValue = null;
        this.lstHistory.setModel(model);
        this.lstHistory.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                LabeledValue value = (LabeledValue)DefaultHistoryPanel.this.lstHistory.getSelectedValue();
                if (value == null) {
                    return;
                }
                DefaultHistoryPanel.this.currentValue = value.getValue();
                String label = DefaultHistoryPanel.this.currentValue instanceof LabeledValue ? ((LabeledValue)DefaultHistoryPanel.this.currentValue).getLabel() : DefaultHistoryPanel.this.currentValue.toString();
                DefaultHistoryPanel.this.txtFormula.setText(label);
                DefaultHistoryPanel.this.txtFormula.setCaretPosition(0);
            }
        });
        this.setPreferredSize(new Dimension(500, 400));
    }

    public T getSelectedValue() {
        return this.currentValue;
    }
}

