/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.dynclass;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynClass_v2;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynField_v2;
import org.gvsig.tools.script.Script;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.dynclass.DynClassView;
import org.gvsig.tools.swing.impl.dynclass.DynFieldControler;
import org.gvsig.tools.swing.impl.dynclass.SwingHelper;
import org.gvsig.tools.swing.impl.dynclass.TagsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynClassControler
extends DynClassView {
    private static final Logger logger = LoggerFactory.getLogger(DynClassControler.class);
    private static final long serialVersionUID = -8466988085759982503L;
    private final TagsHelper tags;
    private List<DynField_v2> fields;
    private final WindowManager_v2 windowManager;

    public DynClassControler(WindowManager_v2 windowManager) {
        this.tags = new TagsHelper(windowManager);
        this.windowManager = windowManager;
        this.initComponents();
    }

    private void initComponents() {
        this.tags.bind(this.tblTags, this.btnDeleteTag, this.btnAddTag, this.btnModifyTag);
        this.btnModifyField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynClassControler.this.modifyCurrentField();
            }
        });
        this.btnDeleteField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynClassControler.this.deleteCurrentField();
            }
        });
        this.btnAddField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynClassControler.this.addField();
            }
        });
    }

    public void set(DynClass_v2 dynClass) {
        this.txtName.setText(dynClass.getName());
        this.txtDescription.setText(dynClass.getDescription());
        this.txtNamespace.setText(dynClass.getNamespace());
        this.txtLabel.setText(dynClass.getLabel());
        Script script = dynClass.getScript();
        if (script != null) {
            this.txtScriptCode.setText(script.getCode());
            SwingHelper.setText(this.cboScriptLanguage, script.getTypeName());
        }
        this.tags.set(dynClass.getTags());
        this.fields = new ArrayList<DynField_v2>();
        for (DynField field : dynClass.getDeclaredDynFields()) {
            try {
                this.fields.add((DynField_v2)field.clone());
            }
            catch (CloneNotSupportedException ex) {
                logger.warn("Can't clone dynfield", (Throwable)ex);
            }
        }
        Collections.sort(this.fields, new Comparator<DynField_v2>(){

            @Override
            public int compare(DynField_v2 o1, DynField_v2 o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
        this.tblFields.setModel(new FieldTableModel());
    }

    private void deleteCurrentField() {
        int row = this.tblFields.getSelectedRow();
        if (row < 0) {
            return;
        }
        this.fields.remove(row);
    }

    private void addField() {
        final DynFieldControler panel = new DynFieldControler(this.windowManager);
        panel.clear();
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Field - New", null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    String fieldName = panel.getFieldName();
                    if (fieldName == null) {
                        return;
                    }
                    DynField field = ToolsLocator.getDynObjectManager().createDynField(fieldName);
                    panel.fetch(field);
                    DynClassControler.this.fields.add((DynField_v2)field);
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    private void modifyCurrentField() {
        int row = this.tblFields.getSelectedRow();
        final DynField_v2 field = this.fields.get(row);
        final DynFieldControler panel = new DynFieldControler(this.windowManager);
        panel.set((DynField)field);
        final Dialog dialog = this.windowManager.createDialog((JComponent)panel, "Field - " + field.getName(), null, 3);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (dialog.getAction() == 1) {
                    panel.fetch((DynField)field);
                }
            }
        });
        dialog.show(WindowManager.MODE.WINDOW);
    }

    public String getClassName() {
        return this.txtName.getText();
    }

    public void fetch(DynClass dynClass) {
        dynClass.setNamespace(this.txtNamespace.getText());
        dynClass.setDescription(this.txtDescription.getText());
        for (DynField_v2 field : this.fields) {
            DynField_v2 target = (DynField_v2)dynClass.getDeclaredDynField(field.getName());
            if (target == null) continue;
            target.copyFrom((DynField)field);
        }
    }

    private class FieldTableModel
    implements TableModel {
        String[] header = new String[]{"Label", "Name", "Type", "Order", "Hidden", "Read-only"};
        Class[] columClasses = new Class[]{String.class, String.class, String.class, Integer.class, Boolean.class, Boolean.class};
        private static final int FIELD_LABEL = 0;
        private static final int FIELD_NAME = 1;
        private static final int FIELD_TYPE = 2;
        private static final int FIELD_ORDER = 3;
        private static final int FIELD_HIDDEN = 4;
        private static final int FIELD_READONY = 5;

        @Override
        public int getRowCount() {
            return DynClassControler.this.fields.size();
        }

        @Override
        public int getColumnCount() {
            return this.header.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.header[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.columClasses[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            DynField_v2 field = (DynField_v2)DynClassControler.this.fields.get(rowIndex);
            switch (columnIndex) {
                case 4: {
                    return field.isHidden();
                }
                case 0: {
                    return field.getLabel();
                }
                case 1: {
                    return field.getName();
                }
                case 3: {
                    return field.getOder();
                }
                case 5: {
                    return field.isReadOnly();
                }
                case 2: {
                    return field.getDataType().getName();
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

