/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexTable;

class HexEditorRowHeader
extends JList
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private HexTable table;
    private RowHeaderListModel model;
    private static final Border CELL_BORDER = BorderFactory.createEmptyBorder(0, 5, 0, 5);

    public HexEditorRowHeader(HexTable table) {
        this.table = table;
        this.model = new RowHeaderListModel();
        this.setModel(this.model);
        this.setFocusable(false);
        this.setFont(table.getFont());
        this.setFixedCellHeight(table.getRowHeight());
        this.setCellRenderer(new CellRenderer());
        this.setBorder(new RowHeaderBorder());
        this.setSelectionMode(1);
        this.syncRowCount();
        table.getModel().addTableModelListener(this);
    }

    @Override
    public void addSelectionInterval(int anchor, int lead) {
        super.addSelectionInterval(anchor, lead);
        int min = Math.min(anchor, lead);
        int max = Math.max(anchor, lead);
        this.table.setSelectedRows(min, max);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        super.removeSelectionInterval(index0, index1);
        int anchor = this.getAnchorSelectionIndex();
        int lead = this.getLeadSelectionIndex();
        this.table.setSelectedRows(Math.min(anchor, lead), Math.max(anchor, lead));
    }

    @Override
    public void setSelectionInterval(int anchor, int lead) {
        super.setSelectionInterval(anchor, lead);
        int min = Math.min(anchor, lead);
        int max = Math.max(anchor, lead);
        if (max < this.table.getRowCount()) {
            this.table.setSelectedRows(min, max);
        }
    }

    private void syncRowCount() {
        if (this.table.getRowCount() != this.model.getSize()) {
            this.model.setSize(Math.max(1, this.table.getRowCount()));
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.syncRowCount();
    }

    private class RowHeaderBorder
    extends EmptyBorder {
        private static final long serialVersionUID = 1L;

        public RowHeaderBorder() {
            super(0, 0, 0, 2);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            x = x + width - this.right;
            g.setColor(HexEditorRowHeader.this.table.getGridColor());
            g.drawLine(x, y, x, y + height);
        }
    }

    private static class RowHeaderListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;
        private int size;

        private RowHeaderListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return "0x" + Integer.toHexString(index * 16);
        }

        @Override
        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            int old = this.size;
            this.size = size;
            int diff = size - old;
            if (diff > 0) {
                this.fireIntervalAdded(this, old, size - 1);
            } else if (diff < 0) {
                this.fireIntervalRemoved(this, size + 1, old - 1);
            }
        }
    }

    private class CellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public CellRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, false, hasFocus);
            this.setBorder(CELL_BORDER);
            return this;
        }
    }
}

