/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.icontheme;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.packageutils.PackageManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.impl.icontheme.BaseIconTheme;

public class FolderIconTheme
extends BaseIconTheme {
    protected File resource = null;
    protected PackageInfo packageInfo = null;

    public FolderIconTheme(IconTheme def) {
        super(def);
    }

    @Override
    public void load(Object resource) throws IllegalArgumentException {
        if (!(resource instanceof File)) {
            throw new IllegalArgumentException();
        }
        File res = (File)resource;
        if (!res.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.resource = res;
        this.iconList = null;
        this.loadPackageInfo();
        this.setID(this.packageInfo.getID());
        this.setName(this.packageInfo.getName());
        this.setDescription(this.packageInfo.getDescription());
    }

    private void loadPackageInfo() {
        File pkgfile = new File(this.resource, "package.info");
        PackageManager manager = ToolsLocator.getPackageManager();
        try {
            this.packageInfo = manager.createPackageInfo(pkgfile.toURI().toURL().openStream());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    protected void deferredLoad() {
        if (this.iconList != null) {
            return;
        }
        this.iconList = new HashMap();
        this.load(this.resource, "");
        File[] files = this.resource.listFiles();
        for (int i = files.length - 1; i >= 0; --i) {
            if (!files[i].isDirectory()) continue;
            this.load(files[i], files[i].getName());
        }
    }

    private void load(File folder, String group) {
        File[] imagefiles = folder.listFiles(new ImageFileFilter());
        for (int i = imagefiles.length - 1; i >= 0; --i) {
            String name = this.computeKey(imagefiles[i].getName());
            try {
                this.register(null, group, name, null, imagefiles[i].toURI().toURL());
                continue;
            }
            catch (MalformedURLException e) {
                logger.info("Can't load icon", (Throwable)e);
            }
        }
    }

    private String computeKey(String fileName) {
        int pointPos = fileName.lastIndexOf(".");
        if (pointPos != -1) {
            return fileName.substring(0, pointPos);
        }
        return fileName;
    }

    @Override
    public boolean matchID(String id) {
        return this.packageInfo.matchID(id);
    }

    private class ImageFileFilter
    implements FilenameFilter {
        private ImageFileFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            String extension = "";
            int pointPos = fileName.lastIndexOf(".");
            if (pointPos > 0 && pointPos < fileName.length() - 1) {
                extension = fileName.substring(pointPos + 1).toLowerCase();
            }
            return extension.equals("jpg") || extension.equals("jpeg") || extension.equals("png") || extension.equals("gif");
        }
    }
}

