/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.ColorPickerController;

public class ColorPickerControllerImpl
extends AbstractPickerController<Color>
implements ColorPickerController {
    private final JTextComponent txtLabel;
    private final JButton btnShowDialog;
    private final JSlider sldAlpha;
    private Color color;
    private boolean allowNull;

    public static void selfRegister() {
    }

    public ColorPickerControllerImpl(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha, boolean allowNull) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.txtLabel = txtLabel;
        this.btnShowDialog = btnShowDialog;
        this.sldAlpha = sldAlpha;
        this.txtLabel.setEditable(false);
        this.btnShowDialog.setCursor(Cursor.getPredefinedCursor(12));
        this.btnShowDialog.setIcon(this.getIcon("picker-color"));
        if (this.btnShowDialog.getText().equals("...")) {
            this.btnShowDialog.setText("");
        }
        if (StringUtils.isBlank((CharSequence)this.btnShowDialog.getToolTipText())) {
            this.btnShowDialog.setToolTipText(i18n.getTranslation("_Color_picker"));
        }
        for (ActionListener actionListener : btnShowDialog.getActionListeners()) {
            btnShowDialog.removeActionListener(actionListener);
        }
        if (this.sldAlpha != null) {
            for (EventListener eventListener : sldAlpha.getChangeListeners()) {
                sldAlpha.removeChangeListener((ChangeListener)eventListener);
            }
        }
        this.btnShowDialog.addActionListener(e -> this.doShowDialog());
        if (this.sldAlpha != null) {
            this.sldAlpha.setMinimum(0);
            this.sldAlpha.setMaximum(255);
            this.sldAlpha.addChangeListener(e -> this.doAlphaChanged());
        }
        Font font = this.txtLabel.getFont();
        try {
            font = new Font("Monospaced", 0, font.getSize());
            this.txtLabel.setFont(font);
        }
        catch (Exception ex) {
            font = null;
        }
        this.allowNull = allowNull;
        if (!this.allowNull) {
            this.color = Color.BLACK;
        }
    }

    public ColorPickerControllerImpl(JTextComponent txtLabel, JButton btnShowDialog) {
        this(txtLabel, btnShowDialog, null, false);
    }

    public ColorPickerControllerImpl(JTextComponent txtLabel, JButton btnShowDialog, JSlider sldAlpha) {
        this(txtLabel, btnShowDialog, sldAlpha, false);
    }

    public boolean isEmpty() {
        return this.color == null;
    }

    private void doAlphaChanged() {
        if (!this.isEditable()) {
            return;
        }
        if (this.color == null) {
            this.set(Color.BLACK);
        }
        if (this.sldAlpha == null) {
            this.set(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue()));
        } else {
            int alpha = this.sldAlpha.getValue();
            this.set(new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha));
        }
    }

    protected void doShowDialog() {
        if (!this.isEditable()) {
            return;
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        Color c = JColorChooser.showDialog(SwingUtilities.windowForComponent(this.btnShowDialog), i18n.getTranslation("choose_color"), this.get());
        if (c == null) {
            return;
        }
        this.set(c);
    }

    public void set(Color color) {
        if (color == null) {
            if (this.allowNull) {
                this.color = null;
                return;
            }
            color = Color.BLACK;
        }
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        this.color = color;
        String text = String.format("%02x %02x%02x%02x", color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        this.txtLabel.setBackground(manager.opaqueColor(this.color));
        this.txtLabel.setText(text);
        if (this.sldAlpha != null) {
            this.sldAlpha.setValue(this.color.getAlpha());
        }
        this.txtLabel.invalidate();
    }

    public Color get() {
        return this.color;
    }

    public void setEnabled(boolean enabled) {
        this.txtLabel.setEnabled(enabled);
        this.btnShowDialog.setEnabled(enabled);
        if (this.sldAlpha != null) {
            this.sldAlpha.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        return this.btnShowDialog.isEnabled();
    }

    public void coerceAndSet(Object value) {
        this.set((Color)this.coerce(96, value, null));
    }
}

