/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JSpinner;
import javax.swing.text.JTextComponent;
import javax.swing.text.MaskFormatter;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.pickercontroller.TimestampPickerController;
import org.gvsig.tools.swing.impl.pickercontroller.DatePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.TimePickerControllerImpl;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableSpinnerUtils;

public class TimestampPickerControllerImpl
extends AbstractPickerController<Timestamp>
implements TimestampPickerController {
    private final DatePickerControllerImpl dateController;
    private final TimePickerControllerImpl timeController;
    private final JSpinner spnMileseconds;

    public static void selfRegister() {
    }

    public TimestampPickerControllerImpl(JTextComponent txtDate, JButton btnDate, JSpinner spnTime, JSpinner spnMileseconds) {
        this.dateController = new DatePickerControllerImpl(txtDate, btnDate);
        this.timeController = new TimePickerControllerImpl(spnTime);
        if (spnMileseconds == null) {
            spnMileseconds = new JSpinner();
        }
        this.spnMileseconds = spnMileseconds;
        NullableSpinnerUtils.ofIntegers(this.spnMileseconds, 0, 0, 999, 1);
    }

    public void uninstall() {
        this.dateController.uninstall();
        this.timeController.uninstall();
    }

    public boolean isValid() {
        return this.dateController.isValid() && this.timeController.isValid();
    }

    public boolean isEmpty() {
        return this.dateController.isEmpty() && this.timeController.isEmpty();
    }

    public Timestamp get() {
        Time time = this.timeController.get();
        Date date = this.dateController.get();
        if (date == null || time == null) {
            return null;
        }
        int millis = 0;
        if (this.spnMileseconds.isVisible()) {
            if (this.spnMileseconds.getValue() == null) {
                return null;
            }
            millis = ((Number)this.spnMileseconds.getValue()).intValue();
        }
        Timestamp timestamp = new Timestamp(date.getYear(), date.getMonth(), date.getDate(), time.getHours(), time.getMinutes(), time.getSeconds(), millis);
        return timestamp;
    }

    public void set(Timestamp timestamp) {
        if (timestamp == null) {
            this.dateController.set(null);
            this.timeController.set(null);
            this.spnMileseconds.setValue(null);
            return;
        }
        Time time = new Time(timestamp.getTime());
        Date date = new Date(timestamp.getTime());
        this.dateController.set(date);
        this.timeController.set(time);
    }

    public void setEnabled(boolean enabled) {
        this.dateController.setEnabled(enabled);
        this.timeController.setEnabled(enabled);
        this.spnMileseconds.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.dateController.isEnabled();
    }

    public void coerceAndSet(Object value) {
        this.set((Timestamp)this.coerce(11, value, new Timestamp(new Date().getTime())));
    }

    public DateFormat getDateFormat() {
        return this.dateController.getDateFormat();
    }

    public MaskFormatter getMask() {
        return this.dateController.getMask();
    }

    public void setEmptyText(String emptyText) {
        this.dateController.setEmptyText(emptyText);
    }
}

