/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.task;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public class DefaultJTaskStatusController
implements TaskStatusController,
Observer {
    private JLabel titlelabel = null;
    private JLabel messagelabel = null;
    private String fullMessage = null;
    private JProgressBar progressBar = null;
    private JButton cancelRequestButton = null;
    private JButton removeTaskButton;
    private boolean showCancelButton;
    private boolean showRemoveTaskButton;
    private TaskStatus bindedTaskStatus;
    private TaskStatusManager bindedTaskStatusManager;
    private Color messagelabelForegroundColor;

    public DefaultJTaskStatusController(TaskStatus taskStatus, JLabel titlelabel, JLabel messagelabel, JProgressBar progressBar, JButton cancelRequestButton, JButton removeTaskButton) {
        this.titlelabel = titlelabel;
        this.messagelabel = messagelabel;
        this.progressBar = progressBar;
        this.cancelRequestButton = cancelRequestButton;
        this.removeTaskButton = removeTaskButton;
        this.bindedTaskStatus = null;
        this.showCancelButton = true;
        this.bind(taskStatus);
        this.initComponents();
    }

    public DefaultJTaskStatusController(TaskStatus taskStatus, JLabel titlelabel, JLabel messagelabel, JProgressBar progressBar) {
        this(taskStatus, titlelabel, messagelabel, progressBar, null, null);
    }

    public DefaultJTaskStatusController(JLabel titlelabel, JLabel messagelabel, JProgressBar progressBar) {
        this(null, titlelabel, messagelabel, progressBar, null, null);
    }

    private void initComponents() {
        if (this.messagelabel == null) {
            this.messagelabel = new JLabel();
        }
        if (this.titlelabel == null) {
            this.titlelabel = new JLabel();
        }
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        if (this.cancelRequestButton == null) {
            this.cancelRequestButton = new JButton();
        }
        if (this.removeTaskButton == null) {
            this.removeTaskButton = new JButton();
        }
        this.progressBar.setIndeterminate(false);
        this.progressBar.setBorderPainted(true);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(0);
        this.cancelRequestButton.setIcon(this.getIcon("cancelRequestButton.png"));
        this.cancelRequestButton.setDisabledIcon(this.getIcon("disabledCancelRequestButton.png"));
        if (this.cancelRequestButton.getText().equals("...")) {
            this.cancelRequestButton.setText("");
        }
        if (!this.showCancelButton) {
            this.cancelRequestButton.setVisible(this.showCancelButton);
        }
        this.cancelRequestButton.addActionListener(arg0 -> {
            this.cancelRequestButton.setEnabled(false);
            this.bindedTaskStatus.cancelRequest();
        });
        this.removeTaskButton.setIcon(this.getIcon("removeTaskButton.png"));
        this.removeTaskButton.setDisabledIcon(this.getIcon("disabledRemoveTaskButton.png"));
        if (this.removeTaskButton.getText().equals("...")) {
            this.removeTaskButton.setText("");
        }
        this.removeTaskButton.setEnabled(true);
        this.removeTaskButton.addActionListener(arg0 -> {
            if (this.bindedTaskStatus == null) {
                return;
            }
            if (this.bindedTaskStatus.isRunning()) {
                if ((arg0.getModifiers() & 2) == 2) {
                    this.bindedTaskStatus.getManager().remove(this.bindedTaskStatus);
                }
            } else {
                this.bindedTaskStatus.getManager().remove(this.bindedTaskStatus);
            }
        });
        this.messagelabel.setCursor(new Cursor(12));
        this.messagelabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                String s = DefaultJTaskStatusController.this.fullMessage;
                if (StringUtils.isBlank((CharSequence)s)) {
                    s = DefaultJTaskStatusController.this.messagelabel.getText();
                }
                if (StringUtils.isNotBlank((CharSequence)s)) {
                    dialogs.messageDialog(s, DefaultJTaskStatusController.this.titlelabel.getText(), 1);
                }
            }
        });
        this.messagelabelForegroundColor = this.messagelabel.getForeground();
    }

    public void setVisible(boolean visible) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.setVisible(visible));
            return;
        }
        this.titlelabel.setVisible(visible);
        this.messagelabel.setVisible(visible);
        this.progressBar.setVisible(visible);
        this.cancelRequestButton.setVisible(visible);
        this.removeTaskButton.setVisible(visible);
    }

    public boolean getShowCancelButton() {
        return this.showCancelButton;
    }

    public void setShowCancelButton(boolean showCancelButton) {
        this.showCancelButton = showCancelButton;
        if (this.cancelRequestButton != null) {
            this.cancelRequestButton.setVisible(this.showCancelButton);
        }
    }

    public boolean getShowRemoveTaskButton() {
        return this.showRemoveTaskButton;
    }

    public void setShowRemoveTaskButton(boolean showRemoveTaskButton) {
        this.showRemoveTaskButton = showRemoveTaskButton;
        if (this.removeTaskButton != null) {
            this.removeTaskButton.setVisible(this.showRemoveTaskButton);
        }
    }

    public void bind(TaskStatus taskStatus) {
        if (this.cancelRequestButton != null) {
            this.cancelRequestButton.setEnabled(this.showCancelButton);
            this.cancelRequestButton.setVisible(this.showCancelButton);
        }
        if (this.bindedTaskStatus != null) {
            this.bindedTaskStatus.deleteObserver((Observer)this);
        }
        if (this.bindedTaskStatusManager != null) {
            this.bindedTaskStatusManager.deleteObserver((Observer)this);
        }
        this.bindedTaskStatus = taskStatus;
        this.bindedTaskStatusManager = null;
        if (this.bindedTaskStatus != null) {
            this.bindedTaskStatus.addObserver((Observer)this);
        }
    }

    public void bind(TaskStatusManager taskStatusManager) {
        if (this.bindedTaskStatus != null) {
            this.bindedTaskStatus.deleteObserver((Observer)this);
        }
        if (this.bindedTaskStatusManager != null) {
            this.bindedTaskStatusManager.deleteObserver((Observer)this);
        }
        this.bindedTaskStatus = null;
        this.bindedTaskStatusManager = taskStatusManager;
        if (this.bindedTaskStatusManager != null) {
            this.bindedTaskStatusManager.addObserver((Observer)this);
        }
    }

    private ImageIcon getIcon(String name) {
        URL iconurl = this.getClass().getResource(name);
        if (iconurl == null) {
            return new ImageIcon();
        }
        return new ImageIcon(iconurl);
    }

    public void update(Observable observable, Object notification) {
        String firstLine;
        TaskStatus theTaskStatus;
        if (observable == null) {
            return;
        }
        if (observable instanceof TaskStatus) {
            theTaskStatus = (TaskStatus)observable;
        } else if (observable instanceof TaskStatusManager) {
            theTaskStatus = (TaskStatus)notification;
            if (theTaskStatus == null) {
                TaskStatusManager manager = (TaskStatusManager)observable;
                theTaskStatus = manager.getRunningTaskStatusMostRecent();
            }
        } else {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.update(observable, notification));
            return;
        }
        if (theTaskStatus == null) {
            this.titlelabel.setText("");
            this.messagelabel.setText("");
            this.messagelabel.setToolTipText("");
            this.fullMessage = null;
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(100);
            this.cancelRequestButton.setEnabled(false);
            this.removeTaskButton.setEnabled(true);
            return;
        }
        if (theTaskStatus.isAborted()) {
            this.titlelabel.setText(theTaskStatus.getTitle());
            this.fullMessage = theTaskStatus.getLabel();
            firstLine = this.getFirstLine();
            this.messagelabel.setForeground(ToolsSwingLocator.getToolsSwingManager().getWarningForegroundColor());
            this.messagelabel.setText(firstLine);
            this.messagelabel.setToolTipText(this.getToolTipMsg());
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(0);
            }
            this.cancelRequestButton.setEnabled(false);
            this.removeTaskButton.setEnabled(true);
            return;
        }
        this.messagelabel.setForeground(this.messagelabelForegroundColor);
        if (theTaskStatus.isCancelled()) {
            this.titlelabel.setText(theTaskStatus.getTitle());
            this.messagelabel.setText("");
            this.messagelabel.setToolTipText("");
            this.fullMessage = null;
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setValue(100);
            }
            this.cancelRequestButton.setEnabled(false);
            this.removeTaskButton.setEnabled(true);
            return;
        }
        if (theTaskStatus.isRunning()) {
            if (theTaskStatus.getTitle() == null) {
                this.titlelabel.setText("Unknown");
            } else {
                this.titlelabel.setText(theTaskStatus.getTitle());
            }
            this.fullMessage = theTaskStatus.getLabel();
            firstLine = this.getFirstLine();
            this.messagelabel.setText(firstLine);
            this.messagelabel.setToolTipText(this.getToolTipMsg());
            if (theTaskStatus.isIndeterminate() != this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(theTaskStatus.isIndeterminate());
            }
            this.progressBar.setValue(theTaskStatus.getCompleted());
            if (!this.cancelRequestButton.isEnabled()) {
                this.cancelRequestButton.setEnabled(true);
            }
            return;
        }
        this.titlelabel.setText(theTaskStatus.getTitle());
        this.messagelabel.setText("");
        this.messagelabel.setToolTipText("");
        this.fullMessage = null;
        if (this.progressBar.isIndeterminate()) {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(100);
        }
        this.cancelRequestButton.setEnabled(false);
        this.removeTaskButton.setEnabled(true);
    }

    private String getFirstLine() {
        String firstLine = "";
        if (StringUtils.isNotBlank((CharSequence)this.fullMessage)) {
            firstLine = this.fullMessage;
            if (StringUtils.containsIgnoreCase((CharSequence)firstLine, (CharSequence)"<html>")) {
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<html>", (String)"");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"</html>", (String)"");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<p>", (String)"");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"</p>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<br>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<br/>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<ul>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"</ul>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<li>", (String)"");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"</li>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"<ol>", (String)"\n");
                firstLine = StringUtils.replaceIgnoreCase((String)firstLine, (String)"</ol>", (String)"\n");
                firstLine = StringUtils.split((String)firstLine, (String)"\n")[0];
                firstLine = "<html>" + firstLine.trim() + "</html>";
            } else {
                firstLine = StringUtils.split((String)firstLine, (String)"\n")[0];
                firstLine = firstLine.trim();
            }
        }
        return firstLine;
    }

    private String getToolTipMsg() {
        if (StringUtils.isBlank((CharSequence)this.fullMessage)) {
            return "";
        }
        String m = this.fullMessage;
        if (StringUtils.containsIgnoreCase((CharSequence)m, (CharSequence)"<html>")) {
            m = StringUtils.replaceIgnoreCase((String)m, (String)"<html>", (String)("<html><table width=\"" + ToolsSwingUtils.cols2px((int)100) + "\"><tr><td>"));
            m = StringUtils.replaceIgnoreCase((String)m, (String)"</html>", (String)"</td></tr></table></html>");
        } else {
            m = "<html><table width=\"" + ToolsSwingUtils.cols2px((int)100) + "\"><tr><td>" + StringUtils.replaceIgnoreCase((String)m, (String)"\n", (String)"<br>") + "</td></tr></table></html>";
        }
        return m;
    }

    public TaskStatus getTaskStatus() {
        return this.bindedTaskStatus;
    }

    public SimpleTaskStatus getSimpleTaskStatus() {
        return (SimpleTaskStatus)this.bindedTaskStatus;
    }

    public void setTitle(String title) {
        if (this.bindedTaskStatus instanceof SimpleTaskStatus) {
            ((SimpleTaskStatus)this.bindedTaskStatus).setTitle(title);
        } else {
            this.titlelabel.setText(title);
        }
    }

    public void message(String message) {
        if (this.bindedTaskStatus instanceof SimpleTaskStatus) {
            ((SimpleTaskStatus)this.bindedTaskStatus).message(message);
        } else {
            this.messagelabel.setText(message);
        }
    }

    public void setCurValue(long value) {
        if (this.bindedTaskStatus instanceof SimpleTaskStatus) {
            ((SimpleTaskStatus)this.bindedTaskStatus).setCurValue(value);
        }
    }
}

