/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.editor;

import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.DynFieldEditor;
import org.gvsig.tools.swing.impl.usability.spinner.editor.DynFieldFormatter;

public class DefaultDynFieldEditor
implements DynFieldEditor {
    private DynField dynField;
    private DynFieldFormatter formatter;
    private JSpinner spinner;
    private JFormattedTextField tf;
    private static Format numberFormat = new DecimalFormat();

    public DefaultDynFieldEditor(FocusListener listener, DynField field, Locale locale) {
        this.dynField = field;
        this.formatter = DynFieldFormatter.getInstance(this.dynField, locale);
        this.spinner = this.createSpinner();
        this.spinner.setLocale(locale);
        this.tf = ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField();
        this.tf.addFocusListener(listener);
        this.setDynFieldFormat();
    }

    private JSpinner createSpinner() {
        return ToolsSwingLocator.getUsabilitySwingManager().createJNullSpinner(this.dynField.getType(), this.getDefaultValue(), -1);
    }

    public Object getDefaultValue() {
        switch (this.dynField.getType()) {
            case 9: {
                return new Date();
            }
            case 10: {
                return new Date();
            }
            case 11: {
                return new Date();
            }
            case 7: {
                return Float.valueOf(0.0f);
            }
            case 6: {
                return Float.valueOf(0.0f);
            }
        }
        return 0;
    }

    private DynFieldFormatter getFormat() {
        return this.formatter;
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    public JFormattedTextField getTextField() {
        return this.tf;
    }

    private void setDynFieldFormat() {
        DefaultFormatterFactory factory = (DefaultFormatterFactory)this.getTextField().getFormatterFactory();
        JFormattedTextField.AbstractFormatter formatter = factory.getDefaultFormatter();
        if (this.formatter.isDate()) {
            ((DateFormatter)formatter).setFormat(this.formatter.toFormat());
        } else if (this.formatter.isNumber()) {
            ((NumberFormatter)formatter).setFormat(this.formatter.toFormat());
        }
    }

    public Object parse(String text) throws ParseException {
        return this.getFormat().parse(text);
    }

    public Object getTextFieldValue() {
        try {
            return this.parse(this.getTextField().getText());
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setTextFieldValue(Object object) {
        if (object == null) {
            this.getTextField().setText("");
            this.getTextField().updateUI();
            return;
        }
        Object value = null;
        Class<?> obj_class = object.getClass();
        if (obj_class == Double.class || obj_class == Float.class || obj_class == Integer.class || obj_class == Long.class) {
            String str = numberFormat.format(object);
            this.getTextField().setText(str);
            this.getTextField().updateUI();
            return;
        }
        try {
            value = this.parse(object.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (value == null) {
            this.getTextField().setText("");
            this.getSpinner().updateUI();
            this.getTextField().updateUI();
            return;
        }
        this.getTextField().setText(value.toString());
        this.getTextField().updateUI();
    }
}

