/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.base.core;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.tools.namestranslator.NamesTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DALFeaturePersister {
    private FeatureStore store = null;
    private String[] fieldNames = null;
    private GeometryManager geometryManager = null;
    private NamesTranslator namesTranslator = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DALFeaturePersister.class);

    public DALFeaturePersister(FeatureStore out, String[] fieldNames, NamesTranslator namesTranslator) {
        this(out, fieldNames);
        this.namesTranslator = namesTranslator;
    }

    public DALFeaturePersister(FeatureStore out, String[] fieldNames) {
        this.store = out;
        this.fieldNames = fieldNames;
        this.namesTranslator = null;
        try {
            if (this.store.getMode() == 0) {
                this.store.edit();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can't enter in edit mode. store = " + DataStore.getFullNameQuietly((DataStore)this.store));
        }
        this.geometryManager = GeometryLocator.getGeometryManager();
    }

    public String[] getFieldNames() {
        try {
            FeatureAttributeDescriptor[] attrs = this.store.getDefaultFeatureType().getAttributeDescriptors();
            String[] fieldNames = new String[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                fieldNames[i] = attrs[i].getName();
            }
            return fieldNames;
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public String[] getFieldNamesWithoutGeom() {
        try {
            FeatureAttributeDescriptor[] attrs = this.store.getDefaultFeatureType().getAttributeDescriptors();
            int nFields = attrs.length;
            for (int j = 0; j < nFields; ++j) {
                if (attrs[j].getName().compareTo("GEOMETRY") != 0) continue;
                --nFields;
                break;
            }
            int cont = 0;
            String[] fieldNames = new String[nFields];
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i].getName().compareTo("GEOMETRY") == 0) continue;
                fieldNames[cont] = attrs[i].getName();
                ++cont;
            }
            return fieldNames;
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return null;
        }
    }

    public EditableFeature addFeature(Feature feature1, Feature feature2, Geometry newGeom) throws CreateGeometryException, DataException {
        int outPutType = this.getOutputFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getType();
        ArrayList<org.gvsig.fmap.geom.Geometry> dalGeomList = null;
        try {
            dalGeomList = this.convertGeometryCollection2GeometryList(newGeom, outPutType);
        }
        catch (GeometryOperationNotSupportedException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (GeometryOperationException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        org.gvsig.fmap.geom.Geometry newDalGeom = null;
        if (dalGeomList == null) {
            GeometryOperationContext ctx = new GeometryOperationContext();
            ctx.setAttribute("JTSGeometry", (Object)newGeom);
            try {
                newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
            }
            catch (GeometryOperationNotSupportedException e) {
                Sextante.addErrorToLog((Throwable)e);
                return null;
            }
            catch (GeometryOperationException e) {
                Sextante.addErrorToLog((Throwable)e);
                return null;
            }
        }
        EditableFeature feat = this.store.createNewFeature();
        if (this.namesTranslator != null) {
            Object fValue;
            Object translation;
            String attrName;
            for (FeatureAttributeDescriptor attr1 : feature1.getType().getAttributeDescriptors()) {
                attrName = attr1.getName();
                translation = this.namesTranslator.getTranslation(attrName);
                fValue = feature1.get(attrName);
                if (translation == null || ((String)translation).isEmpty()) continue;
                feat.set((String)translation, fValue);
            }
            for (FeatureAttributeDescriptor attr2 : feature2.getType().getAttributeDescriptors()) {
                attrName = attr2.getName();
                translation = this.namesTranslator.getAllTranslations(attrName);
                fValue = feature2.get(attrName);
                if (translation == null || translation.isEmpty()) continue;
                feat.set((String)translation.get(translation.size() - 1), fValue);
            }
        } else {
            feat.copyFrom(feature1);
            feat.copyFrom(feature2);
        }
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        if (dalGeomList != null) {
            for (int i = 0; i < dalGeomList.size(); ++i) {
                if (!this.acceptType(this.store, dalGeomList.get(i))) continue;
                org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(dalGeomList.get(i));
                if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                    feat.setDefaultGeometry(multiGeometry);
                } else {
                    feat.setDefaultGeometry(dalGeomList.get(i));
                }
                this.store.insert(feat);
            }
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(Feature feature1, Feature feature2, org.gvsig.fmap.geom.Geometry newDalGeom) throws CreateGeometryException, DataException {
        EditableFeature feat = this.store.createNewFeature();
        if (this.namesTranslator != null) {
            Object fValue;
            Object translation;
            String attrName;
            for (FeatureAttributeDescriptor attr1 : feature1.getType().getAttributeDescriptors()) {
                attrName = attr1.getName();
                translation = this.namesTranslator.getTranslation(attrName);
                fValue = feature1.get(attrName);
                if (translation == null || ((String)translation).isEmpty()) continue;
                feat.set((String)translation, fValue);
            }
            for (FeatureAttributeDescriptor attr2 : feature2.getType().getAttributeDescriptors()) {
                attrName = attr2.getName();
                translation = this.namesTranslator.getAllTranslations(attrName);
                fValue = feature2.get(attrName);
                if (translation == null || translation.isEmpty()) continue;
                feat.set((String)translation.get(translation.size() - 1), fValue);
            }
        } else {
            feat.copyFrom(feature1);
            feat.copyFrom(feature2);
        }
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public ArrayList<org.gvsig.fmap.geom.Geometry> convertGeometryCollection2GeometryList(Geometry g, int type) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (g instanceof GeometryCollection && !(g instanceof MultiLineString) && !(g instanceof com.vividsolutions.jts.geom.MultiPoint) && !(g instanceof MultiPolygon)) {
            org.gvsig.fmap.geom.Geometry newDalGeom;
            GeometryOperationContext ctx;
            Geometry gx;
            int i;
            GeometryCollection col = (GeometryCollection)g;
            ArrayList<org.gvsig.fmap.geom.Geometry> geometries = new ArrayList<org.gvsig.fmap.geom.Geometry>();
            if (GeometryUtils.isSubtype((int)1, (int)type) || GeometryUtils.isSubtype((int)7, (int)type)) {
                for (i = 0; i < col.getNumGeometries(); ++i) {
                    gx = col.getGeometryN(i);
                    if (!(gx instanceof com.vividsolutions.jts.geom.Point) && !(gx instanceof com.vividsolutions.jts.geom.MultiPoint)) continue;
                    ctx = new GeometryOperationContext();
                    ctx.setAttribute("JTSGeometry", (Object)gx);
                    newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
                    geometries.add(newDalGeom);
                }
            }
            if (GeometryUtils.isSubtype((int)2, (int)type) || GeometryUtils.isSubtype((int)8, (int)type)) {
                for (i = 0; i < col.getNumGeometries(); ++i) {
                    gx = col.getGeometryN(i);
                    if (!(gx instanceof LineString) && !(gx instanceof MultiLineString)) continue;
                    ctx = new GeometryOperationContext();
                    ctx.setAttribute("JTSGeometry", (Object)gx);
                    newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
                    geometries.add(newDalGeom);
                }
            }
            if (GeometryUtils.isSubtype((int)3, (int)type) || GeometryUtils.isSubtype((int)9, (int)type)) {
                for (i = 0; i < col.getNumGeometries(); ++i) {
                    gx = col.getGeometryN(i);
                    if (!(gx instanceof Polygon) && !(gx instanceof MultiPolygon)) continue;
                    ctx = new GeometryOperationContext();
                    ctx.setAttribute("JTSGeometry", (Object)gx);
                    newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
                    geometries.add(newDalGeom);
                }
            }
            return geometries;
        }
        return null;
    }

    private org.gvsig.fmap.geom.Geometry convertGeometryList2MultiGeometry(List<org.gvsig.fmap.geom.Geometry> list) throws CreateGeometryException {
        if (list.size() == 0) {
            return null;
        }
        MultiPrimitive primitive = null;
        if (list.get(0) instanceof Point || list.get(0) instanceof MultiPoint) {
            primitive = (MultiPrimitive)this.geometryManager.create(7, 0);
        }
        if (list.get(0) instanceof Curve || list.get(0) instanceof MultiCurve) {
            primitive = (MultiPrimitive)this.geometryManager.create(8, 0);
        }
        if (list.get(0) instanceof Surface || list.get(0) instanceof MultiSurface) {
            primitive = (MultiPrimitive)this.geometryManager.create(9, 0);
        }
        for (int i = 0; i < list.size(); ++i) {
            org.gvsig.fmap.geom.Geometry geom = list.get(i);
            if (geom instanceof MultiPrimitive) {
                MultiPrimitive multi = (MultiPrimitive)geom;
                for (int j = 0; j < multi.getPrimitivesNumber(); ++j) {
                    primitive.addPrimitive(multi.getPrimitiveAt(j));
                }
                continue;
            }
            primitive.addPrimitive((Primitive)list.get(i));
        }
        return primitive;
    }

    private org.gvsig.fmap.geom.Geometry convertGeometry2MultiGeometry(org.gvsig.fmap.geom.Geometry g) throws CreateGeometryException {
        if (g instanceof MultiPrimitive) {
            return g;
        }
        if (g.getGeometryType().getSubType() != 0) {
            try {
                g = g.forceSubtype(0);
            }
            catch (Exception ex) {
                throw new CreateGeometryException(g.getGeometryType().getType(), 0, (Throwable)ex);
            }
        }
        if (g instanceof Point) {
            MultiPoint pNew = (MultiPoint)this.geometryManager.create(7, 0);
            pNew.addPoint((Point)g);
            return pNew;
        }
        if (g instanceof Curve) {
            MultiCurve cNew = (MultiCurve)this.geometryManager.create(21, 0);
            cNew.addCurve((Curve)g);
            return cNew;
        }
        if (g instanceof Surface) {
            MultiSurface cNew = (MultiSurface)this.geometryManager.create(22, 0);
            cNew.addSurface((Surface)g);
            return cNew;
        }
        return g;
    }

    private boolean acceptType(FeatureStore store, org.gvsig.fmap.geom.Geometry geom) throws ReadException {
        int fType = this.getShapeType(store);
        GeometryType geomType = geom.getGeometryType();
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        if (geomManager.isSubtype(fType, geomType.getType())) {
            return true;
        }
        if (geomManager.isSubtype(8, fType) && geomManager.isSubtype(2, geomType.getType())) {
            return true;
        }
        if (geomManager.isSubtype(9, fType) && geomManager.isSubtype(3, geomType.getType())) {
            return true;
        }
        if (geomManager.isSubtype(7, fType) && geomManager.isSubtype(1, geomType.getType())) {
            return true;
        }
        return geomManager.isSubtype(10, fType) && geomManager.isSubtype(4, geomType.getType());
    }

    public EditableFeature addFeature(Feature feature, Geometry newGeom) throws CreateGeometryException, DataException {
        int outPutType = this.getOutputFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getType();
        ArrayList<org.gvsig.fmap.geom.Geometry> dalGeomList = null;
        try {
            dalGeomList = this.convertGeometryCollection2GeometryList(newGeom, outPutType);
        }
        catch (GeometryOperationNotSupportedException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (GeometryOperationException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        if (dalGeomList == null) {
            org.gvsig.fmap.geom.Geometry newDalGeom = null;
            GeometryOperationContext ctx = new GeometryOperationContext();
            ctx.setAttribute("JTSGeometry", (Object)newGeom);
            try {
                newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geometryManager.invokeOperation("fromJTS", ctx);
            }
            catch (GeometryOperationNotSupportedException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (GeometryOperationException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            this.insertFeatureIntoStore(feature, newDalGeom);
        } else {
            for (int i = 0; i < dalGeomList.size(); ++i) {
                this.insertFeatureIntoStore(feature, dalGeomList.get(i));
            }
        }
        return null;
    }

    private EditableFeature insertFeatureIntoStore(Feature feature, org.gvsig.fmap.geom.Geometry newDalGeom) throws DataException {
        if (this.acceptType(this.store, newDalGeom)) {
            EditableFeature targetFeature = this.store.createNewFeature(this.store.getDefaultFeatureType(), true);
            for (FeatureAttributeDescriptor attrdesc : targetFeature.getType()) {
                Object value;
                if (attrdesc.isComputed() || attrdesc.getType() == 66) continue;
                String targetName = attrdesc.getName();
                String sourceName = this.namesTranslator != null ? this.namesTranslator.getSource(targetName) : targetName;
                if (feature.getType().getAttributeDescriptor(sourceName) == null || (value = feature.get(sourceName)) == null) continue;
                targetFeature.set(targetName, value);
            }
            org.gvsig.fmap.geom.Geometry multiGeometry = null;
            try {
                multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                targetFeature.setDefaultGeometry(multiGeometry);
            } else {
                targetFeature.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(targetFeature);
            return targetFeature;
        }
        return null;
    }

    public EditableFeature addFeature(Geometry newGeom, int id, double value) throws CreateGeometryException, DataException {
        org.gvsig.fmap.geom.Geometry newDalGeom = GeometryUtil.jtsToGeom(newGeom);
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            feat.set(0, (Object)id);
            feat.set(1, (Object)value);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(Feature feature, List<Geometry> newJTSListGeom) throws CreateGeometryException, DataException {
        ArrayList<org.gvsig.fmap.geom.Geometry> newDalListGeom = new ArrayList<org.gvsig.fmap.geom.Geometry>();
        for (int i = 0; i < newJTSListGeom.size(); ++i) {
            newDalListGeom.add(GeometryUtil.jtsToGeom(newJTSListGeom.get(i)));
        }
        org.gvsig.fmap.geom.Geometry newMultiGeom = this.convertGeometryList2MultiGeometry(newDalListGeom);
        this.insertFeatureIntoStore(feature, newMultiGeom);
        return null;
    }

    public EditableFeature addFeature(Geometry newGeom, String name, Object value) throws CreateGeometryException, DataException {
        org.gvsig.fmap.geom.Geometry newDalGeom = GeometryUtil.jtsToGeom(newGeom);
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            feat.set(name, value);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(org.gvsig.fmap.geom.Geometry newGeom, String name, Object value) throws CreateGeometryException, DataException {
        if (newGeom != null && this.acceptType(this.store, newGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            feat.set(name, value);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(org.gvsig.fmap.geom.Geometry newGeom, ArrayList<String> names, ArrayList<Object> values) throws CreateGeometryException, DataException {
        if (newGeom != null && this.acceptType(this.store, newGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            for (int i = 0; i < values.size(); ++i) {
                feat.set(names.get(i), values.get(i));
            }
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(Geometry newGeom, ArrayList<String> names, ArrayList<Object> values) throws CreateGeometryException, DataException {
        org.gvsig.fmap.geom.Geometry newDalGeom = GeometryUtil.jtsToGeom(newGeom);
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            for (int i = 0; i < values.size(); ++i) {
                feat.set(names.get(i), values.get(i));
            }
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(Geometry newGeom, int id, double value1, double value2) throws CreateGeometryException, DataException {
        org.gvsig.fmap.geom.Geometry newDalGeom = GeometryUtil.jtsToGeom(newGeom);
        if (newDalGeom != null && this.acceptType(this.store, newDalGeom)) {
            EditableFeature feat = this.store.createNewFeature();
            feat.set(0, (Object)id);
            feat.set(1, (Object)value1);
            feat.set(2, (Object)value2);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newDalGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newDalGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addDifferentFieldFeature(Feature feature, org.gvsig.fmap.geom.Geometry newGeom) throws CreateGeometryException, DataException {
        if (this.acceptType(this.store, newGeom)) {
            EditableFeature feat = this.store.createNewFeature(this.store.getDefaultFeatureType(), true);
            feat.copyFrom(feature);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addFeature(Feature feature, org.gvsig.fmap.geom.Geometry newGeom) throws CreateGeometryException, DataException {
        if (this.acceptType(this.store, newGeom)) {
            EditableFeature feat = this.store.createNewFeature(this.store.getDefaultFeatureType(), feature);
            org.gvsig.fmap.geom.Geometry multiGeometry = this.convertGeometry2MultiGeometry(newGeom);
            if (multiGeometry != null && this.acceptType(this.store, multiGeometry)) {
                feat.setDefaultGeometry(multiGeometry);
            } else {
                feat.setDefaultGeometry(newGeom);
            }
            this.store.insert(feat);
            return feat;
        }
        return null;
    }

    public EditableFeature addGeometryToExistingFeature(EditableFeature feature, org.gvsig.fmap.geom.Geometry newGeom) throws CreateGeometryException, DataException {
        for (String fieldName : this.fieldNames) {
            feature.set(fieldName, feature.get(fieldName));
        }
        if (this.acceptType(this.store, newGeom)) {
            feature.setDefaultGeometry(newGeom);
            this.store.update(feature);
            return feature;
        }
        return null;
    }

    public void end() {
        try {
            this.store.finishEditing();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public int getShapeType(FeatureStore storeLayer1) throws ReadException {
        FeatureType featureType;
        try {
            featureType = storeLayer1.getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new ReadException(storeLayer1.getName(), (Throwable)e);
        }
        int indexGeom = featureType.getDefaultGeometryAttributeIndex();
        return featureType.getAttributeDescriptor(indexGeom).getGeometryType();
    }

    public int getType() {
        FeatureType featureType;
        if (this.store == null) {
            return 16;
        }
        try {
            featureType = this.store.getDefaultFeatureType();
        }
        catch (DataException e) {
            return 16;
        }
        int indexGeom = featureType.getDefaultGeometryAttributeIndex();
        return featureType.getAttributeDescriptor(indexGeom).getGeometryType();
    }

    public boolean isCompatibleType(org.gvsig.fmap.geom.Geometry geom) {
        if (this.store == null) {
            return false;
        }
        try {
            return this.acceptType(this.store, geom);
        }
        catch (ReadException e) {
            return false;
        }
    }

    public FeatureStore getOutputFeatureStore() {
        return this.store;
    }
}

