/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import org.gvsig.raster.lib.legend.impl.ColorManager;

public class DefaultColorManager
implements ColorManager {
    @Override
    public double[] RGBtoHSL(int sourceRed, int sourceGreen, int sourceBlue) {
        double low;
        double hue = 0.0;
        double[] res1 = new double[3];
        double scaler = (double)sourceRed / 255.0;
        double scaleg = (double)sourceGreen / 255.0;
        double scaleb = (double)sourceBlue / 255.0;
        double high = scaler;
        if (scaleg > high) {
            high = scaleg;
        }
        if (scaleb > high) {
            high = scaleb;
        }
        if (scaleg < (low = scaler)) {
            low = scaleg;
        }
        if (scaleb < low) {
            low = scaleb;
        }
        double intens = (high + low) / 2.0;
        if (high == low) {
            double sat = 0.0;
            res1[0] = hue = 0.0;
            res1[1] = sat;
            res1[2] = intens;
        } else if (high != low) {
            double sat = intens <= 0.5 ? (high - low) / (high + low) : (high - low) / (2.0 - high - low);
            double red = (high - scaler) / (high - low);
            double green = (high - scaleg) / (high - low);
            double blue = (high - scaleb) / (high - low);
            if (scaler == high) {
                hue = blue - green;
            } else if (scaleg == high) {
                hue = 2.0 + red - blue;
            } else if (scaleb == high) {
                hue = 4.0 + green - red;
            }
            hue *= 60.0;
            if (hue < 0.0) {
                hue += 360.0;
            }
            res1[0] = hue;
            res1[1] = sat;
            res1[2] = intens;
        }
        return res1;
    }

    @Override
    public double[] RGBtoHSV(int sourceRed, int sourceGreen, int sourceBlue) {
        double low;
        double hue = 0.0;
        double[] res1 = new double[3];
        double scaler = (double)sourceRed / 255.0;
        double scaleg = (double)sourceGreen / 255.0;
        double scaleb = (double)sourceBlue / 255.0;
        double high = scaler;
        if (scaleg > high) {
            high = scaleg;
        }
        if (scaleb > high) {
            high = scaleb;
        }
        if (scaleg < (low = scaler)) {
            low = scaleg;
        }
        if (scaleb < low) {
            low = scaleb;
        }
        double value = high;
        if (high == 0.0) {
            double sat = 0.0;
            res1[0] = hue = 0.0;
            res1[1] = sat;
            res1[2] = value;
        } else {
            double sat = (high - low) / high;
            double red = (high - scaler) / (high - low);
            double green = (high - scaleg) / (high - low);
            double blue = (high - scaleb) / (high - low);
            if (scaler == high) {
                hue = blue - green;
            } else if (scaleg == high) {
                hue = 2.0 + red - blue;
            } else if (scaleb == high) {
                hue = 4.0 + green - red;
            }
            hue *= 60.0;
            if (hue < 0.0) {
                hue += 360.0;
            }
            res1[0] = hue;
            res1[1] = sat;
            res1[2] = value;
        }
        return res1;
    }

    @Override
    public int[] HSLtoRGB(int h, int s, int l) {
        int[] res = new int[3];
        if (h == s && h == 0) {
            res[1] = res[2] = l;
            res[0] = res[2];
            return res;
        }
        double blue = 0.0;
        double green = 0.0;
        double red = 0.0;
        double scalei = (double)l / 255.0;
        double scales = (double)s / 255.0;
        double m2 = 0.0;
        if (scalei <= 0.5) {
            m2 = scalei * (1.0 + scales);
        } else if (scalei > 0.5) {
            m2 = scalei + scales - scalei * scales;
        }
        double m1 = 2.0 * scalei - m2;
        double hue = 360.0 * (double)h / 255.0;
        if (scales == 0.0) {
            if (hue == -1.0) {
                red = scalei;
                green = scalei;
                blue = scalei;
            }
        } else {
            double savehue = hue + 120.0;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            red = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
            savehue = hue;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            green = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
            savehue = hue - 120.0;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            blue = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
        }
        double red255 = red * 255.0;
        double green255 = green * 255.0;
        double blue255 = blue * 255.0;
        red = red255 > 255.0 ? 255.0 : red255;
        green = green255 > 255.0 ? 255.0 : green255;
        blue = blue255 > 255.0 ? 255.0 : blue255;
        if (red > 254.5) {
            red = 254.5;
        }
        if (red < 0.0) {
            red = 0.0;
        }
        if (green > 254.5) {
            green = 254.5;
        }
        if (green < 0.0) {
            green = 0.0;
        }
        if (blue > 254.5) {
            blue = 254.5;
        }
        if (blue < 0.0) {
            blue = 0.0;
        }
        res[0] = (int)(red + 0.5);
        res[1] = (int)(green + 0.5);
        res[2] = (int)(blue + 0.5);
        return res;
    }

    @Override
    public int[] HSLtoRGB(double h, double s, double l) {
        int[] res = new int[3];
        if (h == s && h == 0.0) {
            res[1] = res[2] = (int)(l * 255.0);
            res[0] = res[2];
            return res;
        }
        double blue = 0.0;
        double green = 0.0;
        double red = 0.0;
        double scalei = l;
        double scales = s;
        double m2 = 0.0;
        if (scalei <= 0.5) {
            m2 = scalei * (1.0 + scales);
        } else if (scalei > 0.5) {
            m2 = scalei + scales - scalei * scales;
        }
        double m1 = 2.0 * scalei - m2;
        double hue = h;
        if (scales == 0.0) {
            if (hue == -1.0) {
                red = scalei;
                green = scalei;
                blue = scalei;
            }
        } else {
            double savehue = hue + 120.0;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            red = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
            savehue = hue;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            green = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
            savehue = hue - 120.0;
            if (savehue > 360.0) {
                savehue -= 360.0;
            }
            if (savehue < 0.0) {
                savehue += 360.0;
            }
            blue = savehue < 60.0 ? m1 + (m2 - m1) * savehue / 60.0 : (savehue < 180.0 ? m2 : (savehue < 240.0 ? m1 + (m2 - m1) * (240.0 - savehue) / 60.0 : m1));
        }
        double red255 = red * 255.0;
        double green255 = green * 255.0;
        double blue255 = blue * 255.0;
        red = red255 > 255.0 ? 255.0 : red255;
        green = green255 > 255.0 ? 255.0 : green255;
        blue = blue255 > 255.0 ? 255.0 : blue255;
        if (red > 254.5) {
            red = 254.5;
        }
        if (red < 0.0) {
            red = 0.0;
        }
        if (green > 254.5) {
            green = 254.5;
        }
        if (green < 0.0) {
            green = 0.0;
        }
        if (blue > 254.5) {
            blue = 254.5;
        }
        if (blue < 0.0) {
            blue = 0.0;
        }
        res[0] = (int)(red + 0.5);
        res[1] = (int)(green + 0.5);
        res[2] = (int)(blue + 0.5);
        return res;
    }

    @Override
    public double[] RGBtoCMYK(int red, int green, int blue, double kScale) {
        double[] cmyk = new double[4];
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        cmyk[3] = 1.0 - Math.max(r, Math.max(g, b));
        cmyk[0] = 0.0;
        cmyk[1] = 0.0;
        cmyk[2] = 0.0;
        if (cmyk[3] != 1.0) {
            cmyk[0] = (1.0 - r - cmyk[3]) / (1.0 - cmyk[3]) * kScale;
            cmyk[1] = (1.0 - g - cmyk[3]) / (1.0 - cmyk[3]) * kScale;
            cmyk[2] = (1.0 - b - cmyk[3]) / (1.0 - cmyk[3]) * kScale;
        }
        cmyk[3] = cmyk[3] * kScale;
        return cmyk;
    }

    @Override
    public double[] CMYKtoRGB(double cyan, double magenta, double yellow, double key) {
        double[] rgb = new double[]{(1.0 - cyan) * (1.0 - key), (1.0 - magenta) * (1.0 - key), (1.0 - yellow) * (1.0 - key)};
        return rgb;
    }

    @Override
    public double getLuminosity(int red, int green, int blue) {
        double low;
        double scaler = (double)red / 255.0;
        double scaleg = (double)green / 255.0;
        double scaleb = (double)blue / 255.0;
        double high = scaler;
        if (scaleg > high) {
            high = scaleg;
        }
        if (scaleb > high) {
            high = scaleb;
        }
        if (scaleg < (low = scaler)) {
            low = scaleg;
        }
        if (scaleb < low) {
            low = scaleb;
        }
        return (high + low) / 2.0;
    }

    @Override
    public byte[] getARGBFromIntToByteArray(int rgb) {
        byte[] b = new byte[]{(byte)((rgb & 0xFF0000) >> 16), (byte)((rgb & 0xFF00) >> 8), (byte)(rgb & 0xFF), (byte)((rgb & 0xFF000000) >> 24)};
        return b;
    }

    @Override
    public int[] getARGBFromIntToIntArray(int rgb) {
        int[] i = new int[]{(rgb & 0xFF0000) >> 16 & 0xFF, (rgb & 0xFF00) >> 8 & 0xFF, rgb & 0xFF & 0xFF, (rgb & 0xFF000000) >> 24 & 0xFF};
        return i;
    }

    @Override
    public int getIntFromARGB(int a, int r, int g, int b) {
        return ((a & 0xFF) << 24) + ((r & 0xFF) << 16) + ((g & 0xFF) << 8) + (b & 0xFF);
    }
}

