/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl;

import java.awt.Color;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.raster.lib.legend.api.colortable.colortableclass.ColorTableClass;
import org.gvsig.raster.lib.legend.impl.colortable.colortableclass.DefaultColorTableClassNotification;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.observer.impl.BaseWeakReferencingObservable;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultColorTableClass
extends BaseWeakReferencingObservable
implements ColorTableClass {
    public static final String PERSISTENT_NAME = "ColorTableClassPersistent";
    public static final String PERSISTENT_DESCRIPTION = "Persistent definition of color table class";
    private static final String COLOR_PERSISTENCE_FIELD = "color";
    private static final String NAME_PERSISTENCE_FIELD = "name";
    private static final String VALUE_PERSISTENCE_FIELD = "value";
    private static final String INTERPOLATED_PERSISTENCE_FIELD = "interpolated";
    private Color color;
    private String name;
    private double value;
    private double interpolated;

    public DefaultColorTableClass() {
    }

    public DefaultColorTableClass(String name, double value, Color color, double interpolated) {
        if (color == null) {
            throw new IllegalArgumentException("Color can not be null");
        }
        this.name = name;
        this.value = value;
        this.color = color;
        this.interpolated = interpolated;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("Color can not be null");
        }
        this.color = color;
        this.notifyObservers((Object)new DefaultColorTableClassNotification("setted_color_in_class_notification", new Object[]{color}));
    }

    public double getInterpolated() {
        return this.interpolated;
    }

    public void setInterpolated(double interpolated) {
        this.interpolated = interpolated;
        this.notifyObservers((Object)new DefaultColorTableClassNotification("setted_interpolated_in_class_notification", new Object[]{interpolated}));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
        this.notifyObservers((Object)new DefaultColorTableClassNotification("setted_value_in_class_notification", new Object[]{value}));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.notifyObservers((Object)new DefaultColorTableClassNotification("setted_name_in_class_notification", new Object[]{name}));
    }

    public int compareTo(ColorTableClass otherClass) {
        Double value = this.getValue();
        Double otherValue = otherClass.getValue();
        if (value == null || otherValue == null) {
            throw new IllegalStateException("Value of ColorTableClass can not be null");
        }
        if (value.compareTo(otherValue) == 0) {
            if (StringUtils.isBlank((CharSequence)this.getName()) || StringUtils.isBlank((CharSequence)otherClass.getName())) {
                return value.compareTo(otherValue);
            }
            if (this.getName().compareTo(otherClass.getName()) == 0) {
                return 0;
            }
            return this.getName().compareTo(otherClass.getName());
        }
        return value.compareTo(otherValue);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(DefaultColorTableClass.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.addDynFieldString(NAME_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldDouble(VALUE_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldBoolean(INTERPOLATED_PERSISTENCE_FIELD).setMandatory(false);
            definition.addDynFieldObject(COLOR_PERSISTENCE_FIELD).setClassOfValue(Color.class).setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(NAME_PERSISTENCE_FIELD, this.getName());
        state.set(VALUE_PERSISTENCE_FIELD, this.getValue());
        state.set(INTERPOLATED_PERSISTENCE_FIELD, this.getInterpolated());
        state.set(COLOR_PERSISTENCE_FIELD, (Object)this.getColor());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setName(NAME_PERSISTENCE_FIELD);
        this.setValue(state.getDouble(VALUE_PERSISTENCE_FIELD));
        this.setColor((Color)state.get(COLOR_PERSISTENCE_FIELD));
        this.setInterpolated(state.getDouble(INTERPOLATED_PERSISTENCE_FIELD));
    }
}

