/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.legend.impl.operations.equalization;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.raster.lib.buffer.api.Band;
import org.gvsig.raster.lib.buffer.api.BufferLocator;
import org.gvsig.raster.lib.buffer.api.BufferManager;
import org.gvsig.raster.lib.buffer.api.NoData;
import org.gvsig.raster.lib.buffer.api.exceptions.BandException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferException;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.api.statistics.HistogramBand;
import org.gvsig.raster.lib.buffer.api.statistics.Statistics;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.legend.api.RasterLegendLocator;
import org.gvsig.raster.lib.legend.api.RasterLegendManager;
import org.gvsig.raster.lib.legend.spi.AbstractColoredOperation;
import org.gvsig.tools.locator.LocatorException;

public class EqualizationOperation
extends AbstractColoredOperation {
    public static String STATISTICS_PARAM = "statistics";
    private Statistics statistics;
    private List<Integer> bandsToProcess;
    private RowProcessor[] rowProcessors;
    private HistogramBand[] histogramBands;
    private Integer dataType;
    private long[][] lahe;
    private long[][] laheNegative;
    private int nElements;

    public EqualizationOperation(OperationFactory factory) {
        super(factory);
    }

    public void preProcess() throws BufferOperationException {
        super.preProcess();
        BufferManager manager = BufferLocator.getBufferManager();
        RasterLegendManager legendManager = RasterLegendLocator.getRasterLegendManager();
        this.statistics = (Statistics)this.getParameter(STATISTICS_PARAM, null);
        if (this.statistics == null) {
            this.statistics = this.getInputBuffer().getStatistics(null);
        }
        this.histogramBands = this.statistics.getHistogram();
        int bands = this.getInputBuffer().getBandCount();
        NoData[] noData = this.getInputBuffer().getBandNoData();
        if (this.mustCopyUnprocessedBands()) {
            this.setParameter("output_color_interpretation", this.getInputColorInterpretation());
            noData = this.getInputBuffer().getBandNoData();
            try {
                this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getInputBuffer().getBandTypes(), this.getInputBuffer().getBandNoData(), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
            }
            catch (CreateEnvelopeException | BufferException | LocatorException e) {
                throw new ProcessingOperationException(e);
            }
        }
        ArrayList<String> colorInterpretations = new ArrayList<String>();
        ArrayList<NoData> noDatas = new ArrayList<NoData>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (int band = 0; band < bands; ++band) {
            if (!this.isProcessableBand(band)) continue;
            colorInterpretations.add(this.getInputColorInterpretation().get(band));
            noDatas.add(this.getInputBuffer().getBandNoData()[band]);
            types.add(this.getInputBuffer().getBandTypes()[band]);
        }
        if (this.getInputColorInterpretation().hasAlphaBand()) {
            colorInterpretations.add("Alpha");
        }
        this.setOutputColorInterpretation(legendManager.createColorInterpretation(colorInterpretations));
        this.setParameter("output_color_interpretation", this.getOutputColorInterpretation());
        try {
            this.setOutputBuffer(manager.createBuffer(this.getInputBuffer().getRows(), this.getInputBuffer().getColumns(), this.getTypesAsArray(types), this.getNoDatasAsArray(noDatas), this.getInputBuffer().getProjection(), this.getInputBuffer().getEnvelope()));
        }
        catch (Exception e) {
            throw new ProcessingOperationException((Throwable)e);
        }
        this.rowProcessors = new RowProcessor[bands];
        this.dataType = null;
        if (this.getBandsToProcess().isEmpty()) {
            throw new ProcessingOperationException("There is no RGB band.", null);
        }
        block19: for (Integer band : this.getBandsToProcess()) {
            int bandType = this.getInputBuffer().getBand(band.intValue()).getDataType();
            if (this.dataType != null) {
                if (this.dataType != bandType) {
                    throw new IllegalArgumentException("All bands must be of same data type.");
                }
            } else {
                this.dataType = bandType;
            }
            switch (bandType) {
                case 0: {
                    this.rowProcessors[band.intValue()] = new ByteRowProcessor(band);
                    continue block19;
                }
                case 1: {
                    this.rowProcessors[band.intValue()] = new UShortRowProcessor(band);
                    continue block19;
                }
                case 2: {
                    this.rowProcessors[band.intValue()] = new ShortRowProcessor(band);
                    continue block19;
                }
                case 3: {
                    this.rowProcessors[band.intValue()] = new IntRowProcessor(band);
                    continue block19;
                }
                case 4: {
                    this.rowProcessors[band.intValue()] = null;
                    continue block19;
                }
                case 5: {
                    this.rowProcessors[band.intValue()] = null;
                    continue block19;
                }
            }
            throw new IllegalArgumentException("Can't process type of band '" + band + "'");
        }
        double[][] accumNormalize = EqualizationOperation.convertTableToNormalizeAccumulate(this.getHistogramTable());
        double[][] accumNormalizeNeg = EqualizationOperation.convertTableToNormalizeAccumulate(this.getNegativeHistogramTable());
        int maxValue = 255;
        switch (this.dataType) {
            case 0: {
                maxValue = 255;
                break;
            }
            case 2: {
                maxValue = Short.MAX_VALUE;
                break;
            }
            case 1: {
                maxValue = Math.abs(Short.MIN_VALUE) + Short.MAX_VALUE;
                break;
            }
            case 3: {
                maxValue = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't process type '" + this.dataType + "'");
            }
        }
        this.lahe = this.lahe(accumNormalize, maxValue);
        this.laheNegative = this.lahe(accumNormalizeNeg, maxValue);
        this.nElements = this.laheNegative[0].length - 1;
    }

    private long[][] getHistogramTable() {
        int size;
        switch (this.dataType) {
            case 0: {
                int rangeMin = 0;
                int rangeMax = 255;
                size = 256;
                break;
            }
            case 2: {
                int rangeMin = Short.MIN_VALUE;
                int rangeMax = Short.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            case 1: {
                int rangeMin = 0;
                int rangeMax = Math.abs(Short.MIN_VALUE) + Short.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            case 3: {
                int rangeMin = Integer.MIN_VALUE;
                int rangeMax = Integer.MAX_VALUE;
                size = rangeMax - rangeMin + 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't process type '" + this.dataType + "'");
            }
        }
        long[][] table = new long[this.getBandsToProcess().size()][size];
        for (int i = 0; i < table.length; ++i) {
            System.arraycopy(this.histogramBands[this.getBandsToProcess().get(i)].getFrequencies(), 0, table[i], 0, size);
        }
        return table;
    }

    private long[][] getNegativeHistogramTable() {
        long[][] table = this.getHistogramTable();
        long[][] tableNeg = new long[table.length][table[0].length];
        for (int i = 0; i < tableNeg.length; ++i) {
            for (int j = 0; j < tableNeg[i].length; ++j) {
                tableNeg[i][table[i].length - j - 1] = table[i][j];
            }
        }
        return tableNeg;
    }

    private static double[][] convertToNormalizeHistogram(long[][] tableToConvert) {
        long[] nValues = new long[tableToConvert.length];
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                int n = i;
                nValues[n] = nValues[n] + tableToConvert[i][j];
            }
        }
        double[][] res = new double[tableToConvert.length][tableToConvert[0].length];
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                res[i][j] = (double)tableToConvert[i][j] / (double)nValues[i];
            }
        }
        return res;
    }

    private static double[][] convertTableToNormalizeAccumulate(long[][] tableToConvert) {
        double[][] res = EqualizationOperation.convertToNormalizeHistogram(tableToConvert);
        for (int i = 0; i < tableToConvert.length; ++i) {
            for (int j = 0; j < tableToConvert[i].length; ++j) {
                if (j <= 0) continue;
                double[] dArray = res[i];
                int n = j;
                dArray[n] = dArray[n] + res[i][j - 1];
            }
        }
        return res;
    }

    public void process() throws ProcessingOperationException {
        super.process();
        for (int band = 0; band < this.getInputBuffer().getBandCount(); ++band) {
            if (this.getBandsToProcess().contains(band)) {
                Band bufferBand = this.getInputBuffer().getBand(band);
                Band outputBufferBand = this.getOutputBuffer().getBand(band);
                for (int row = 0; row < this.getInputBuffer().getRows(); ++row) {
                    Object rowBuffer = bufferBand.createRowBuffer();
                    bufferBand.fetchRow(row, rowBuffer);
                    Object outputRowBuffer = outputBufferBand.createRowBuffer();
                    outputBufferBand.fetchRow(row, outputRowBuffer);
                    this.rowProcessors[band].processRow(rowBuffer, outputRowBuffer);
                    outputBufferBand.putRow(row, outputRowBuffer);
                }
                continue;
            }
            try {
                this.getOutputBuffer().getBand(band).copyFrom(this.getInputBuffer().getBand(band));
                continue;
            }
            catch (BandException e) {
                throw new ProcessingOperationException((Throwable)e);
            }
        }
    }

    public void postProcess() throws BufferOperationException {
        super.postProcess();
    }

    private long[][] lahe(double[][] accumNorm, int value) {
        long[][] res = new long[accumNorm.length][accumNorm[0].length];
        for (int i = 0; i < res.length; ++i) {
            for (int j = 0; j < res[i].length; ++j) {
                res[i][j] = Math.round(accumNorm[i][j] * (double)value);
            }
        }
        return res;
    }

    private List<Integer> getBandsToProcess() {
        if (this.bandsToProcess == null) {
            int bands = this.getInputBuffer().getBandCount();
            this.bandsToProcess = new ArrayList<Integer>();
            for (int band = 0; band < bands; ++band) {
                if (!this.isProcessableBand(band)) continue;
                this.bandsToProcess.add(band);
            }
        }
        return this.bandsToProcess;
    }

    protected boolean isProcessableBand(int band) {
        return this.isRGBBand(band) && (this.getInputBuffer().getBandTypes()[band] == 0 || this.getInputBuffer().getBandTypes()[band] == 2 || this.getInputBuffer().getBandTypes()[band] == 1 || this.getInputBuffer().getBandTypes()[band] == 3);
    }

    private boolean isRGBBand(int band) {
        String bandColorInterpretation = this.getInputColorInterpretation().get(band);
        return bandColorInterpretation.equals("Red") || bandColorInterpretation.equals("Green") || bandColorInterpretation.equals("Blue");
    }

    private class IntRowProcessor
    extends AbstractRowProcessor {
        public IntRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            int[] inputByteRow = (int[])inputRow;
            int[] outputByteRow = (int[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).intValue();
            }
        }

        @Override
        public Number processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)0;
            }
            Double dValue = ((Number)value).doubleValue();
            int intValue = (Integer)value;
            int equalizationPositive = (int)EqualizationOperation.this.lahe[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][intValue % (int)this.histogram.getNumValues()];
            int equalizationNegative = (int)EqualizationOperation.this.laheNegative[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][EqualizationOperation.this.nElements - intValue % (int)this.histogram.getNumValues()];
            int resValue = (EqualizationOperation.this.nElements - equalizationNegative + equalizationPositive) / 2;
            return resValue;
        }
    }

    private class UShortRowProcessor
    extends AbstractRowProcessor {
        public UShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputByteRow = (short[])inputRow;
            short[] outputByteRow = (short[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).shortValue();
            }
        }

        @Override
        public Number processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)0;
            }
            int intValue = 0xFFFF & ((Short)value).byteValue();
            int equalizationPositive = (int)EqualizationOperation.this.lahe[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][intValue % (int)this.histogram.getNumValues()];
            int equalizationNegative = (int)EqualizationOperation.this.laheNegative[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][EqualizationOperation.this.nElements - intValue % (int)this.histogram.getNumValues()];
            int resValue = (EqualizationOperation.this.nElements - equalizationNegative + equalizationPositive) / 2;
            return (short)resValue;
        }
    }

    private class ShortRowProcessor
    extends AbstractRowProcessor {
        public ShortRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            short[] inputByteRow = (short[])inputRow;
            short[] outputByteRow = (short[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).shortValue();
            }
        }

        @Override
        public Number processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)0;
            }
            byte intValue = ((Short)value).byteValue();
            int equalizationPositive = (int)EqualizationOperation.this.lahe[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][intValue % (int)this.histogram.getNumValues()];
            int equalizationNegative = (int)EqualizationOperation.this.laheNegative[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][EqualizationOperation.this.nElements - intValue % (int)this.histogram.getNumValues()];
            int resValue = (EqualizationOperation.this.nElements - equalizationNegative + equalizationPositive) / 2;
            return (short)resValue;
        }
    }

    private class ByteRowProcessor
    extends AbstractRowProcessor {
        public ByteRowProcessor(int band) {
            super(band);
        }

        @Override
        public void processRow(Object inputRow, Object outputRow) {
            byte[] inputByteRow = (byte[])inputRow;
            byte[] outputByteRow = (byte[])outputRow;
            for (int i = 0; i < inputByteRow.length; ++i) {
                outputByteRow[i] = this.processValue(inputByteRow[i]).byteValue();
            }
        }

        @Override
        public Number processValue(Object value) {
            if (this.noData.isDefined() && this.noData.getValue().equals(value)) {
                return (byte)((Byte)value);
            }
            int intValue = 0xFF & (Byte)value;
            int equalizationPositive = (int)EqualizationOperation.this.lahe[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][intValue % (int)this.histogram.getNumValues()];
            int equalizationNegative = (int)EqualizationOperation.this.laheNegative[EqualizationOperation.this.getBandsToProcess().indexOf(this.band)][EqualizationOperation.this.nElements - intValue % (int)this.histogram.getNumValues()];
            int resValue = (EqualizationOperation.this.nElements - equalizationNegative + equalizationPositive) / 2;
            return (byte)(resValue & 0xFF);
        }
    }

    private abstract class AbstractRowProcessor
    implements RowProcessor {
        protected int band;
        protected HistogramBand histogram;
        protected NoData noData;

        public AbstractRowProcessor(int band) {
            this.band = band;
            this.histogram = EqualizationOperation.this.statistics.getHistogram()[this.band];
            this.noData = EqualizationOperation.this.getInputBuffer().getBand(this.band).getNoData();
        }
    }

    static interface RowProcessor {
        public void processRow(Object var1, Object var2);

        public Number processValue(Object var1);
    }
}

