/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.cresques.cts.GeoCalc;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.tools.geo.Geo;

public class AreaAndPerimeterCalculator {
    public double perimeter(Geometry geom, IProjection proj, int distanceUnits) {
        ArrayList parts = this.getXY(geom);
        double perimeter = 0.0;
        for (int j = 0; j < parts.size(); ++j) {
            Double[][] xsys = (Double[][])parts.get(j);
            double distAll = 0.0;
            for (int i = 0; i < xsys[0].length - 1; ++i) {
                Point2D.Double p = new Point2D.Double(xsys[0][i], xsys[1][i]);
                Point2D.Double p2 = new Point2D.Double(xsys[0][i + 1], xsys[1][i + 1]);
                double dist = this.distanceWorld(p, p2, proj, distanceUnits);
                distAll += dist;
            }
            perimeter += distAll / MapContext.getDistanceTrans2Meter()[distanceUnits];
        }
        return perimeter;
    }

    public double area(Geometry geom, IProjection proj, int areaUnits) {
        ArrayList parts = this.getXY(geom);
        double area = 0.0;
        for (int i = 0; i < parts.size(); ++i) {
            Double[] ys;
            Double[][] xsys = (Double[][])parts.get(i);
            Double[] xs = xsys[0];
            if (this.isCCW(xs, ys = xsys[1])) {
                if (proj.isProjected()) {
                    area -= this.returnCoordsArea(xs, ys, new Point2D.Double(xs[xs.length - 1], ys[ys.length - 1]), areaUnits);
                    continue;
                }
                area -= this.returnGeoCArea(xs, ys);
                continue;
            }
            if (proj.isProjected()) {
                area += this.returnCoordsArea(xs, ys, new Point2D.Double(xs[xs.length - 1], ys[ys.length - 1]), areaUnits);
                continue;
            }
            area += this.returnGeoCArea(xs, ys);
        }
        return area;
    }

    public double distanceWorld(Point2D pt1, Point2D pt2, IProjection proj, int distanceUnits) {
        double dist;
        if (proj.isProjected()) {
            dist = pt1.distance(pt2);
            dist *= MapContext.getDistanceTrans2Meter()[distanceUnits];
        } else {
            GeoCalc geocalc = new GeoCalc(proj);
            dist = geocalc.distanceVincenty(pt1, pt2);
        }
        return dist;
    }

    private boolean isCCW(Double[] xs, Double[] ys) {
        Line line = GeometryUtils.createLine((int)0);
        for (int i = 0; i < ys.length; ++i) {
            line.addVertex(xs[i].doubleValue(), ys[i].doubleValue());
        }
        if (line.isEmpty()) {
            return true;
        }
        try {
            return line.isCCW();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't calculate isCCW", ex);
        }
    }

    private double returnGeoCArea(Double[] xs, Double[] ys) {
        double[] lat = new double[xs.length];
        double[] lon = new double[xs.length];
        for (int K = 0; K < xs.length; ++K) {
            lon[K] = xs[K] / Geo.Degree;
            lat[K] = ys[K] / Geo.Degree;
        }
        return Geo.sphericalPolyArea(lat, lon, xs.length - 1) * Geo.SqM;
    }

    public double returnCoordsArea(Double[] xs, Double[] ys, Point2D point, int areaUnits) {
        Point2D aux = point;
        double elArea = 0.0;
        Point2D.Double pAnt = new Point2D.Double();
        for (int pos = 0; pos < xs.length - 1; ++pos) {
            Point2D.Double pPixel;
            Point2D.Double p = pPixel = new Point2D.Double(xs[pos], ys[pos]);
            if (pos == 0) {
                pAnt.x = aux.getX();
                pAnt.y = aux.getY();
            }
            elArea += (pAnt.x - ((Point2D)p).getX()) * (pAnt.y + ((Point2D)p).getY());
            pAnt.setLocation(p);
        }
        elArea += (pAnt.x - aux.getX()) * (pAnt.y + aux.getY());
        elArea = Math.abs(elArea / 2.0);
        return elArea / Math.pow(MapContext.getAreaTrans2Meter()[areaUnits], 2.0);
    }

    public ArrayList getXY(Geometry geometry) {
        Double[] y;
        Double[] x;
        ArrayList<Double> xs = new ArrayList<Double>();
        ArrayList<Double> ys = new ArrayList<Double>();
        ArrayList<Double[][]> parts = new ArrayList<Double[][]>();
        double[] theData = new double[6];
        int numParts = 0;
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        PathIterator theIterator = geometry.getPathIterator(null, geomManager.getFlatness());
        boolean isClosed = false;
        while (!theIterator.isDone()) {
            int theType = theIterator.currentSegment(theData);
            switch (theType) {
                case 0: {
                    if (numParts == 0) {
                        xs.add(theData[0]);
                        ys.add(theData[1]);
                    } else {
                        if (!isClosed) {
                            x = xs.toArray(new Double[0]);
                            y = ys.toArray(new Double[0]);
                            parts.add(new Double[][]{x, y});
                            xs.clear();
                            ys.clear();
                        }
                        xs.add(theData[0]);
                        ys.add(theData[1]);
                    }
                    ++numParts;
                    isClosed = false;
                    break;
                }
                case 1: {
                    isClosed = false;
                    xs.add(theData[0]);
                    ys.add(theData[1]);
                    break;
                }
                case 4: {
                    isClosed = true;
                    xs.add(theData[0]);
                    ys.add(theData[1]);
                    x = xs.toArray(new Double[0]);
                    y = ys.toArray(new Double[0]);
                    parts.add(new Double[][]{x, y});
                    xs.clear();
                    ys.clear();
                }
            }
            theIterator.next();
        }
        if (!isClosed) {
            xs.add(theData[0]);
            ys.add(theData[1]);
            x = xs.toArray(new Double[0]);
            y = ys.toArray(new Double[0]);
            parts.add(new Double[][]{x, y});
            xs.clear();
            ys.clear();
        }
        return parts;
    }
}

