/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.BooleanUtils;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayersTreeModel
implements TreeModel {
    public static final Logger LOGGER = LoggerFactory.getLogger(LayersTreeModel.class);
    private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    protected FLayers layers;
    private Predicate<FLayer> filter;

    public LayersTreeModel(FLayers layers) {
        this.layers = layers;
    }

    @Deprecated
    public void setFilter(Evaluator filter) {
        this.filter = new EvaluatorToPredicateAdapter(filter);
    }

    public void setFilter(Predicate<FLayer> filter) {
        this.filter = filter;
    }

    @Override
    public Object getRoot() {
        return this.layers;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == null) {
            return null;
        }
        if (parent instanceof LabeledValue) {
            parent = ((LabeledValue)parent).getValue();
        }
        if (!(parent instanceof FLayers)) {
            return null;
        }
        if (this.filter == null) {
            FLayer layer = ((FLayers)parent).getLayer(index);
            return layer;
        }
        int count = 0;
        for (int i = 0; i < ((FLayers)parent).getLayersCount(); ++i) {
            FLayer layer = ((FLayers)parent).getLayer(i);
            try {
                if (index == count) {
                    return layer;
                }
                if (!(layer instanceof FLayers)) {
                    if (!this.filter.test(layer)) continue;
                    ++count;
                    continue;
                }
                ++count;
                continue;
            }
            catch (Exception ex) {
                LOGGER.debug("Can't process layer", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == null) {
            return 0;
        }
        if (parent instanceof LabeledValue) {
            parent = ((LabeledValue)parent).getValue();
        }
        if (!(parent instanceof FLayers)) {
            return 0;
        }
        if (this.filter == null) {
            return ((FLayers)parent).getLayersCount();
        }
        int count = 0;
        for (int i = 0; i < ((FLayers)parent).getLayersCount(); ++i) {
            FLayer layer = ((FLayers)parent).getLayer(i);
            try {
                if (!(layer instanceof FLayers)) {
                    if (!this.filter.test(layer)) continue;
                    ++count;
                    continue;
                }
                ++count;
                continue;
            }
            catch (Exception ex) {
                LOGGER.debug("Can't process layer", (Throwable)ex);
            }
        }
        return count;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node instanceof LabeledValue) {
            node = ((LabeledValue)node).getValue();
        }
        return !(node instanceof FLayers);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        if (parent instanceof LabeledValue) {
            parent = ((LabeledValue)parent).getValue();
        }
        if (this.filter == null) {
            for (int i = 0; i < ((FLayers)parent).getLayersCount(); ++i) {
                FLayer layer = ((FLayers)parent).getLayer(i);
                if (child != layer) continue;
                return i;
            }
            return -1;
        }
        int count = 0;
        for (int i = 0; i < ((FLayers)parent).getLayersCount(); ++i) {
            FLayer layer = ((FLayers)parent).getLayer(i);
            try {
                if (layer instanceof FLayers || !this.filter.test(layer)) continue;
                if (child == layer) {
                    return count;
                }
                ++count;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object value) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listeners.remove(listener);
    }

    public void reload() {
        TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.layers));
        for (TreeModelListener listener : this.listeners) {
            listener.treeStructureChanged(event);
        }
    }

    private static class EvaluatorToPredicateAdapter
    implements Predicate<FLayer> {
        private final MyEvaluatorData evaluatorFilterData;
        private final Evaluator filter;

        public EvaluatorToPredicateAdapter(Evaluator filter) {
            this.filter = filter;
            this.evaluatorFilterData = new MyEvaluatorData();
        }

        @Override
        public boolean test(FLayer layer) {
            try {
                this.evaluatorFilterData.layer = layer;
                return BooleanUtils.isTrue((Boolean)((Boolean)this.filter.evaluate((EvaluatorData)this.evaluatorFilterData)));
            }
            catch (EvaluatorException ex) {
                throw new RuntimeException("Can't filter tree model,", ex);
            }
        }

        private static class MyEvaluatorData
        implements EvaluatorData {
            public FLayer layer = null;

            private MyEvaluatorData() {
            }

            public Object getDataValue(String name) {
                if (name.equalsIgnoreCase("layer")) {
                    return this.layer;
                }
                return null;
            }

            public Object getContextValue(String name) {
                if (name.equalsIgnoreCase("layer")) {
                    return this.layer;
                }
                return null;
            }

            public Iterator getDataValues() {
                return Arrays.asList(this.layer).iterator();
            }

            public Iterator getDataNames() {
                return Arrays.asList("layer").iterator();
            }

            public boolean hasDataValue(String name) {
                return name.equalsIgnoreCase("layer");
            }

            public boolean hasContextValue(String name) {
                return name.equalsIgnoreCase("layer");
            }
        }
    }
}

