/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DataStoreNotification;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.AtomicEvent;
import org.gvsig.fmap.mapcontext.events.listeners.AtomicEventListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.LayerCollectionEvent;
import org.gvsig.fmap.mapcontext.layers.LayerEvent;
import org.gvsig.fmap.mapcontext.layers.SpatialCache;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.fmap.mapcontrol.tools.grid.Grid;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapper;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperGeometriesVectorial;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperRaster;
import org.gvsig.fmap.mapcontrol.tools.snapping.snappers.ISnapperVectorial;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.utils.exceptionHandling.ExceptionHandlingSupport;
import org.gvsig.utils.exceptionHandling.ExceptionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapControl
extends JComponent
implements ComponentListener,
Observer,
Disposable {
    protected static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger LOG = LoggerFactory.getLogger(GeometryManager.class);
    public static final int ACTUALIZADO = 0;
    public static final int DESACTUALIZADO = 1;
    private static boolean drawAnimationEnabled = true;
    public static final int PAINT_PARTIAL_DRAWING_LAYERS = 0;
    public static final int PAINT_WHEN_DRAW_LAYERS_IS_COMPLETED = 1;
    private int paintMode = 0;
    private MapContext mapContext = null;
    protected Map<String, Behavior> namesMapTools = new HashMap<String, Behavior>();
    protected Behavior currentMapTool = null;
    private int status = 1;
    private BufferedImage image = null;
    protected String currentTool;
    private CancelDraw canceldraw;
    private Timer timer;
    protected ViewPort vp;
    private Drawer drawer;
    protected MapToolListener mapToolListener = new MapToolListener();
    private MapContextListener mapContextListener = new MapContextListener();
    private ExceptionHandlingSupport exceptionHandlingSupport = new ExceptionHandlingSupport();
    protected String prevTool;
    private Behavior combinedTool = null;
    private Grid cadgrid = new Grid();
    protected Point2D adjustedPoint;
    private boolean bForceCoord = false;
    private ISnapper usedSnap = null;
    private boolean bRefent = true;
    private double[] previousPoint = null;
    private boolean defaultMouseWheelEnabled = true;
    protected static MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
    private static TreeMap selected = new TreeMap(new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1.getClass().equals(o2.getClass())) {
                return 0;
            }
            if (((ISnapper)o1).getPriority() > ((ISnapper)o2).getPriority()) {
                return 1;
            }
            return -1;
        }
    });
    protected Point2D mapAdjustedPoint;
    private MapControlDrawer mapControlDrawer = null;
    private Cursor transparentCursor;
    private boolean disposed = false;
    private ActionListenerSupport addLayerHelper;
    private Image lastImageCursor = null;
    private Cursor lastCursor = null;
    private ChangeListenerHelper changeToolListenerHelper = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();

    public MapControl() {
        this(null);
    }

    public MapControl(MapContext theMapContext) {
        if (theMapContext == null) {
            theMapContext = new MapContext(new ViewPort(MapContextLocator.getMapContextManager().getDefaultCRS()));
        }
        this.setName("MapControl");
        this.addLayerHelper = ToolsSwingLocator.getToolsSwingManager().createActionListenerSupport();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image imageTransparentCursor = toolkit.createImage(new MemoryImageSource(16, 16, new int[256], 0, 16));
        this.transparentCursor = toolkit.createCustomCursor(imageTransparentCursor, new Point(0, 0), "invisiblecursor");
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.status = 1;
        this.canceldraw = new CancelDraw();
        this.vp = theMapContext.getViewPort();
        this.setMapContext(theMapContext);
        this.addComponentListener(this);
        this.addMouseListener(this.mapToolListener);
        this.addMouseMotionListener(this.mapToolListener);
        this.addMouseWheelListener(this.mapToolListener);
        this.drawer = new Drawer();
        this.timer = new Timer(1000 / MapContext.getDrawFrameRate(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MapControl.this.paintMode != 1 && drawAnimationEnabled) {
                    MapControl.this.repaint();
                }
            }
        });
        this.initializeGrid();
        if (ToolsLocator.getDisposableManager() != null) {
            ToolsLocator.getDisposableManager().bind((Disposable)this);
        } else {
            LOG.warn("Can't retrieve the disposable manager,");
        }
    }

    public void addLayer(FLayer layer) {
        AddLayerEvent event = new AddLayerEvent(layer, this, 1, "addLayer");
        this.addLayerHelper.fireActionEvent((ActionEvent)event);
        this.mapContext.getLayers().add(event.getLayer());
        if (!this.mapContext.hasActiveLayers()) {
            event.getLayer().setActive(true);
        }
    }

    public void addLayerListener(ActionListener al) {
        this.addLayerHelper.addActionListener(al);
    }

    public void setPaintMode(int paintMode) {
        this.paintMode = paintMode;
    }

    public int getPaintMode() {
        return this.paintMode;
    }

    public void setMapContext(MapContext model) {
        if (this.mapContext != null) {
            this.mapContext.removeAtomicEventListener((AtomicEventListener)this.mapContextListener);
            this.mapContext.dispose();
        }
        this.mapContext = model;
        if (this.mapContext.getViewPort() == null) {
            this.mapContext.setViewPort(this.vp);
        } else {
            this.vp = this.mapContext.getViewPort();
            this.cadgrid.setViewPort(this.vp);
        }
        this.mapContext.addAtomicEventListener((AtomicEventListener)this.mapContextListener);
        this.status = 1;
    }

    public MapControlDrawer getMapControlDrawer() {
        return this.mapControlDrawer;
    }

    public void setMapControlDrawer(MapControlDrawer mapControlDrawer) {
        this.mapControlDrawer = mapControlDrawer;
        this.mapControlDrawer.setViewPort(this.vp);
    }

    public IProjection getProjection() {
        return this.getMapContext().getProjection();
    }

    public void setProjection(IProjection proj) {
        this.getMapContext().setProjection(proj);
    }

    public MapContext getMapContext() {
        return this.mapContext;
    }

    public void addBehavior(String name, Behavior tool) {
        this.namesMapTools.put(name, tool);
        tool.setMapControl(this);
    }

    public void addBehavior(String name, Behavior[] tools) {
        CompoundBehavior tool = new CompoundBehavior(tools);
        tool.setMapControl(this);
        this.addBehavior(name, tool);
    }

    public Behavior getMapTool(String name) {
        return this.namesMapTools.get(name);
    }

    public Set getMapToolsKeySet() {
        return this.namesMapTools.keySet();
    }

    public boolean hasTool(String toolName) {
        return this.namesMapTools.containsKey(toolName);
    }

    public void setTool(String toolName) {
        Behavior mapTool;
        this.prevTool = this.getCurrentTool();
        this.currentMapTool = mapTool = this.namesMapTools.get(toolName);
        this.currentTool = toolName;
        if (this.combinedTool != null) {
            if (mapTool instanceof CompoundBehavior) {
                ((CompoundBehavior)mapTool).addMapBehavior(this.combinedTool, true);
            } else {
                this.currentMapTool = new CompoundBehavior(new Behavior[]{this.currentMapTool});
                ((CompoundBehavior)this.currentMapTool).addMapBehavior(this.combinedTool, true);
                this.currentMapTool.setMapControl(this);
            }
        }
        this.changeToolListenerHelper.fireEvent(new ChangeEvent(this));
    }

    public Behavior getTool(String name) {
        return this.namesMapTools.get(name);
    }

    public Behavior getCurrentMapTool() {
        return this.currentMapTool;
    }

    public String getCurrentTool() {
        return this.currentTool;
    }

    public void cancelDrawing() {
        this.canceldraw.setCanceled(true);
    }

    private boolean adaptToImageSize() {
        try {
            if (this.image != null && this.vp.getImageWidth() == this.getWidth() && this.vp.getImageHeight() == this.getHeight()) {
                return false;
            }
            this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.vp.setImageSize(new Dimension(this.getWidth(), this.getHeight()));
            this.getMapContext().getViewPort().refreshExtent();
            this.clearImage(this.image);
            this.status = 1;
            return true;
        }
        catch (Exception ex) {
            LOG.trace("Can't adapt to image size", (Throwable)ex);
            return false;
        }
    }

    private void clearImage(BufferedImage image) {
        if (image == null) {
            return;
        }
        Graphics2D gTemp = image.createGraphics();
        Color theBackColor = this.vp.getBackColor();
        if (theBackColor == null) {
            gTemp.setColor(Color.WHITE);
        } else {
            gTemp.setColor(theBackColor);
        }
        gTemp.fillRect(0, 0, this.getWidth(), this.getHeight());
        gTemp.dispose();
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.adaptToImageSize();
        try {
            this.mapControlDrawer.startDrawing(this);
        }
        catch (InterruptedException e) {
            LOG.info("Error locking the MapControlDrawer", (Throwable)e);
        }
        this.mapControlDrawer.setGraphics(g);
        this.mapControlDrawer.stopDrawing(this);
        this.mapControlDrawer.setViewPort(this.getMapContext().getViewPort());
        if (this.status == 0) {
            if (this.image != null) {
                if (this.currentMapTool != null) {
                    this.currentMapTool.paintComponent(this.mapControlDrawer, true);
                } else {
                    this.mapControlDrawer.drawImage(this.image, 0, 0);
                }
            }
        } else if (this.status == 1) {
            this.mapControlDrawer.drawImage(this.image, 0, 0);
            this.drawer.put(new PaintingRequest());
            this.timer.start();
        }
        this.cadgrid.drawGrid(this.mapControlDrawer);
        this.drawCursor();
    }

    private String getStatusLabel(int status) {
        switch (status) {
            case 0: {
                return "ACTUALIZADO";
            }
            case 1: {
                return "DESACTUALIZADO";
            }
        }
        return Integer.toString(status);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void drawMap(boolean doClear) {
        this.cancelDrawing();
        this.status = 1;
        if (doClear) {
            this.clearImage(this.image);
        }
        this.repaint();
        this.revalidate();
    }

    public void rePaintDirtyLayers() {
        this.cancelDrawing();
        this.status = 1;
        this.repaint();
    }

    public void drawGraphics() {
        this.drawMap(false);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    public void addExceptionListener(ExceptionListener o) {
        this.exceptionHandlingSupport.addExceptionListener(o);
    }

    public boolean removeExceptionListener(ExceptionListener o) {
        return this.exceptionHandlingSupport.removeExceptionListener(o);
    }

    protected void throwException(Throwable t) {
        this.exceptionHandlingSupport.throwException(t);
    }

    public ViewPort getViewPort() {
        return this.vp;
    }

    public HashMap getNamesMapTools() {
        return (HashMap)this.namesMapTools;
    }

    public void commandRepaint() {
        this.drawMap(false);
    }

    public void commandRefresh() {
    }

    public void setPrevTool() {
        this.setTool(this.prevTool);
    }

    public void zoomIn() {
        Behavior mapTool = this.namesMapTools.get("zoomIn");
        ViewPort vp = this.getViewPort();
        Envelope r = this.getViewPort().getAdjustedExtent();
        Point2D pCenter = vp.fromMapPoint(r.getCenter(0), r.getCenter(1));
        MouseEvent e = new MouseEvent(this, 502, 128L, 16, (int)pCenter.getX(), (int)pCenter.getY(), 1, true, 1);
        try {
            mapTool.mousePressed(e);
            mapTool.mouseReleased(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
    }

    public void zoomOut() {
        Behavior mapTool = this.namesMapTools.get("zoomOut");
        ViewPort vp = this.getViewPort();
        Envelope r = this.getViewPort().getAdjustedExtent();
        Point2D pCenter = vp.fromMapPoint(r.getCenter(0), r.getCenter(1));
        MouseEvent e = new MouseEvent(this, 502, 128L, 16, (int)pCenter.getX(), (int)pCenter.getY(), 1, true, 1);
        try {
            mapTool.mousePressed(e);
            mapTool.mouseReleased(e);
        }
        catch (BehaviorException t) {
            this.throwException(t);
        }
    }

    public MapToolListener getMapToolListener() {
        return this.mapToolListener;
    }

    public void setCurrentMapTool(Behavior mapTool) {
        this.currentMapTool = mapTool;
    }

    public void applyFrameRate() {
        if (MapContext.getDrawFrameRate() > 0) {
            this.timer.setDelay(1000 / MapContext.getDrawFrameRate());
        }
    }

    public static boolean isDrawAnimationEnabled() {
        return drawAnimationEnabled;
    }

    public static void setDrawAnimationEnabled(boolean drawAnimationEnabled) {
        MapControl.drawAnimationEnabled = drawAnimationEnabled;
    }

    public CancelDraw getCanceldraw() {
        return this.canceldraw;
    }

    public Behavior getCombinedTool() {
        return this.combinedTool;
    }

    public void setCombinedTool(Behavior combinedTool) {
        this.combinedTool = combinedTool;
        if (this.currentMapTool == null) {
            return;
        }
        if (this.currentMapTool instanceof CompoundBehavior) {
            ((CompoundBehavior)this.currentMapTool).addMapBehavior(combinedTool, true);
        } else {
            this.currentMapTool = new CompoundBehavior(new Behavior[]{this.currentMapTool});
            ((CompoundBehavior)this.currentMapTool).addMapBehavior(combinedTool, true);
        }
    }

    public void addCombinedBehavior(Behavior tool) {
        tool.setMapControl(this);
        if (this.combinedTool == null) {
            this.combinedTool = tool;
        } else if (this.combinedTool instanceof CompoundBehavior) {
            if (((CompoundBehavior)this.combinedTool).containsBehavior(tool)) {
                return;
            }
            ((CompoundBehavior)this.combinedTool).addMapBehavior(tool, true);
        } else {
            if (this.combinedTool.equals(tool)) {
                return;
            }
            this.combinedTool = new CompoundBehavior(new Behavior[]{this.combinedTool});
            ((CompoundBehavior)this.combinedTool).addMapBehavior(tool, true);
            this.combinedTool.setMapControl(this);
        }
        if (this.currentMapTool == null) {
            return;
        }
        if (this.currentMapTool instanceof CompoundBehavior) {
            ((CompoundBehavior)this.currentMapTool).addMapBehavior(tool, true);
        } else {
            this.currentMapTool = new CompoundBehavior(new Behavior[]{this.currentMapTool});
            ((CompoundBehavior)this.currentMapTool).addMapBehavior(tool, true);
        }
    }

    public void removeCombinedTool(Behavior tool) {
        if (this.currentMapTool != null && this.currentMapTool instanceof CompoundBehavior) {
            ((CompoundBehavior)this.currentMapTool).removeMapBehavior(tool);
        }
        if (this.combinedTool == null) {
            return;
        }
        if (this.combinedTool instanceof CompoundBehavior) {
            ((CompoundBehavior)this.combinedTool).removeMapBehavior(tool);
        } else {
            this.combinedTool = null;
        }
    }

    public void initializeGrid() {
        Preferences prefs = mapControlManager.getEditionPreferences();
        boolean showGrid = prefs.getBoolean("grid.showgrid", this.cadgrid.isShowGrid());
        boolean adjustGrid = prefs.getBoolean("grid.adjustgrid", this.cadgrid.isAdjustGrid());
        double dx = prefs.getDouble("grid.distancex", this.cadgrid.getGridSizeX());
        double dy = prefs.getDouble("grid.distancey", this.cadgrid.getGridSizeY());
        this.setGridVisibility(showGrid);
        this.setAdjustGrid(adjustGrid);
        this.cadgrid.setGridSizeX(dx);
        this.cadgrid.setGridSizeY(dy);
    }

    public void setAdjustGrid(boolean adjustGrid) {
        this.cadgrid.setAdjustGrid(adjustGrid);
    }

    public void setGridVisibility(boolean showGrid) {
        this.cadgrid.setShowGrid(showGrid);
        this.cadgrid.setViewPort(this.getViewPort());
        this.repaint();
    }

    private void setToolMouse() {
        Image imageCursor = this.getCurrentMapTool().getImageCursor();
        if (imageCursor != null && imageCursor == this.lastImageCursor && this.lastCursor != null && this.lastCursor != this.transparentCursor) {
            this.setCursor(this.lastCursor);
            return;
        }
        this.lastImageCursor = imageCursor;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor c = toolkit.createCustomCursor(imageCursor, new Point(16, 16), "img");
        this.setCursor(c);
        this.lastCursor = c;
    }

    private void setTransparentMouse() {
        this.setCursor(this.transparentCursor);
        this.lastCursor = this.transparentCursor;
    }

    private void drawCursor() {
        if (this.adjustedPoint == null) {
            return;
        }
        if (this.usedSnap != null) {
            this.usedSnap.draw(this.mapControlDrawer, this.adjustedPoint);
            this.setTransparentMouse();
        } else {
            this.setToolMouse();
        }
    }

    private double adjustToHandler(Point2D point, Point2D mapHandlerAdjustedPoint) {
        double mapTolerance;
        if (!this.isRefentEnabled()) {
            return Double.MAX_VALUE;
        }
        Set layersToSnap = this.getMapContext().getLayersToSnap();
        double minDist = mapTolerance = this.vp.toMapDistance(mapControlManager.getTolerance());
        double middleTol = mapTolerance * 0.5;
        Point2D mapPoint = point;
        Envelope r = null;
        try {
            r = geomManager.createEnvelope(mapPoint.getX() - middleTol, mapPoint.getY() - middleTol, mapPoint.getX() + middleTol, mapPoint.getY() + middleTol, 0);
        }
        catch (Exception e1) {
            LOG.info("Error creating the envelope", (Throwable)e1);
            return Double.MAX_VALUE;
        }
        this.usedSnap = null;
        Point2D.Double lastPoint = null;
        if (this.previousPoint != null) {
            lastPoint = new Point2D.Double(this.previousPoint[0], this.previousPoint[1]);
        }
        ArrayList<Geometry> geomsToSnap = new ArrayList<Geometry>();
        for (FLyrVect lyrVect : layersToSnap) {
            SpatialCache cache = lyrVect.getSpatialCache();
            if (!lyrVect.isVisible()) continue;
            List geoms = cache.query(r);
            for (Object geom : geoms) {
                if (!(geom instanceof Geometry)) continue;
                geomsToSnap.add((Geometry)geom);
                if (geomsToSnap.size() <= 1000) continue;
                break;
            }
            if (geomsToSnap.size() <= 1000) continue;
            break;
        }
        for (int i = 0; i < mapControlManager.getSnapperCount(); ++i) {
            ISnapper theSnapper = mapControlManager.getSnapperAt(i);
            if (!(theSnapper instanceof ISnapperGeometriesVectorial)) continue;
            ((ISnapperGeometriesVectorial)theSnapper).setGeometries(geomsToSnap);
        }
        block5: for (int n = 0; n < geomsToSnap.size(); ++n) {
            Geometry geom = (Geometry)geomsToSnap.get(n);
            for (int i = 0; i < mapControlManager.getSnapperCount(); ++i) {
                double distAux;
                ISnapper theSnapper = mapControlManager.getSnapperAt(i);
                if (!theSnapper.isEnabled()) continue;
                if (this.usedSnap != null && theSnapper.getPriority() > this.usedSnap.getPriority()) continue block5;
                Point2D theSnappedPoint = null;
                if (theSnapper instanceof ISnapperVectorial) {
                    theSnappedPoint = ((ISnapperVectorial)theSnapper).getSnapPoint(point, geom, mapTolerance, lastPoint);
                }
                if (theSnapper instanceof ISnapperRaster) {
                    ISnapperRaster snapRaster = (ISnapperRaster)theSnapper;
                    theSnappedPoint = snapRaster.getSnapPoint(this, point, mapTolerance, lastPoint);
                }
                if (theSnappedPoint == null || !(minDist > (distAux = theSnappedPoint.distance(point)))) continue;
                minDist = distAux;
                this.usedSnap = theSnapper;
                mapHandlerAdjustedPoint.setLocation(theSnappedPoint);
            }
        }
        if (this.usedSnap != null) {
            return minDist;
        }
        return Double.MAX_VALUE;
    }

    public boolean isRefentEnabled() {
        return this.bRefent;
    }

    public void calculateSnapPoint(Point2D point) {
        Point2D gridAdjustedPoint = this.vp.toMapPoint(point);
        double minDistance = Double.MAX_VALUE;
        minDistance = this.cadgrid.adjustToGrid(gridAdjustedPoint);
        if (minDistance < Double.MAX_VALUE) {
            this.adjustedPoint = this.vp.fromMapPoint(gridAdjustedPoint);
            this.mapAdjustedPoint = gridAdjustedPoint;
        } else {
            this.mapAdjustedPoint = null;
        }
        Point2D handlerAdjustedPoint = null;
        handlerAdjustedPoint = this.mapAdjustedPoint != null ? (Point2D)this.mapAdjustedPoint.clone() : this.vp.toMapPoint(point);
        Point2D.Double mapPoint = new Point2D.Double();
        double distance = this.adjustToHandler(handlerAdjustedPoint, mapPoint);
        if (distance < minDistance) {
            this.bForceCoord = true;
            this.adjustedPoint = this.vp.fromMapPoint((Point2D)mapPoint);
            this.mapAdjustedPoint = mapPoint;
            minDistance = distance;
        }
        if (minDistance == Double.MAX_VALUE) {
            this.adjustedPoint = point;
            this.mapAdjustedPoint = null;
        }
    }

    public void setRefentEnabled(boolean activated) {
        this.bRefent = activated;
    }

    public Grid getGrid() {
        return this.cadgrid;
    }

    public void update(Observable observable, Object notification) {
        DataStoreNotification ddsn = (DataStoreNotification)notification;
        String type = ddsn.getType();
        if (type.equals("after_Undo_DataStore") || type.equals("after_Redo_DataStore")) {
            this.repaint();
        }
    }

    public Point2D getAdjustedPoint() {
        return this.adjustedPoint;
    }

    public Point2D getMapAdjustedPoint() {
        return this.mapAdjustedPoint;
    }

    public Point2D convertToMapPoint(Point2D point, boolean useSnapping) {
        Point2D p;
        if (useSnapping) {
            this.calculateSnapPoint(point);
            p = this.getMapAdjustedPoint();
            if (p == null) {
                p = this.getViewPort().toMapPoint(point);
            }
        } else {
            p = this.getViewPort().toMapPoint(point);
        }
        return p;
    }

    public Point2D getPoint() {
        if (this.mapAdjustedPoint != null) {
            return this.mapAdjustedPoint;
        }
        return this.getViewPort().toMapPoint(this.adjustedPoint);
    }

    public synchronized void dispose() {
        if (!this.disposed && ToolsLocator.getDisposableManager().release((Disposable)this)) {
            this.drawer.setShutdown(true);
            this.disposed = true;
        }
    }

    public boolean isDefaultMouseWheelEnabled() {
        return this.defaultMouseWheelEnabled;
    }

    public void setDefaultMouseWheelEnabled(boolean defaultMouseWheelEnabled) {
        this.defaultMouseWheelEnabled = defaultMouseWheelEnabled;
    }

    public void addChangeToolListener(ChangeListener listener) {
        this.changeToolListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeToolListeners() {
        return this.changeToolListenerHelper.getChangeListeners();
    }

    public void removeChangeToolListener(ChangeListener listener) {
        this.changeToolListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeToolListener() {
        this.changeToolListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeToolListeners() {
        return this.changeToolListenerHelper.hasChangeListeners();
    }

    static /* synthetic */ double[] access$1102(MapControl x0, double[] x1) {
        x0.previousPoint = x1;
        return x1;
    }

    public class MapContextListener
    implements AtomicEventListener {
        public void atomicEvent(final AtomicEvent e) {
            LayerCollectionEvent[] aux;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapContextListener.this.atomicEvent(e);
                    }
                });
                return;
            }
            LayerEvent[] layerEvents = e.getLayerEvents();
            for (int i = 0; i < layerEvents.length; ++i) {
                if (layerEvents[i].getProperty().equals("visible")) {
                    MapControl.this.drawMap(false);
                    return;
                }
                if (layerEvents[i].getEventType() != 3) continue;
                MapControl.this.drawMap(false);
                return;
            }
            if (e.getColorEvents().length > 0) {
                MapControl.this.drawMap(false);
                return;
            }
            if (e.getExtentEvents().length > 0) {
                MapControl.this.drawMap(false);
                return;
            }
            if (e.getProjectionEvents().length > 0) {
                // empty if block
            }
            if ((aux = e.getLayerCollectionEvents()).length > 0) {
                for (int i = 0; i < aux.length; ++i) {
                    if (!aux[i].getAffectedLayer().getFLayerStatus().isDriverLoaded()) continue;
                    MapControl.this.drawMap(false);
                    return;
                }
            }
            if (e.getLegendEvents().length > 0) {
                MapControl.this.drawMap(false);
                return;
            }
            if (e.getSelectionEvents().length > 0) {
                MapControl.this.drawMap(false);
                return;
            }
        }
    }

    public class MapToolListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        long t1;
        Point2D pReal;

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Point2D p;
                if (MapControl.this.currentMapTool != null) {
                    if (MapControl.this.mapAdjustedPoint != null) {
                        Point2D mp = MapControl.this.vp.fromMapPoint(MapControl.this.mapAdjustedPoint);
                        e.translatePoint((int)mp.getX() - e.getX(), (int)mp.getY() - e.getY());
                    }
                    MapControl.this.currentMapTool.mouseClicked(e);
                }
                if ((p = MapControl.this.mapAdjustedPoint != null ? MapControl.this.mapAdjustedPoint : MapControl.this.vp.toMapPoint(MapControl.this.adjustedPoint)) != null) {
                    MapControl.access$1102(MapControl.this, new double[]{p.getX(), p.getY()});
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MapControl.this.setToolMouse();
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mouseEntered(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mouseExited(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
            MapControl.this.usedSnap = null;
            MapControl.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mousePressed(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mouseReleased(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            try {
                if (MapControl.this.currentMapTool == null) {
                    return;
                }
                MapControl.this.currentMapTool.mouseWheelMoved(e);
                if (!e.isConsumed() && MapControl.this.defaultMouseWheelEnabled) {
                    if (this.t1 == 0L) {
                        this.t1 = System.currentTimeMillis();
                        this.pReal = MapControl.this.vp.toMapPoint((Point2D)e.getPoint());
                    } else {
                        long t2 = System.currentTimeMillis();
                        if (t2 - this.t1 > 1000L) {
                            this.t1 = 0L;
                        }
                    }
                    MapControl.this.cancelDrawing();
                    ViewPort vp = MapControl.this.getViewPort();
                    int amount = e.getWheelRotation();
                    double factor = amount < 0 ? 0.9 : 1.2;
                    if (vp.getExtent() != null) {
                        double nuevoX = this.pReal.getX() - vp.getExtent().getWidth() * factor / 2.0;
                        double nuevoY = this.pReal.getY() - vp.getExtent().getHeight() * factor / 2.0;
                        double x = nuevoX;
                        double y = nuevoY;
                        double width = vp.getExtent().getWidth() * factor;
                        double height = vp.getExtent().getHeight() * factor;
                        try {
                            vp.setEnvelope(geomManager.createEnvelope(x, y, x + width, y + height, 0));
                        }
                        catch (CreateEnvelopeException e1) {
                            LOG.info("Error creating the envelope", (Object)e);
                        }
                    }
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MapControl.this.calculateSnapPoint(e.getPoint());
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mouseDragged(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
            MapControl.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MapControl.this.calculateSnapPoint(e.getPoint());
            try {
                if (MapControl.this.currentMapTool != null) {
                    MapControl.this.currentMapTool.mouseMoved(e);
                }
            }
            catch (BehaviorException t) {
                MapControl.this.throwException(t);
            }
            MapControl.this.repaint();
        }
    }

    public class CancelDraw
    implements Cancellable {
        private boolean cancel = false;

        public void setCanceled(boolean b) {
            this.cancel = b;
        }

        public boolean isCanceled() {
            return this.cancel;
        }
    }

    public class Drawer {
        private PaintingRequest paintingRequest = null;
        private PaintingRequest waitingRequest = null;
        private boolean waiting = false;
        private boolean shutdown = false;
        private Thread worker = new Thread((Runnable)new Worker(), "MapControl Drawer Worker");

        public void setShutdown(boolean isShutdown) {
            this.shutdown = isShutdown;
            if (this.shutdown) {
                this.worker.interrupt();
            }
        }

        public Drawer() {
            this.worker.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(PaintingRequest newPaintRequest) {
            this.waitingRequest = newPaintRequest;
            if (this.waiting) {
                Drawer drawer = this;
                synchronized (drawer) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PaintingRequest take() {
            if (this.waitingRequest == null) {
                Drawer drawer = this;
                synchronized (drawer) {
                    this.waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        this.waiting = false;
                    }
                }
            }
            this.paintingRequest = this.waitingRequest;
            this.waitingRequest = null;
            return this.paintingRequest;
        }

        private class Worker
        implements Runnable {
            private Worker() {
            }

            @Override
            public void run() {
                while (!Drawer.this.shutdown) {
                    PaintingRequest p = Drawer.this.take();
                    if (MapControl.this.image != null) {
                        MapControl.this.cancelDrawing();
                        if (p == null) continue;
                        p.paint();
                        continue;
                    }
                    MapControl.this.status = 1;
                }
            }
        }
    }

    private class PaintingRequest {
        public void paint() {
            try {
                MapControl.this.canceldraw.setCanceled(false);
                if (MapControl.this.status == 1) {
                    BufferedImage drawImage = MapControl.this.image;
                    if (MapControl.this.paintMode == 1) {
                        drawImage = new BufferedImage(MapControl.this.image.getWidth(), MapControl.this.image.getHeight(), 2);
                    }
                    ViewPort theVp = MapControl.this.mapContext.getViewPort();
                    if (MapControl.this.image.getWidth() != theVp.getImageWidth() || MapControl.this.image.getHeight() != theVp.getImageHeight()) {
                        drawImage = new BufferedImage(theVp.getImageWidth(), theVp.getImageHeight(), 2);
                        MapControl.this.cancelDrawing();
                    }
                    MapControl.this.clearImage(drawImage);
                    Graphics2D g = drawImage.createGraphics();
                    MapControl.this.mapContext.draw(drawImage, g, (Cancellable)MapControl.this.canceldraw, MapControl.this.mapContext.getScaleView());
                    g.dispose();
                    MapControl.this.image = drawImage;
                    if (!MapControl.this.canceldraw.isCanceled()) {
                        MapControl.this.status = 0;
                    }
                }
                MapControl.this.timer.stop();
                MapControl.this.repaint();
            }
            catch (Throwable e) {
                MapControl.this.timer.stop();
                LOG.warn("Problems drawing mapcontext.", e);
                MapControl.this.throwException(e);
            }
        }
    }

    public class AddLayerEvent
    extends ActionEvent {
        private static final long serialVersionUID = -1857839388303164091L;
        private FLayer layer;

        public AddLayerEvent(FLayer layer, Object source, int id, String command) {
            super(source, id, command);
            this.layer = layer;
        }

        public FLayer getLayer() {
            return this.layer;
        }

        public void setLayer(FLayer layer) {
            this.layer = layer;
        }
    }
}

