/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.FeatureSelectionModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.BooleanCellRenderer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.ConfigurableFeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureAttributeCellRenderer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureCellRenderer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTableModel;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FormattedCellEditor;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FormattedCellRenderer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.GeometryWKTCellEditor;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.GeometryWKTCellRenderer;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.JToggleButtonHeaderCellRenderer;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTable
extends JTable
implements Observer,
Observable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureTable.class);
    private static final long serialVersionUID = -6139395189283163964L;
    private final FeatureTableModel featureTableModel;
    private JToggleButtonHeaderCellRenderer headerCellRenderer;
    private static final int COLUMN_HEADER_MARGIN = 8;
    private static final int COLUMN_HEADER_MIN_WIDTH = 50;
    private JLabel emptyLabel = new JLabel("");

    public FeatureTable(FeatureTableModel featureTableModel) throws DataException {
        super(featureTableModel);
        this.featureTableModel = featureTableModel;
        this.init();
    }

    public FeatureTable(FeatureTableModel featureTableModel, TableColumnModel cm) throws DataException {
        super(featureTableModel, cm);
        this.featureTableModel = featureTableModel;
        this.init();
    }

    public void update(Observable observable, Object notification) {
        if (notification instanceof FeatureStoreNotification) {
            FeatureStoreNotification fsNotification = (FeatureStoreNotification)notification;
            String type = fsNotification.getType();
            if ("after_SelectionChange_DataStore".equals(type)) {
                this.repaint();
            }
            if ("before_Delete_Feature".equals(type) && this.isEditing()) {
                ChangeEvent che = new ChangeEvent(this);
                this.editingCanceled(che);
            }
        }
    }

    public FeatureAttributeDescriptor[] getSelectedColumnsAttributeDescriptor() {
        int[] columns = this.headerCellRenderer.getSelectedColumns();
        FeatureAttributeDescriptor[] descriptors = new FeatureAttributeDescriptor[columns.length];
        for (int i = 0; i < descriptors.length; ++i) {
            descriptors[i] = this.featureTableModel.getDescriptorForColumn(columns[i]);
        }
        return descriptors;
    }

    public void addObserver(Observer observer) {
        this.headerCellRenderer.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.headerCellRenderer.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.headerCellRenderer.deleteObservers();
    }

    public void setSelectionUp(boolean selectionUp) {
        ((FeatureTableModel)this.getModel()).setSelectionUp(selectionUp);
        this.scrollRectToVisible(this.getCellRect(0, 0, true));
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.setDefaultRenderer(Geometry.class, new GeometryWKTCellRenderer());
        this.setDefaultEditor(Geometry.class, new GeometryWKTCellEditor());
        this.setDefaultRenderer(Feature.class, new FeatureCellRenderer());
        this.setDefaultRenderer(BigDecimal.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Double.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Float.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Integer.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Long.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Date.class, new FormattedCellRenderer());
        this.setDefaultRenderer(Boolean.class, new BooleanCellRenderer());
        this.setDefaultRenderer(String.class, new FeatureAttributeCellRenderer());
        this.setDefaultRenderer(Byte.class, new FeatureAttributeCellRenderer());
        if (this.getModel() instanceof ConfigurableFeatureTableModel) {
            ConfigurableFeatureTableModel model = (ConfigurableFeatureTableModel)this.getModel();
            this.setDefaultEditor(Double.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Float.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Integer.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Long.class, new FormattedCellEditor(model));
            this.setDefaultEditor(Date.class, new FormattedCellEditor(model));
        }
        this.setSelectionForeground(Color.blue);
        this.setSelectionBackground(Color.yellow);
    }

    private void init() throws DataException {
        this.setAutoResizeMode(0);
        this.featureTableModel.getFeatureStore().addObserver((Observer)this);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionModel(new FeatureSelectionModel(this.featureTableModel));
        this.headerCellRenderer = new JToggleButtonHeaderCellRenderer(this);
        this.getTableHeader().setDefaultRenderer(this.headerCellRenderer);
        TableColumnModel tcmodel = this.getColumnModel();
        for (int i = 0; i < tcmodel.getColumnCount(); ++i) {
            TableColumn col = tcmodel.getColumn(i);
            TableCellRenderer renderer = col.getHeaderRenderer();
            if (renderer == null) {
                renderer = this.getTableHeader().getDefaultRenderer();
            }
            Component comp = renderer.getTableCellRendererComponent(this, col.getHeaderValue(), false, false, 0, i);
            int width = comp.getPreferredSize().width;
            width = width < 50 ? 50 : width;
            col.setPreferredWidth(width + 16);
        }
        try {
            if (!this.featureTableModel.getFeatureStore().getFeatureSelection().isAvailable()) {
                this.setSelectionBackground(Color.PINK);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't check if selecction is available.", (Throwable)ex);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 115) {
                    FeatureTable.this.doShowCellInDialog();
                }
            }
        });
    }

    private void doShowCellInDialog() {
        int row = this.getSelectedRow();
        if (row < 0) {
            return;
        }
        int col = this.getSelectedColumn();
        if (col < 0) {
            return;
        }
        Object v = this.getValueAt(row, col);
        String s = v instanceof Geometry ? ((Geometry)v).convertToWKTQuietly() : Objects.toString(this.getValueAt(row, col), null);
        if (StringUtils.isBlank((CharSequence)s)) {
            return;
        }
        ToolsSwingLocator.getToolsSwingManager().showZoomDialog((Component)this, this.getColumnName(col), s, false);
    }

    @Override
    public int getSelectedColumnCount() {
        return this.headerCellRenderer.getSelectedColumns().length;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e != null && e.getFirstRow() == -1 && this.headerCellRenderer != null) {
            this.headerCellRenderer.deselectAll();
        }
        super.tableChanged(e);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> resp = super.getColumnClass(column);
        if (Timestamp.class.isAssignableFrom(resp)) {
            return Object.class;
        }
        return resp;
    }

    @Override
    public int getSelectedRowCount() {
        try {
            return (int)this.featureTableModel.getFeatureStore().getFeatureSelection().getSelectedCount();
        }
        catch (DataException ex) {
            LOGGER.error("Can't calculate selected rows in table.", (Throwable)ex);
            return 0;
        }
    }

    @Override
    public FeatureSelectionModel getSelectionModel() {
        return (FeatureSelectionModel)super.getSelectionModel();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        return super.prepareRenderer(renderer, row, column);
    }
}

