/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.feature.swing.table;

import java.util.List;
import javax.swing.AbstractListModel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreNotification;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontrol.dal.feature.swing.table.FeatureTypeListException;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class FeatureTypeListModel
extends AbstractListModel
implements Observer {
    private static final long serialVersionUID = -4274815135770376868L;
    private final FeatureStore featureStore;
    private final FeatureQuery featureQuery;

    public FeatureTypeListModel(FeatureStore featureStore, FeatureQuery featureQuery) {
        this.featureStore = featureStore;
        this.featureQuery = featureQuery;
        this.featureStore.addObserver((Observer)this);
    }

    @Override
    public int getSize() {
        return this.queryHasFeatureType() ? 1 : this.getFeatureTypes().size();
    }

    private boolean queryHasFeatureType() {
        return this.featureQuery != null && this.featureQuery.getFeatureTypeId() != null;
    }

    private List<FeatureType> getFeatureTypes() {
        try {
            return this.featureStore.getFeatureTypes();
        }
        catch (DataException e) {
            throw new RuntimeException("Error getting the feature types of the FeatureStore: " + this.featureStore, e);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.queryHasFeatureType() ? this.featureQuery.getFeatureTypeId() : this.getFeatureTypes().get(index).getId();
    }

    public void update(Observable observable, Object notification) {
        FeatureStoreNotification fsNotification;
        String type;
        if (observable.equals(this.featureStore) && notification instanceof FeatureStoreNotification && "after_Update_Type".equals(type = (fsNotification = (FeatureStoreNotification)notification).getType())) {
            if (this.queryHasFeatureType()) {
                this.fireContentsChanged(this, 0, 0);
            } else {
                EditableFeatureType featureType = fsNotification.getFeatureType();
                int index = this.getFeatureTypes().indexOf(featureType);
                this.fireContentsChanged(this, index, index);
            }
        }
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public FeatureType getFeatureType(String featureTypeId) {
        try {
            return this.featureStore.getFeatureType(featureTypeId);
        }
        catch (DataException e) {
            throw new FeatureTypeListException(e);
        }
    }
}

