/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.dal.swing.datastore;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontrol.dal.swing.datastore.DataStoreParametersCreationPanel;
import org.gvsig.fmap.mapcontrol.swing.dynobject.DynObjectEditor;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStoreParametersCreationPanel
extends DataStoreParametersCreationPanel
implements ActionListener {
    private static final long serialVersionUID = -1453149638996485029L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataStoreParametersCreationPanel.class);
    private static final DataManager DATA_MANAGER = DALLocator.getDataManager();
    private static final int FORM_HEIGTH = 18;
    private DataServerExplorer dataServerExplorer = null;
    private DataServerExplorerParameters dataServerExplorerParameters = null;
    private NewDataStoreParameters dataStoreParameters = null;
    private JButton explorersButton;
    private JComboBox explorersComboBox;
    private JButton providersButton;
    private JComboBox providersComboBox;

    public DefaultDataStoreParametersCreationPanel() {
        this.initComponents();
        this.populateExplorerCombo();
        this.initListeners();
        this.enableExplorerControls(false);
    }

    private void initListeners() {
        this.explorersComboBox.addActionListener(this);
        this.explorersButton.addActionListener(this);
        this.providersComboBox.addActionListener(this);
        this.providersButton.addActionListener(this);
    }

    private void populateExplorerCombo() {
        this.explorersComboBox.addItem(null);
        for (String explorer : DATA_MANAGER.getExplorerProviders()) {
            this.explorersComboBox.addItem(explorer);
        }
    }

    private void initComponents() {
        this.explorersComboBox = new JComboBox();
        this.providersComboBox = new JComboBox();
        this.explorersButton = new JButton();
        this.providersButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.explorersComboBox.setPreferredSize(new Dimension(0, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.explorersComboBox, gridBagConstraints);
        this.explorersButton.setText("...");
        this.explorersButton.setPreferredSize(new Dimension(25, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.explorersButton, gridBagConstraints);
        this.providersComboBox.setPreferredSize(new Dimension(0, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.providersComboBox, gridBagConstraints);
        this.providersButton.setText("...");
        this.providersButton.setPreferredSize(new Dimension(25, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.providersButton, gridBagConstraints);
    }

    @Override
    public NewDataStoreParameters getDataStoreParameters() {
        return this.dataStoreParameters;
    }

    @Override
    public DataServerExplorer getDataServerExplorer() {
        return this.dataServerExplorer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.explorersButton)) {
            this.explorersButtonClicked();
        } else if (e.getSource().equals(this.providersButton)) {
            this.providersButtonClicked();
        } else if (e.getSource().equals(this.explorersComboBox)) {
            this.explorersComboSelectionChanged();
        } else if (e.getSource().equals(this.providersComboBox)) {
            this.providersComboSelectionChanged();
        }
    }

    private void explorersComboSelectionChanged() {
        String explorerName = (String)this.explorersComboBox.getSelectedItem();
        if (explorerName == null) {
            this.dataServerExplorerParameters = null;
            this.dataServerExplorer = null;
            this.removeProvidersCombo();
            this.enableExplorerControls(false);
        } else if (this.dataServerExplorer == null || !explorerName.equals(this.dataServerExplorer.getProviderName())) {
            this.dataServerExplorerParameters = null;
            this.removeProvidersCombo();
            this.enableExplorerControls(false);
            this.explorersButton.setEnabled(true);
            try {
                this.dataServerExplorerParameters = DATA_MANAGER.createServerExplorerParameters(explorerName);
                this.dataServerExplorer = DATA_MANAGER.openServerExplorer(explorerName, this.dataServerExplorerParameters);
                this.populateProvidersCombo();
                this.providersComboBox.setEnabled(true);
            }
            catch (InitializeException e) {
                LOG.error("Error creating the explorer parameters", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                LOG.error("The explorer has not been registeger", (Throwable)e);
            }
            catch (ValidateDataParametersException e) {
                LOG.error("Error creating the explorer", (Throwable)e);
            }
        }
    }

    private void enableExplorerControls(boolean isEnabled) {
        this.explorersButton.setEnabled(isEnabled);
        this.providersComboBox.setEnabled(isEnabled);
        this.providersButton.setEnabled(isEnabled);
    }

    private void enableProviderControls(boolean isEnabled) {
        this.providersButton.setEnabled(isEnabled);
    }

    private void explorersButtonClicked() {
        this.dataServerExplorer = null;
        String explorerName = (String)this.explorersComboBox.getSelectedItem();
        if (explorerName != null) {
            try {
                if (this.dataServerExplorerParameters == null || !this.dataServerExplorerParameters.getExplorerName().equals(explorerName)) {
                    this.dataServerExplorerParameters = DATA_MANAGER.createServerExplorerParameters(explorerName);
                }
                DynObjectEditor dynObjectEditor = new DynObjectEditor((DynObject)this.dataServerExplorerParameters);
                dynObjectEditor.editObject(true);
                this.dataServerExplorer = DATA_MANAGER.openServerExplorer(explorerName, this.dataServerExplorerParameters);
                this.removeProvidersCombo();
                this.populateProvidersCombo();
                this.providersComboBox.setEnabled(true);
            }
            catch (InitializeException e) {
                LOG.error("Error creating the explorer parameters", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                LOG.error("The explorer has not been registered", (Throwable)e);
            }
            catch (ServiceException e) {
                LOG.error("Error creating the explorer panel", (Throwable)e);
            }
            catch (ValidateDataParametersException e) {
                LOG.error("Error creating the explorer", (Throwable)e);
            }
        }
    }

    private void populateProvidersCombo() {
        this.providersComboBox.addItem(null);
        if (this.dataServerExplorer != null) {
            List providerNames = this.dataServerExplorer.getDataStoreProviderNames();
            for (int i = 0; i < providerNames.size(); ++i) {
                this.providersComboBox.addItem(providerNames.get(i));
            }
        }
    }

    private void removeProvidersCombo() {
        this.providersComboBox.removeAllItems();
    }

    private void providersComboSelectionChanged() {
        this.dataStoreParameters = null;
        String providerName = (String)this.providersComboBox.getSelectedItem();
        if (this.dataServerExplorer != null && providerName != null) {
            this.enableProviderControls(true);
        } else {
            this.enableProviderControls(false);
        }
    }

    private void providersButtonClicked() {
        String providerName = (String)this.providersComboBox.getSelectedItem();
        if (this.dataServerExplorer != null && providerName != null) {
            try {
                if (this.dataStoreParameters == null || !this.dataStoreParameters.getDataStoreName().equals(providerName)) {
                    this.dataStoreParameters = DATA_MANAGER.createNewStoreParameters(this.dataServerExplorer.getProviderName(), providerName);
                }
                DynObjectEditor dynObjectEditor = new DynObjectEditor((DynObject)this.dataStoreParameters);
                dynObjectEditor.editObject(true);
            }
            catch (InitializeException e) {
                LOG.error("Error creating the store parameters", (Throwable)e);
            }
            catch (ProviderNotRegisteredException e) {
                LOG.error("The provider has not been registered", (Throwable)e);
            }
            catch (ServiceException e) {
                LOG.error("Error creating the store panel", (Throwable)e);
            }
        }
    }
}

