/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.PrimitivesDrawer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrimitivesDrawer
implements PrimitivesDrawer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPrimitivesDrawer.class);
    protected Graphics2D graphics = null;
    protected Color color = Color.BLACK;
    protected Color xorColor = Color.WHITE;
    private Object lockObject = null;

    public DefaultPrimitivesDrawer() {
    }

    public DefaultPrimitivesDrawer(Graphics2D graphics) {
        this.graphics = graphics;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        Color prevColor = this.graphics.getColor();
        this.graphics.setXORMode(this.xorColor);
        this.graphics.setColor(this.color);
        this.graphics.drawLine(x1, y1, x2, y2);
        this.graphics.setPaintMode();
        this.graphics.setColor(prevColor);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Color prevColor = this.graphics.getColor();
        this.graphics.setXORMode(this.xorColor);
        this.graphics.setColor(this.color);
        this.graphics.drawOval(x, y, width, height);
        this.graphics.setPaintMode();
        this.graphics.setColor(prevColor);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        Color prevColor = this.graphics.getColor();
        this.graphics.setXORMode(this.xorColor);
        this.graphics.setColor(this.color);
        this.graphics.drawRect(x, y, width, height);
        this.graphics.setPaintMode();
        this.graphics.setColor(prevColor);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.graphics.setColor(this.color);
        this.graphics.fillRect(x, y, width, height);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.graphics = (Graphics2D)graphics;
    }

    @Override
    public void stopDrawing(Object obj) {
        if (this.lockObject != obj) {
            LOG.info("Trying to unlock a resource that is not locked");
            return;
        }
        this.lockObject = null;
    }

    @Override
    public void startDrawing(Object obj) throws InterruptedException {
        while (this.lockObject != null && obj != this.lockObject) {
            Thread.sleep(100L);
        }
        this.lockObject = obj;
    }

    public void setRenderingHints(RenderingHints hints) {
        this.graphics.setRenderingHints(hints);
    }

    public void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    public void cleanCanvas(MapControl mapCtrl) {
        BufferedImage img = mapCtrl.getImage();
        this.graphics.drawImage((Image)img, 0, 0, null);
    }
}

