/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.swing.dynformfield.Geometry;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JCustomTextField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDynFormFieldGeometry
extends AbstractJDynFormField
implements JDynFormField,
FocusListener {
    private static final Logger logger = LoggerFactory.getLogger(JDynFormFieldGeometry.class);
    private static final int SHOWMODE_DEFAULT = 0;
    private static final int SHOWMODE_WKT = 1;
    private static final int SHOWMODE_WKB = 2;
    private static final int SHOWMODE_GEOJSON = 3;
    protected Geometry assignedValue = null;
    protected Geometry currentValue = null;
    protected int showMode = 0;

    public JDynFormFieldGeometry(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = (Geometry)value;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    protected JCustomTextField getJTextField() {
        return (JCustomTextField)this.contents;
    }

    public void initComponent() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        JCustomTextField jtext = new JCustomTextField(this.getLabel());
        jtext.addFocusListener((FocusListener)this);
        jtext.setEditable(false);
        jtext.addSeparatorToPopupMenu();
        jtext.addActionToPopupMenu(i18nManager.getTranslation("_Use_default_format_to_view_geometry"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDynFormFieldGeometry.this.changeShowMode(0);
            }
        });
        jtext.addActionToPopupMenu(i18nManager.getTranslation("_Use_WKT_to_view_geometry"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDynFormFieldGeometry.this.changeShowMode(1);
            }
        });
        jtext.addActionToPopupMenu(i18nManager.getTranslation("_Use_WKB_to_view_geometry"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDynFormFieldGeometry.this.changeShowMode(2);
            }
        });
        jtext.addActionToPopupMenu(i18nManager.getTranslation("_Use_GeoJson_to_view_geometry"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDynFormFieldGeometry.this.changeShowMode(3);
            }
        });
        this.contents = jtext;
        this.contents.setVisible(true);
        this.setValue(this.assignedValue);
    }

    private void changeShowMode(int showMode) {
        switch (showMode) {
            case 1: {
                String s;
                if (this.currentValue == null) {
                    s = "";
                } else {
                    try {
                        s = this.currentValue.convertToWKT();
                    }
                    catch (Exception e) {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        logger.warn("Can't convert geometry to WKT.", (Throwable)e);
                        JOptionPane.showMessageDialog(this.asJComponent(), i18nManager.getTranslation("_Cant_convert_geometry_to_WKT"), i18nManager.getTranslation("_Warning"), 2);
                        s = "";
                    }
                }
                this.getJTextField().setText(s);
                this.getJTextField().setEditable(true);
                this.showMode = showMode;
                break;
            }
            case 2: {
                String s;
                if (this.currentValue == null) {
                    s = "";
                } else {
                    try {
                        s = this.currentValue.convertToHexEWKB();
                    }
                    catch (Exception e) {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        logger.warn("Can't convert geometry to WKT.", (Throwable)e);
                        JOptionPane.showMessageDialog(this.asJComponent(), i18nManager.getTranslation("_Cant_convert_geometry_to_WKT"), i18nManager.getTranslation("_Warning"), 2);
                        s = "";
                    }
                }
                this.getJTextField().setText(s);
                this.getJTextField().setEditable(true);
                this.showMode = showMode;
                break;
            }
            case 3: {
                String s;
                if (this.currentValue == null) {
                    s = "";
                } else {
                    try {
                        s = this.currentValue.convertToGeoJson(null, true);
                    }
                    catch (Exception e) {
                        I18nManager i18nManager = ToolsLocator.getI18nManager();
                        logger.warn("Can't convert geometry to GeoJson.", (Throwable)e);
                        JOptionPane.showMessageDialog(this.asJComponent(), i18nManager.getTranslation("_Cant_convert_geometry_to_GeoJson"), i18nManager.getTranslation("_Warning"), 2);
                        s = "";
                    }
                }
                this.getJTextField().setText(s);
                this.getJTextField().setEditable(true);
                this.showMode = showMode;
                break;
            }
            default: {
                Geometry x;
                try {
                    x = (Geometry)this.getValue();
                }
                catch (AbstractJDynFormField.IllegalFieldValue ex) {
                    x = null;
                }
                if (x != null) {
                    this.getJTextField().setText(x.toString());
                } else {
                    this.getJTextField().setText("");
                }
                this.showMode = showMode;
                this.getJTextField().setEditable(false);
                this.currentValue = x;
            }
        }
    }

    public boolean hasValidValue() {
        switch (this.showMode) {
            case 1: 
            case 3: {
                try {
                    this.getDefinition().getDataType().coerce((Object)this.getJTextField().getText());
                }
                catch (CoercionException e) {
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.fireFieldEnterEvent();
        this.problemIndicator().restore();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.fireFieldExitEvent();
    }

    public void setValue(Object value) {
        Geometry x;
        try {
            x = (Geometry)this.getDefinition().getDataType().coerce(value);
        }
        catch (CoercionException e) {
            throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getMessage());
        }
        if (x != null) {
            String s;
            switch (this.showMode) {
                case 1: {
                    try {
                        s = x.convertToWKT();
                    }
                    catch (Exception e) {
                        this.showMode = 0;
                        this.getJTextField().setEditable(false);
                        s = x.toString();
                    }
                    break;
                }
                case 2: {
                    try {
                        s = x.convertToHexEWKB();
                    }
                    catch (Exception e) {
                        this.showMode = 0;
                        this.getJTextField().setEditable(false);
                        s = x.toString();
                    }
                    break;
                }
                case 3: {
                    try {
                        s = x.convertToGeoJson(null, true);
                    }
                    catch (Exception e) {
                        this.showMode = 0;
                        this.getJTextField().setEditable(false);
                        s = x.toString();
                    }
                    break;
                }
                default: {
                    s = x.toString();
                }
            }
            this.getJTextField().setText(s);
        }
        this.currentValue = x;
        this.assignedValue = x;
    }

    public Object getValue() {
        Geometry x = null;
        switch (this.showMode) {
            case 1: {
                try {
                    x = (Geometry)this.getDefinition().getDataType().coerce((Object)this.getJTextField().getText());
                }
                catch (CoercionException e) {
                    throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getMessage());
                }
                this.currentValue = x;
                return this.currentValue;
            }
            case 2: {
                try {
                    x = (Geometry)this.getDefinition().getDataType().coerce((Object)this.getJTextField().getText());
                }
                catch (CoercionException e) {
                    throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getMessage());
                }
                this.currentValue = x;
                return this.currentValue;
            }
            case 3: {
                try {
                    x = (Geometry)this.getDefinition().getDataType().coerce((Object)this.getJTextField().getText());
                }
                catch (CoercionException e) {
                    throw new AbstractJDynFormField.IllegalFieldValue((AbstractJDynFormField)this, (JDynFormField)this, e.getMessage());
                }
                this.currentValue = x;
                return this.currentValue;
            }
        }
        return this.currentValue;
    }
}

