/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundBehavior
extends Behavior
implements Iterable<Behavior> {
    private static final Logger logger = LoggerFactory.getLogger(CompoundBehavior.class);
    private List<Behavior> behaviors = new ArrayList<Behavior>();
    private List<Boolean> draws = new ArrayList<Boolean>();
    private static Behavior behavior = null;

    public CompoundBehavior(Behavior[] behaviors) {
        for (int i = 0; i < behaviors.length; ++i) {
            if (behaviors[i] != null) continue;
            throw new IllegalArgumentException("behaviors");
        }
        boolean first = true;
        for (int i = 0; i < behaviors.length; ++i) {
            if (this.containsBehavior(behaviors[i])) continue;
            this.behaviors.add(behaviors[i]);
            if (first) {
                this.draws.add(Boolean.TRUE);
            } else {
                this.draws.add(Boolean.FALSE);
            }
            first = false;
        }
    }

    public void addMapBehavior(Behavior mt, boolean draw) {
        if (mt == null) {
            throw new IllegalArgumentException("mt");
        }
        if (!this.containsBehavior(mt)) {
            this.behaviors.add(mt);
            this.draws.add(draw);
        }
    }

    public void removeMapBehavior(Behavior mt) {
        int index = this.behaviors.indexOf(mt);
        if (index >= 0) {
            this.behaviors.remove(index);
            this.draws.remove(index);
        }
    }

    public boolean containsBehavior(Behavior mt) {
        return this.behaviors.indexOf(mt) > -1;
    }

    public Behavior getBehavior(int index) {
        return this.behaviors.get(index);
    }

    public boolean isDrawnBehavior(int index) {
        return this.draws.get(index);
    }

    public void setDrawnBehavior(int index, boolean draw) {
        this.draws.set(index, draw);
    }

    public int size() {
        return this.behaviors.size();
    }

    @Override
    public Image getImageCursor() {
        if (this.behaviors.size() > 0) {
            Behavior beh = this.behaviors.get(0);
            return beh.getImageCursor();
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseClicked(e);
        }
        if (behavior != null) {
            behavior.mouseClicked(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseDragged(e);
        }
        if (behavior != null) {
            behavior.mouseDragged(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseEntered(e);
        }
        if (behavior != null) {
            behavior.mouseEntered(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseExited(e);
        }
        if (behavior != null) {
            behavior.mouseExited(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseMoved(e);
        }
        if (behavior != null) {
            behavior.mouseMoved(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mousePressed(e);
        }
        if (behavior != null) {
            behavior.mousePressed(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseReleased(e);
        }
        if (behavior != null) {
            behavior.mouseReleased(e);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) throws BehaviorException {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].mouseWheelMoved(e);
        }
        if (behavior != null) {
            behavior.mouseWheelMoved(e);
        }
    }

    @Override
    public void paintComponent(MapControlDrawer renderer) {
        this.paintComponent(renderer, false);
    }

    @Override
    public void paintComponent(MapControlDrawer renderer, boolean clean) {
        if (clean) {
            this.clean(renderer);
        }
        for (int i = 0; i < this.behaviors.size(); ++i) {
            Behavior mapTool = this.behaviors.get(i);
            if (!this.draws.get(i).booleanValue()) continue;
            mapTool.paintComponent(renderer, false);
        }
    }

    public void setListener(ToolListener listener) {
        if (listener != null) {
            throw new UnsupportedOperationException("CompoundBehavior does not have listeners");
        }
    }

    @Override
    public ToolListener getListener() {
        return null;
    }

    @Override
    public void setMapControl(MapControl mc) {
        Behavior[] behaviors = this.behaviors.toArray(new Behavior[0]);
        for (int i = 0; i < behaviors.length; ++i) {
            behaviors[i].setMapControl(mc);
        }
        super.setMapControl(mc);
    }

    public static void setAllControlsBehavior(Behavior behavior) {
        CompoundBehavior.behavior = behavior;
    }

    public static Behavior getAllControlsBehavior() {
        return behavior;
    }

    @Override
    public Iterator<Behavior> iterator() {
        return this.behaviors.iterator();
    }
}

