/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.Events;

import java.awt.event.MouseEvent;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Circumference;
import org.gvsig.fmap.geom.primitive.Ellipse;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.PeriEllipse;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasureEvent {
    private GeneralPathX gp;
    private Double[] x;
    private Double[] y;
    private MouseEvent event;
    private static final Logger logger = LoggerFactory.getLogger(MeasureEvent.class);

    public MeasureEvent(Double[] x, Double[] y, MouseEvent e) {
        this.x = x;
        this.y = y;
        this.event = e;
        this.gp = new GeneralPathX(0, x.length);
        this.gp.moveTo(x[0].doubleValue(), y[0].doubleValue());
        for (int index = 1; index < x.length; ++index) {
            this.gp.lineTo(x[index].doubleValue(), y[index].doubleValue());
        }
    }

    public GeneralPathX getGP() {
        return this.gp;
    }

    public void setGP(GeneralPathX gp) {
        this.gp = gp;
    }

    public Double[] getXs() {
        return this.x;
    }

    public Double[] getYs() {
        return this.y;
    }

    public MouseEvent getEvent() {
        return this.event;
    }

    public Geometry getCircle() {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        Circle geom = null;
        try {
            Point center = (Point)manager.create(1, 0);
            center.setX(this.getXs()[0].doubleValue());
            center.setY(this.getYs()[0].doubleValue());
            Point point2 = (Point)manager.create(1, 0);
            point2.setX(this.getXs()[1].doubleValue());
            point2.setY(this.getYs()[1].doubleValue());
            double radious = center.distance((Geometry)point2);
            Circle circle = (Circle)manager.create(11, 0);
            circle.setPoints(center, radious);
            geom = circle;
        }
        catch (CreateGeometryException e) {
            logger.error("Failed_creating_geometry", (Throwable)e);
        }
        catch (GeometryOperationNotSupportedException e) {
            logger.error("Operation_not_supported", (Throwable)e);
        }
        catch (GeometryOperationException e) {
            logger.error("Failed_performing_the_operation", (Throwable)e);
        }
        return geom;
    }

    public Geometry getCircumference() {
        GeometryManager manager = GeometryLocator.getGeometryManager();
        Circumference geom = null;
        try {
            Point center = (Point)manager.create(1, 0);
            center.setX(this.getXs()[0].doubleValue());
            center.setY(this.getYs()[0].doubleValue());
            Point point2 = (Point)manager.create(1, 0);
            point2.setX(this.getXs()[1].doubleValue());
            point2.setY(this.getYs()[1].doubleValue());
            double radious = center.distance((Geometry)point2);
            Circumference circle = (Circumference)manager.create(23, 0);
            circle.setPoints(center, radious);
            geom = circle;
        }
        catch (CreateGeometryException e) {
            logger.error("Failed_creating_geometry", (Throwable)e);
        }
        catch (GeometryOperationNotSupportedException e) {
            logger.error("Operation_not_supported", (Throwable)e);
        }
        catch (GeometryOperationException e) {
            logger.error("Failed_performing_the_operation", (Throwable)e);
        }
        return geom;
    }

    public Geometry getEllipse() {
        Ellipse geom = null;
        try {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Point point1 = (Point)manager.create(1, 0);
            point1.setX(this.getXs()[0].doubleValue());
            point1.setY(this.getYs()[0].doubleValue());
            Point point2 = (Point)manager.create(1, 0);
            point2.setX(this.getXs()[1].doubleValue());
            point2.setY(this.getYs()[1].doubleValue());
            Point point3 = (Point)manager.create(1, 0);
            point3.setX(this.getXs()[2].doubleValue());
            point3.setY(this.getYs()[2].doubleValue());
            double radious = point2.distance((Geometry)point3);
            Ellipse ellipse = (Ellipse)manager.create(13, 0);
            ellipse.setPoints(point1, point2, radious);
            geom = ellipse;
        }
        catch (CreateGeometryException e) {
            logger.error("Failed_creating_geometry", (Throwable)e);
        }
        catch (GeometryOperationNotSupportedException e) {
            logger.error("Operation_not_supported", (Throwable)e);
        }
        catch (GeometryOperationException e) {
            logger.error("Failed_performing_the_operation", (Throwable)e);
        }
        return geom;
    }

    public Geometry getPeriEllipse() {
        MultiLine geom = null;
        try {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            Point point1 = (Point)manager.create(1, 0);
            point1.setX(this.getXs()[0].doubleValue());
            point1.setY(this.getYs()[0].doubleValue());
            Point point2 = (Point)manager.create(1, 0);
            point2.setX(this.getXs()[1].doubleValue());
            point2.setY(this.getYs()[1].doubleValue());
            Point point3 = (Point)manager.create(1, 0);
            point3.setX(this.getXs()[2].doubleValue());
            point3.setY(this.getYs()[2].doubleValue());
            double radious = point2.distance((Geometry)point3);
            PeriEllipse ellipse = (PeriEllipse)manager.create(24, 0);
            ellipse.setPoints(point1, point2, radious);
            geom = ellipse.toLines();
        }
        catch (CreateGeometryException e) {
            logger.error("Failed_creating_geometry", (Throwable)e);
        }
        catch (GeometryOperationNotSupportedException e) {
            logger.error("Operation_not_supported", (Throwable)e);
        }
        catch (GeometryOperationException e) {
            logger.error("Failed_performing_the_operation", (Throwable)e);
        }
        catch (GeometryException e) {
            logger.error("Can't create line geometry from ellipse", (Throwable)e);
        }
        return geom;
    }
}

