/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.MoveEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanListenerImpl
implements PanListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(PanListenerImpl.class);
    private MapControl mapControl;

    public PanListenerImpl(MapControl mapControl) {
        this.mapControl = mapControl;
    }

    @Override
    public void move(MoveEvent event) {
        ViewPort vp = this.mapControl.getMapContext().getViewPort();
        Point2D from = vp.toMapPoint(event.getFrom());
        Point2D to = vp.toMapPoint(event.getTo());
        Rectangle2D extent = vp.getExtent();
        double x = extent.getX() - (to.getX() - from.getX());
        double y = extent.getY() - (to.getY() - from.getY());
        double width = extent.getWidth();
        double height = extent.getHeight();
        try {
            Envelope r = geomManager.createEnvelope(x, y, x + width, y + height, 0);
            vp.setEnvelope(r);
        }
        catch (CreateEnvelopeException e) {
            logger.warn("Error creating the envelope", (Throwable)e);
        }
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-pan");
    }

    @Override
    public boolean cancelDrawing() {
        return true;
    }
}

