/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.ListModel;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.featuretable.SimpleFeaturesTableModel;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.fmap.mapcontrol.tools.PointSelectionListener;
import org.gvsig.fmap.mapcontrol.tools.PointSelectionListenerUniqueSelect;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointSelectionListenerUniqueSelectPanel
extends PointSelectionListenerUniqueSelect
implements Component {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointSelectionListenerUniqueSelectPanel.class);
    SimpleFeaturesTableModel simpleTableModel;
    ListModel layersModel;
    List<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>> clickedFeatures;
    private FeatureReference lastFeature;
    private FeatureStore lastStore;
    private final boolean toggle;
    private final MapControl mapControl;
    private final ChangeListener mapControlListener;

    public PointSelectionListenerUniqueSelectPanel(MapControl mapControl, boolean toggle) {
        this.mapControl = mapControl;
        this.toggle = toggle;
        this.mapControlListener = e -> {
            Behavior currentMapTool = mapControl.getCurrentMapTool();
            boolean found = false;
            if (currentMapTool instanceof CompoundBehavior) {
                CompoundBehavior behaviors = (CompoundBehavior)currentMapTool;
                for (Behavior behavior : behaviors) {
                    if (!(behavior.getListener() instanceof PointSelectionListener)) continue;
                    found = true;
                    break;
                }
            } else if (currentMapTool.getListener() instanceof PointSelectionListener) {
                found = true;
            }
            if (!found) {
                this.setVisible(false);
            }
        };
        this.translate();
        this.initComponents();
    }

    protected void translate() {
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnPrevious);
        swingManager.translate((AbstractButton)this.btnNext);
    }

    public JComponent asJComponent() {
        return this;
    }

    private void initComponents() {
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointSelectionListenerUniqueSelectPanel.this.doPrevious();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointSelectionListenerUniqueSelectPanel.this.doNext();
            }
        });
        this.lstLayers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PointSelectionListenerUniqueSelectPanel.this.doSelectLayer();
            }
        });
        this.tblSelection.getSelectionModel().setSelectionMode(0);
        this.tblSelection.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                PointSelectionListenerUniqueSelectPanel.this.doSelectFeature();
            }
        });
        this.tblSelection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 38) {
                    PointSelectionListenerUniqueSelectPanel.this.doPrevious();
                    e.consume();
                } else if (e.getKeyCode() == 40) {
                    PointSelectionListenerUniqueSelectPanel.this.doNext();
                    e.consume();
                }
            }
        });
        this.mapControl.addChangeToolListener(this.mapControlListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                PointSelectionListenerUniqueSelectPanel.this.mapControl.removeChangeToolListener(PointSelectionListenerUniqueSelectPanel.this.mapControlListener);
            }
        });
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)12, (int)50, (int)20, (int)100);
    }

    public void put(List<Pair<FLyrVect, UnmodifiableBasicList64<Feature>>> clickedFeatures) {
        this.clickedFeatures = clickedFeatures;
        this.layersModel = new DefaultListModel();
        for (Pair<FLyrVect, UnmodifiableBasicList64<Feature>> pair : clickedFeatures) {
            FLyrVect layer = (FLyrVect)pair.getLeft();
            ((DefaultListModel)this.layersModel).addElement(layer);
            if (this.toggle) continue;
            try {
                layer.getFeatureStore().getFeatureSelection().deselectAll();
            }
            catch (DataException ex) {
                LOGGER.warn("Can't deselect all", (Throwable)ex);
            }
        }
        this.lstLayers.setModel(this.layersModel);
        this.lstLayers.setSelectedIndex(0);
        this.doSelectLayer();
        this.tblSelection.getSelectionModel().setSelectionInterval(0, 0);
    }

    private void doPrevious() {
        if (this.simpleTableModel != null) {
            int selectedRow = this.tblSelection.getSelectedRow();
            if (selectedRow <= 0) {
                int selectedLayerIndex = this.lstLayers.getSelectedIndex();
                selectedLayerIndex = selectedLayerIndex <= 0 ? this.lstLayers.getModel().getSize() - 1 : --selectedLayerIndex;
                this.lstLayers.getSelectionModel().setSelectionInterval(selectedLayerIndex, selectedLayerIndex);
                this.doSelectLayer();
                selectedRow = this.tblSelection.getModel().getRowCount() - 1;
            } else {
                --selectedRow;
            }
            this.tblSelection.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.tblSelection.scrollRectToVisible(this.tblSelection.getCellRect(selectedRow, 0, true));
        }
    }

    private void doNext() {
        if (this.simpleTableModel != null) {
            int selectedRow = this.tblSelection.getSelectedRow();
            if (selectedRow >= this.tblSelection.getRowCount() - 1) {
                int selectedLayerIndex = this.lstLayers.getSelectedIndex();
                selectedLayerIndex = selectedLayerIndex >= this.lstLayers.getModel().getSize() - 1 ? 0 : ++selectedLayerIndex;
                this.lstLayers.getSelectionModel().setSelectionInterval(selectedLayerIndex, selectedLayerIndex);
                this.doSelectLayer();
                selectedRow = 0;
            } else {
                ++selectedRow;
            }
            this.tblSelection.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            this.tblSelection.scrollRectToVisible(this.tblSelection.getCellRect(selectedRow, 0, true));
        }
    }

    private void doSelectLayer() {
        FLyrVect layer = (FLyrVect)this.lstLayers.getSelectedValue();
        if (layer != null) {
            this.simpleTableModel = DALSwingLocator.getDataSwingManager().createSimpleFeaturesTableModel(layer.getFeatureStore().getDefaultFeatureTypeQuietly(), null, this.getFeatures((FLayer)layer).toList());
            this.simpleTableModel.setCellRenderers(this.tblSelection);
            this.tblSelection.setModel((TableModel)this.simpleTableModel);
            ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
            swingManager.createTableColumnAdjuster(this.tblSelection);
        }
    }

    private void doSelectFeature() {
        FLyrVect layer = (FLyrVect)this.lstLayers.getSelectedValue();
        if (layer == null) {
            return;
        }
        int n = this.tblSelection.getSelectedRow();
        if (n < 0) {
            return;
        }
        try {
            if (this.toggle) {
                if (this.lastFeature != null) {
                    FeatureSelection selection = this.lastStore.getFeatureSelection();
                    if (selection.isSelected(this.lastFeature)) {
                        selection.deselect(this.lastFeature);
                    } else {
                        selection.select(this.lastFeature);
                    }
                }
                FeatureStore store = layer.getFeatureStore();
                Feature f = this.simpleTableModel.getFeatureAt(n);
                FeatureSelection selection = store.getFeatureSelection();
                if (selection.isSelected(f)) {
                    selection.deselect(f);
                } else {
                    selection.select(f);
                }
                this.lastFeature = f.getReference();
                this.lastStore = store;
            } else {
                if (this.lastFeature != null) {
                    this.lastStore.getFeatureSelection().deselect(this.lastFeature);
                }
                FeatureStore store = layer.getFeatureStore();
                Feature f = this.simpleTableModel.getFeatureAt(n);
                store.getFeatureSelection().select(f);
                this.lastFeature = f.getReference();
                this.lastStore = store;
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't select feature.", (Throwable)ex);
        }
    }

    private UnmodifiableBasicList64<Feature> getFeatures(FLayer layer) {
        if (this.clickedFeatures != null) {
            for (Pair<FLyrVect, UnmodifiableBasicList64<Feature>> pair : this.clickedFeatures) {
                if (pair.getLeft() != layer) continue;
                return (UnmodifiableBasicList64)pair.getRight();
            }
        }
        return null;
    }

    public Feature getSelectedFeature() {
        if (this.simpleTableModel != null) {
            int selectedRow = this.tblSelection.getSelectedRow();
            Feature feature = (Feature)this.simpleTableModel.get(selectedRow);
            return feature;
        }
        return null;
    }
}

