/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.MeasureEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolygonSelectionListener
implements PolylineListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(PolygonSelectionListener.class);
    private MapControl mapCtrl;

    public PolygonSelectionListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-select-by-polygon");
    }

    @Override
    public boolean cancelDrawing() {
        return false;
    }

    @Override
    public void points(MeasureEvent event) throws BehaviorException {
    }

    @Override
    public void pointFixed(MeasureEvent event) throws BehaviorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void polylineFinished(MeasureEvent event) throws BehaviorException {
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            GeneralPathX gp = event.getGP();
            Surface geom = (Surface)geomManager.create(3, 0);
            geom.setGeneralPath(gp);
            FLayer[] actives = this.mapCtrl.getMapContext().getLayers().getActives();
            for (int i = 0; i < actives.length; ++i) {
                FeatureSet newSelection;
                block9: {
                    if (!(actives[i] instanceof FLyrVect)) continue;
                    FLyrVect lyrVect = (FLyrVect)actives[i];
                    newSelection = null;
                    try {
                        newSelection = event.getEvent().isShiftDown() ? lyrVect.queryByContainedInGeometry((Geometry)geom, lyrVect.getFeatureStore().getDefaultFeatureType()) : lyrVect.queryByGeometry((Geometry)geom, lyrVect.getFeatureStore().getDefaultFeatureType());
                        if (event.getEvent().isControlDown()) {
                            FeatureSelection currentSelection = (FeatureSelection)lyrVect.getFeatureStore().getSelection();
                            DisposableIterator it = newSelection.fastIterator();
                            while (it.hasNext()) {
                                Object obj = it.next();
                                if (!(obj instanceof Feature)) continue;
                                Feature feat = (Feature)obj;
                                if (currentSelection.isSelected(feat)) {
                                    currentSelection.deselect(feat);
                                    continue;
                                }
                                currentSelection.select(feat);
                            }
                            break block9;
                        }
                        lyrVect.getDataStore().setSelection((DataSet)newSelection);
                    }
                    catch (Throwable throwable) {
                        DisposeUtils.dispose(newSelection);
                        throw throwable;
                    }
                }
                DisposeUtils.dispose((Disposable)newSelection);
            }
        }
        catch (DataException e) {
            throw new BehaviorException("No se pudo hacer la selecci\u00f3n", e);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new BehaviorException("No se pudo hacer la selecci\u00f3n", (Throwable)new CreateGeometryException(3, 0, (Throwable)e));
        }
    }
}

