/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.IconThemeHelper;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Events.EnvelopeEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZoomInListenerImpl
implements RectangleListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(ZoomInListenerImpl.class);
    private MapControl mapCtrl;

    public ZoomInListenerImpl() {
    }

    public ZoomInListenerImpl(MapControl mapCtrl) {
        this();
        this.mapCtrl = mapCtrl;
    }

    @Override
    public void rectangle(EnvelopeEvent event) {
        Envelope rect = event.getWorldCoordRect();
        Rectangle2D pixelRect = event.getPixelCoordRect();
        ViewPort vp = this.mapCtrl.getMapContext().getViewPort();
        if (pixelRect.getWidth() < 3.0 && pixelRect.getHeight() < 3.0) {
            if (vp.getExtent() != null) {
                double factor = 1.0 / MapContext.ZOOMINFACTOR;
                double x = rect.getMaximum(0) - vp.getExtent().getWidth() * factor / 2.0;
                double y = rect.getMaximum(1) - vp.getExtent().getHeight() * factor / 2.0;
                double width = vp.getExtent().getWidth() * factor;
                double height = vp.getExtent().getHeight() * factor;
                try {
                    Envelope r = geomManager.createEnvelope(x, y, x + width, y + height, 0);
                    vp.setEnvelope(r);
                }
                catch (CreateEnvelopeException e) {
                    logger.error("Error creating the envelope", (Throwable)e);
                }
            }
        } else {
            vp.setEnvelope(event.getWorldCoordRect());
        }
    }

    @Override
    public Image getImageCursor() {
        return IconThemeHelper.getImage("cursor-zoom-in");
    }

    @Override
    public boolean cancelDrawing() {
        logger.debug("cancelDrawing true");
        return true;
    }
}

