/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.mapcontrol.tools.geo;

public class Geo {
    public static double HalfPi = 1.5707963267948966;
    public static double Degree = 57.29577951308232;
    public static double SqMi = 273218.4;
    public static double SqKm = 707632.4;
    public static double SqM = 7.076324E11;

    public static double getDecimalDegrees(double m) {
        return m * 8.983152841195214E-6;
    }

    private static double hav(double X) {
        return (1.0 - Math.cos(X)) / 2.0;
    }

    public static double sphericalPolyArea(double[] lat, double[] lon, int n) {
        double lam2 = 0.0;
        double beta2 = 0.0;
        double cosB2 = 0.0;
        double sum = 0.0;
        for (int j = 0; j <= n; ++j) {
            double cosB1;
            double beta1;
            double lam1;
            int k = j + 1;
            if (j == 0) {
                lam1 = lon[j];
                beta1 = lat[j];
                lam2 = lon[j + 1];
                beta2 = lat[j + 1];
                cosB1 = Math.cos(beta1);
                cosB2 = Math.cos(beta2);
            } else {
                k = (j + 1) % (n + 1);
                lam1 = lam2;
                beta1 = beta2;
                lam2 = lon[k];
                beta2 = lat[k];
                cosB1 = cosB2;
                cosB2 = Math.cos(beta2);
            }
            if (lam1 == lam2) continue;
            double havA = Geo.hav(beta2 - beta1) + cosB1 * cosB2 * Geo.hav(lam2 - lam1);
            double a = 2.0 * Math.asin(Math.sqrt(havA));
            double b = HalfPi - beta2;
            double c = HalfPi - beta1;
            double s = 0.5 * (a + b + c);
            double t = Math.tan(s / 2.0) * Math.tan((s - a) / 2.0) * Math.tan((s - b) / 2.0) * Math.tan((s - c) / 2.0);
            double excess = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(t)))) * Degree;
            if (lam2 < lam1) {
                excess = -excess;
            }
            sum += excess;
        }
        return Math.abs(sum);
    }
}

