/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.oracle.dal.OracleConnectionParameters;
import org.gvsig.oracle.dal.OracleHelper;

public class OracleConnectionParametersHelper {
    private final OracleConnectionParameters parameters;

    public OracleConnectionParametersHelper(JDBCConnectionParameters parameters) {
        this.parameters = (OracleConnectionParameters)parameters;
    }

    public String getUrl() {
        String url = (String)this.getDynValue("url");
        if (StringUtils.isBlank((CharSequence)url)) {
            url = OracleHelper.getConnectionURL(this.parameters);
            this.setDynValue("url", url);
        }
        return url;
    }

    public void validate() throws ValidateDataParametersException {
        if (this.getDynValue("jdbcdriverclass") == null) {
            this.setDynValue("jdbcdriverclass", "oracle.jdbc.driver.OracleDriver");
        }
        if (this.getDynValue("port") == null) {
            this.setDynValue("port", 1521);
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)this.getDynValue("url")))) {
            String url = OracleHelper.getConnectionURL(this.parameters.getHost(), this.parameters.getPort(), this.parameters.getDBName(), this.parameters.getMode());
            this.setDynValue("url", url);
        }
    }

    private Object getDynValue(String name) {
        return this.parameters.getDynValue(name);
    }

    private void setDynValue(String name, Object value) {
        this.parameters.setDynValue(name, value);
    }

    public String getMode() {
        return (String)this.getDynValue("mode");
    }

    public void setMode(String mode) {
        this.setDynValue("mode", mode);
    }

    public Integer getLobPrefetchSize() {
        String s = (String)this.getDynValue("LobPrefetchSize");
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        try {
            int n = Integer.parseInt(s);
            return n;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setLobPrefetchSize(Integer size) {
        this.setDynValue("LobPrefetchSize", Objects.toString(size, null));
    }

    public boolean getUpdateSpatialIndexAndMetadata() {
        boolean updateSpatialIndexAndMetadata = (Boolean)this.getDynValue("updateSpatialIndexAndMetadata");
        return updateSpatialIndexAndMetadata;
    }

    public void setUpdateSpatialIndexAndMetadata(boolean updateSpatialIndexAndMetadata) {
        this.setDynValue("updateSpatialIndexAndMetadata", updateSpatialIndexAndMetadata);
    }

    public boolean getForceUppercaseInTableName() {
        boolean force = (Boolean)this.getDynValue("forceUppercaseInTableName");
        return force;
    }

    public void setForceUppercaseInTableName(boolean force) {
        this.setDynValue("forceUppercaseInTableName", force);
    }
}

