/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.sql.BLOB;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.DelegatedGeometryExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilderHelper;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.SQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc.JDBCConnectionParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.oracle.dal.GeometryTypeUtils;
import org.gvsig.oracle.dal.OracleConnectionParameters;
import org.gvsig.oracle.dal.OracleHelper;
import org.gvsig.oracle.dal.SpatialIndexUtils;
import org.gvsig.oracle.dal.expressionbuilderformatter.OracleFormatter;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.Disposable;

public class OracleSQLBuilder
extends JDBCSQLBuilderBase {
    protected static final String ADD_SERIAL_COLUMN_SEQUENCE_QUERY = "CREATE SEQUENCE \"{0}\"";
    protected static final String ADD_SERIAL_COLUMN_TRIGGER_QUERY = "CREATE OR REPLACE TRIGGER \"{0}\" BEFORE INSERT ON {1} FOR EACH ROW BEGIN SELECT \"{3}\".NEXTVAL INTO :new.\"{2}\" FROM dual; END;";
    protected static final String DELETE_FROM_OGIS_GEOMETRY_COLUMNS_QUERY = "DELETE FROM MDSYS.OGIS_GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = ''{0}'' AND F_TABLE_NAME = ''{1}'' AND F_GEOMETRY_COLUMN = ''{2}''";
    protected static final String INSERT_OGIS_GEOMETRY_COLUMNS_QUERY = "INSERT INTO MDSYS.OGIS_GEOMETRY_COLUMNS (F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN, GEOMETRY_TYPE) VALUES (''{0}'', ''{1}'', ''{2}'', {3})";
    private final String quote_for_identifiers;
    private final String quote_for_strings;
    public static final String ST_GEOMFROMTEXT = "SDO_GEOMETRY(({0}), ({1}))";
    public static final String ST_GEOMFROMWKB = "SDO_GEOMETRY(({0}), ({1}))";
    public static final String ST_GEOMFROMEWKB = "SDO_GEOMETRY(({0}), ({1}))";
    public static final String FORMAT_OPERATOR_NOTISNULL = "( (({0}) IS NOT NULL) )";
    public static final String FORMAT_OPERATOR_AND = "( ({0}) AND ({1}) )";
    public static final String FORMAT_OPERATOR_OR = "( ({0}) OR ({1}) )";
    public static final String FORMAT_OPERATOR_NE = "( ({0}) != ({1}) )";
    public static final String FORMAT_OPERATOR_ILIKE = "( LOWER({0}) LIKE LOWER({1}) )";
    public static final String FORMAT_OPERATOR_CONCAT = "{0} + {1}";
    public static final int BOOLEAN_STRING_DEFAULT_LENGTH = 1;
    private static final Geometry EMPTY_POINT = GeometryUtils.createPoint((double)0.0, (double)0.0);
    protected Formatter formatter = null;
    private OracleGeometryExpressionBuilder oracleExpressionBuilder = null;

    public OracleSQLBuilder(JDBCHelper helper) {
        super(helper);
        this.defaultSchema = "";
        this.allowAutomaticValues = true;
        this.geometrySupportType = this.helper.getGeometrySupportType();
        this.hasSpatialFunctions = this.helper.hasSpatialFunctions();
        this.constant_true = "TRUE";
        this.constant_false = "FALSE";
        this.quote_for_identifiers = "\"";
        this.quote_for_strings = "'";
        this.type_boolean = "CHAR(1)";
        this.type_byte = "NUMBER(3,0)";
        this.type_bytearray = "BLOB";
        this.type_geometry = "SDO_GEOMETRY";
        this.type_char = "CHAR(1)";
        this.type_date = "DATE";
        this.type_double = "BINARY_DOUBLE";
        this.type_decimal_p = "NUMBER({0})";
        this.type_decimal_ps = "NUMBER({0},{1})";
        this.type_float = "BINARY_FLOAT";
        this.type_int = "NUMBER(9,0)";
        this.type_long = "NUMBER(18,0)";
        this.type_string = "NCLOB";
        this.type_string_0 = "NCLOB";
        this.type_string_p = "NVARCHAR2({0,Number,#######})";
        this.type_time = "TIMESTAMP";
        this.type_timestamp = "TIMESTAMP";
        this.type_version = "VARCHAR2(30)";
        this.type_URI = "NVARCHAR2(2048)";
        this.type_URL = "NVARCHAR2(2048)";
        this.type_FILE = "NVARCHAR2(2048)";
        this.type_FOLDER = "NVARCHAR2(2048)";
        this.STMT_DELETE_FROM_table_WHERE_expresion = "DELETE FROM {0} WHERE {1}";
        this.STMT_DELETE_FROM_table = "DELETE FROM {0}";
        this.STMT_INSERT_INTO_table_columns_VALUES_values = "INSERT INTO {0} ( {1} ) VALUES ( {2} )";
        this.STMT_UPDATE_TABLE_STATISTICS_table = "VACUUM ANALYZE {0}";
        this.STMT_DROP_TABLE_table = "DROP TABLE {0}";
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_table = null;
        this.STMT_DELETE_GEOMETRY_COLUMN_FROM_TABLE_schema_table = null;
        this.STMT_UPDATE_table_SET_columnsAndValues_WHERE_expresion = "UPDATE {0} SET {1} WHERE {2}";
        this.STMT_UPDATE_table_SET_columnsAndValues = "UPDATE {0} SET {1}";
        this.STMT_GRANT_privileges_ON_table_TO_role = "GRANT {0} ON {1} TO {2}";
    }

    public OracleHelper getHelper() {
        return (OracleHelper)super.getHelper();
    }

    public Formatter formatter() {
        if (this.formatter == null) {
            this.formatter = new OracleFormatter(this);
        }
        return this.formatter;
    }

    public GeometryExpressionBuilder expression() {
        if (this.oracleExpressionBuilder == null) {
            this.oracleExpressionBuilder = new OracleGeometryExpressionBuilder(super.expression());
        }
        return this.oracleExpressionBuilder;
    }

    public String default_schema() {
        JDBCConnectionParameters params = this.helper.getConnectionParameters();
        if (params != null) {
            if (StringUtils.isBlank((CharSequence)params.getSchema())) {
                if (StringUtils.isNotBlank((CharSequence)params.getUser())) {
                    return params.getUser();
                }
            } else {
                return params.getSchema();
            }
        }
        return this.defaultSchema;
    }

    public String getSerialSequenceName(String tableName, String columnName) {
        return ("GVSEQ_" + tableName + "_" + columnName).toUpperCase();
    }

    public String getSerialTriggerName(String tableName, String columnName) {
        return ("GVSER_" + tableName + "_" + columnName).toUpperCase();
    }

    public SQLBuilder.TableNameBuilder createTableNameBuilder() {
        return new OracleTableNameBuilder();
    }

    protected SQLBuilder.CreateTableBuilder createCreateTableBuilder() {
        return new OracleCreateTableBuilder();
    }

    public SQLBuilder.SelectBuilder createSelectBuilder() {
        return new OracleSelectBuilder();
    }

    protected SQLBuilder.FromBuilder createFromBuilder() {
        return new OracleFromBuilder();
    }

    protected SQLBuilder.UpdateTableStatisticsBuilder createUpdateTableStatisticsBuilder() {
        return new OracleUpdateTableStatisticsBuilderBase();
    }

    public String getProviderTableName(OperationsFactory.TableReference table) {
        return this.getProviderTableName(table.getTable());
    }

    private String getProviderTableName(String tableName) {
        boolean forceUpperCase = true;
        OracleConnectionParameters params = this.getHelper().getConnectionParameters();
        if (params != null) {
            forceUpperCase = params.getForceUppercaseInTableName();
        }
        if (forceUpperCase) {
            return StringUtils.upperCase((String)tableName);
        }
        return tableName;
    }

    protected void setBlob(PreparedStatement st, int columnIndex, byte[] bytes, DisposableBlobs blobList) throws SQLException, IOException {
        ByteArrayInputStream inputStream;
        Connection conn = st.getConnection();
        if (conn instanceof DelegatingConnection) {
            conn = ((DelegatingConnection)conn).getInnermostDelegate();
        }
        BLOB blob = BLOB.createTemporary((Connection)conn, (boolean)false, (int)10);
        blobList.add(blob);
        try (OutputStream outputStream = blob.setBinaryStream(0L);){
            int byteread;
            inputStream = new ByteArrayInputStream(bytes);
            byte[] buffer = new byte[blob.getBufferSize()];
            while ((byteread = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, byteread);
            }
        }
        ((InputStream)inputStream).close();
        st.setBlob(columnIndex, (Blob)blob);
    }

    public Disposable setStatementParameters(PreparedStatement st, List values, List<Integer> types, GeometryExpressionBuilderHelper.GeometrySupportType geometrySupportType) throws SQLException {
        DisposableBlobs blobList = new DisposableBlobs();
        if (values == null) {
            return blobList;
        }
        try {
            int columnIndex = 1;
            for (Object value : values) {
                if (value instanceof Geometry) {
                    switch (geometrySupportType) {
                        case WKT: {
                            value = ((Geometry)value).convertToWKT();
                            st.setObject(columnIndex, value);
                            break;
                        }
                        case NATIVE: 
                        case WKB: {
                            byte[] bytes = ((Geometry)value).convertToWKB();
                            this.setBlob(st, columnIndex, bytes, blobList);
                            break;
                        }
                        case EWKB: {
                            byte[] bytes = ((Geometry)value).convertToEWKB();
                            this.setBlob(st, columnIndex, bytes, blobList);
                        }
                    }
                } else if (types == null) {
                    st.setObject(columnIndex, value);
                } else {
                    this.setStatementValue(st, columnIndex, types.get(columnIndex - 1), value);
                }
                ++columnIndex;
            }
        }
        catch (Exception ex) {
            throw new SQLException("Can't set values for the prepared statement.", ex);
        }
        return blobList;
    }

    public List<Object> getParameters(FeatureProvider feature) {
        return this.getParameters(feature, null);
    }

    public List<Object> getParameters(FeatureProvider feature, List<Integer> types) {
        try {
            FeatureType type = feature.getType();
            FeatureType providerType = this.getHelper().getProviderFeatureType();
            ArrayList<Object> values = new ArrayList<Object>();
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            block8: for (ExpressionBuilder.Parameter parameter : this.parameters()) {
                Object x;
                FeatureAttributeDescriptor attrDescProvider;
                Object value;
                if (parameter.is_constant()) {
                    value = parameter.value();
                    values.add(value);
                    if (types == null) continue;
                    if (value == null) {
                        if (values.get(values.size() - 2) == EMPTY_POINT) {
                            types.add(4);
                            continue;
                        }
                        types.add(64);
                        continue;
                    }
                    DataType dataType = dataTypesManager.getDataType(value.getClass());
                    types.add(dataType.getType());
                    continue;
                }
                String name = parameter.name();
                value = feature.get(name);
                FeatureAttributeDescriptor attrDesc = type.getAttributeDescriptor(name);
                Coercion convert = null;
                if (providerType != null && (attrDescProvider = providerType.getAttributeDescriptor(name)) != null && attrDescProvider.getType() != attrDesc.getType()) {
                    convert = attrDescProvider.getDataType().getCoercion();
                }
                switch (attrDesc.getType()) {
                    case 66: {
                        Geometry geom = this.forceGeometryType(attrDesc.getGeomType(), (Geometry)value);
                        if (!BooleanUtils.isTrue((Boolean)((Boolean)parameter.getProperty("oracleGeometryParameter")))) continue block8;
                        if (geom == null) {
                            values.add(null);
                            values.add(EMPTY_POINT);
                        } else {
                            values.add(1);
                            values.add(geom);
                        }
                        if (types == null) continue block8;
                        types.add(4);
                        types.add(66);
                        continue block8;
                    }
                    case 1: {
                        if (value == null) {
                            values.add(null);
                        } else if (convert == null) {
                            values.add(value);
                        } else {
                            String s = (String)convert.coerce(value);
                            values.add(s == null ? null : s.substring(0, 1));
                        }
                        if (types == null) continue block8;
                        types.add(8);
                        continue block8;
                    }
                }
                if (convert == null) {
                    values.add(value);
                } else {
                    values.add(convert.coerce(value));
                }
                if (types == null) continue;
                int t = attrDesc.getDataType().getType();
                types.add(t);
                if (t != 4 || (x = values.get(values.size() - 1)) == null || x instanceof Integer) continue;
                LOGGER.debug("Esto est? mal");
            }
            return values;
        }
        catch (Exception ex) {
            String f = "unknow";
            try {
                f = feature.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Can't get parameters to prepared statement from the feature (" + f + ")", ex);
        }
    }

    public List<String> parameters_names() {
        ArrayList<String> params = new ArrayList<String>();
        for (ExpressionBuilder.Parameter param : this.parameters()) {
            String s;
            switch (param.type()) {
                case 0: {
                    Object theValue = param.value();
                    if (theValue == null) {
                        s = "null";
                        break;
                    }
                    if (theValue instanceof String) {
                        s = "'" + (String)theValue + "'";
                        break;
                    }
                    s = theValue.toString();
                    break;
                }
                default: {
                    s = "\"" + param.name() + "\"";
                }
            }
            params.add(s);
            if (!BooleanUtils.isTrue((Boolean)((Boolean)param.getProperty("oracleGeometryParameter")))) continue;
            params.add(s);
        }
        return params;
    }

    public String blob(byte[] data) {
        StringBuilder builder = new StringBuilder();
        builder.append("TO_BLOB(HEXTORAW('");
        for (byte abyte : data) {
            int v = abyte & 0xFF;
            builder.append(String.format("%02x", v));
        }
        builder.append("'))");
        return builder.toString();
    }

    public String as_clob(String s) {
        int chunkSize = 1024;
        StringBuilder builder = new StringBuilder();
        builder.append("(TO_CLOB('");
        for (int i = 0; i < s.length(); i += chunkSize) {
            String chunk = s.substring(i, Math.min(s.length(), i + chunkSize));
            if (i > 0) {
                builder.append("') || TO_CLOB('");
            }
            builder.append(StringUtils.replace((String)chunk, (String)"'", (String)"''"));
        }
        builder.append("'))");
        return builder.toString();
    }

    protected SQLBuilder.AlterTableBuilder createAlterTableBuilder() {
        return new OracleAlterTableBuilder((SQLBuilderBase)this);
    }

    public SQLBuilder.CreateIndexBuilder createCreateIndexBuilder() {
        return new OracleCreateIndexBuilder();
    }

    public String quote_for_identifiers() {
        return this.quote_for_identifiers;
    }

    public String quote_for_strings() {
        return this.quote_for_strings;
    }

    protected SQLBuilder.SelectColumnBuilder createSelectColumnBuilder() {
        return new OracleSelectColumnBuilder((SQLBuilder)this);
    }

    public SQLBuilder.SelectBuilder select() {
        if (this.select == null) {
            this.select = this.createSelectBuilder();
        }
        return this.select;
    }

    public SQLBuilder.UpdateBuilder update() {
        if (this.update == null) {
            this.update = this.createUpdateBuilder();
        }
        return this.update;
    }

    public SQLBuilder.UpdateTableStatisticsBuilder update_table_statistics() {
        if (this.update_table_statistics == null) {
            this.update_table_statistics = this.createUpdateTableStatisticsBuilder();
        }
        return this.update_table_statistics;
    }

    public SQLBuilder.DropTableBuilder drop_table() {
        if (this.drop_table == null) {
            this.drop_table = this.createDropTableBuilder();
        }
        return this.drop_table;
    }

    public SQLBuilder.CreateIndexBuilder create_index() {
        if (this.create_index == null) {
            this.create_index = this.createCreateIndexBuilder();
        }
        return this.create_index;
    }

    public SQLBuilder.DeleteBuilder delete() {
        if (this.delete == null) {
            this.delete = this.createDeleteBuilder();
        }
        return this.delete;
    }

    public SQLBuilder.InsertBuilder insert() {
        if (this.insert == null) {
            this.insert = this.createInsertBuilder();
        }
        return this.insert;
    }

    public SQLBuilder.TableNameBuilder table_name() {
        if (this.table_name == null) {
            this.table_name = this.createTableNameBuilder();
        }
        return this.table_name;
    }

    public SQLBuilder.AlterTableBuilder alter_table() {
        if (this.alter_table == null) {
            this.alter_table = this.createAlterTableBuilder();
        }
        return this.alter_table;
    }

    public SQLBuilder.CreateTableBuilder create_table() {
        if (this.create_table == null) {
            this.create_table = this.createCreateTableBuilder();
        }
        return this.create_table;
    }

    public SQLBuilder.GrantBuilder grant() {
        if (this.grant == null) {
            this.grant = this.createGrantBuilder();
        }
        return this.grant;
    }

    public String sqltype(int type, int size, int precision, int scale, int geomType, int geomSubtype) {
        switch (type) {
            case 19: {
                if (precision > 38 && scale < 0) {
                    if (precision > 126) {
                        precision = 126;
                    }
                    return String.format("FLOAT(%d)", precision);
                }
                if (precision < 1) {
                    precision = 20;
                }
                if (scale < 1) {
                    return MessageFormat.format(this.type_decimal_p, precision);
                }
                return MessageFormat.format(this.type_decimal_ps, precision, scale);
            }
        }
        return super.sqltype(type, size, precision, scale, geomType, geomSubtype);
    }

    public int getMaxRecomendedSQLLength() {
        return 2048;
    }

    public boolean canBeBoolean(ExpressionBuilder.Value value) {
        ExpressionBuilder.Constant c;
        FeatureAttributeDescriptor attr = this.getAttributeDescriptor(value);
        if (attr != null && attr.getType() == 8) {
            return true;
        }
        return value instanceof ExpressionBuilder.Constant && (c = (ExpressionBuilder.Constant)value).value() instanceof CharSequence;
    }

    private FeatureAttributeDescriptor getAttributeDescriptor(ExpressionBuilder.Value value) {
        ExpressionBuilder.Variable variable;
        FeatureAttributeDescriptor attr = null;
        FeatureType featureType = (FeatureType)value.getProperty("FeatureType");
        if (value instanceof ExpressionBuilder.Variable && (attr = featureType.getAttributeDescriptor((variable = (ExpressionBuilder.Variable)value).name())) == null) {
            FeatureQuery query = (FeatureQuery)value.getProperty("Query");
            attr = query.getExtraColumn().get(variable.name());
        }
        return attr;
    }

    public String formatAsBoolean(Formatter<ExpressionBuilder.Value> formatter, ExpressionBuilder.Value value) {
        String s = "(UPPER(" + value.toString(formatter) + ") = 'T')";
        return s;
    }

    public class OracleSelectColumnBuilder
    extends SQLBuilderBase.SelectColumnBuilderBase {
        public OracleSelectColumnBuilder(SQLBuilder sqlbuilder) {
            super((SQLBuilderBase)OracleSQLBuilder.this, sqlbuilder);
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            StringBuilder builder = new StringBuilder();
            if (this.asGeometry) {
                if (this.value == ExpressionBuilder.VALUE_NULL) {
                    builder.append(this.value.toString(formatter));
                } else {
                    builder.append(OracleSQLBuilder.this.expression().ST_AsBinary((ExpressionBuilder.Value)this.name).toString(formatter));
                }
            } else if (this.value == null) {
                builder.append(this.name.toString(formatter));
            } else {
                builder.append(this.value.toString(formatter));
            }
            if (this.alias != null) {
                builder.append(" ");
                builder.append(OracleSQLBuilder.this.as_identifier(this.alias));
            }
            return builder.toString();
        }
    }

    public class OracleAlterTableBuilder
    extends SQLBuilderBase.AlterTableBuilderBase {
        public OracleAlterTableBuilder(SQLBuilderBase sqlbuilder) {
            super((SQLBuilderBase)OracleSQLBuilder.this, sqlbuilder);
        }

        public List<String> toStrings() {
            StringBuilder builder;
            ArrayList<String> sqls = new ArrayList<String>();
            ArrayList<String> pks = new ArrayList<String>();
            for (String column : this.drops) {
                builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                builder.append(this.table.toString());
                builder.append(" DROP COLUMN ");
                builder.append(OracleSQLBuilder.this.as_identifier(column));
                sqls.add(builder.toString());
            }
            for (String column : this.adds) {
                builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                builder.append(this.table.toString());
                builder.append(" ADD ");
                builder.append(OracleSQLBuilder.this.as_identifier(column.getName()));
                builder.append(" ");
                builder.append(OracleSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                if (column.getDefaultValue() == null) {
                    if (column.allowNulls()) {
                        builder.append(" DEFAULT NULL");
                    }
                } else {
                    builder.append(" DEFAULT '");
                    builder.append(column.getDefaultValue().toString());
                    builder.append("'");
                }
                if (column.allowNulls()) {
                    builder.append(" NULL");
                } else {
                    builder.append(" NOT NULL");
                }
                if (column.isPrimaryKey()) {
                    pks.add(column.getName());
                }
                sqls.add(builder.toString());
                if (pks.size() > 0) {
                    builder = new StringBuilder("ALTER TABLE ");
                    builder.append(this.table.toString());
                    builder.append(" ADD PRIMARY KEY (");
                    for (int i = 0; i < pks.size(); ++i) {
                        if (i != 0) {
                            builder.append(", ");
                        }
                        builder.append(OracleSQLBuilder.this.as_identifier((String)pks.get(i)));
                    }
                    builder.append(")");
                    sqls.add(builder.toString());
                }
                if (column.isAutomatic()) {
                    String sequenceName = OracleSQLBuilder.this.getSerialSequenceName(this.table.getName(), column.getName());
                    String sql = MessageFormat.format(OracleSQLBuilder.ADD_SERIAL_COLUMN_SEQUENCE_QUERY, sequenceName);
                    sqls.add(sql);
                    String autoTriggerName = OracleSQLBuilder.this.getSerialTriggerName(this.table.getName(), column.getName());
                    sql = MessageFormat.format(OracleSQLBuilder.ADD_SERIAL_COLUMN_TRIGGER_QUERY, autoTriggerName, this.table.toString(OracleSQLBuilder.this.formatter), column.getName(), sequenceName);
                    sqls.add(sql);
                }
                if (!column.isGeometry()) continue;
                int gvsigType = column.getGeometryType();
                int gvsigSubtype = column.getGeometryType();
                String sql = MessageFormat.format(OracleSQLBuilder.DELETE_FROM_OGIS_GEOMETRY_COLUMNS_QUERY, this.table().getSchema(), this.table().getName(), column.getName());
                sqls.add(sql);
                sql = MessageFormat.format(OracleSQLBuilder.INSERT_OGIS_GEOMETRY_COLUMNS_QUERY, this.table().getSchema(), this.table().getName(), column.getName(), Integer.toString(GeometryTypeUtils.toSFSGeometryTypeCode(gvsigType, gvsigSubtype)));
                sqls.add(sql);
            }
            for (String column : this.alters) {
                if (column.isGeometry()) continue;
                builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                builder.append(this.table.toString());
                builder.append(" MODIFY (");
                builder.append(OracleSQLBuilder.this.as_identifier(column.getName()));
                builder.append(" ");
                builder.append(OracleSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                if (column.getDefaultValue() == null) {
                    builder.append(" DEFAULT NULL");
                } else {
                    builder.append(" DEFAULT '");
                    builder.append(column.getDefaultValue().toString());
                    builder.append("'");
                }
                builder.append(")");
                sqls.add(builder.toString());
            }
            for (Pair pair : this.renames) {
                builder = new StringBuilder();
                builder.append("ALTER TABLE ");
                builder.append(this.table.toString());
                builder.append(" RENAME COLUMN ");
                builder.append(OracleSQLBuilder.this.as_identifier((String)pair.getLeft()));
                builder.append(" TO ");
                builder.append(OracleSQLBuilder.this.as_identifier((String)pair.getRight()));
                sqls.add(builder.toString());
            }
            return sqls;
        }
    }

    public class OracleCreateIndexBuilder
    extends SQLBuilderBase.CreateIndexBuilderBase {
        public OracleCreateIndexBuilder() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public List<String> toStrings() {
            ArrayList<String> sqls = new ArrayList<String>();
            if (!this.isSpatial) {
                StringBuilder builder = new StringBuilder();
                builder.append("CREATE ");
                if (this.isUnique) {
                    builder.append("UNIQUE ");
                }
                builder.append("INDEX ");
                builder.append(OracleSQLBuilder.this.as_identifier(this.indexName));
                builder.append(" ON ");
                builder.append(this.table.toString());
                builder.append(" ( ");
                boolean is_first_column = true;
                for (String column : this.columns) {
                    if (is_first_column) {
                        is_first_column = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append(OracleSQLBuilder.this.as_identifier(column));
                }
                builder.append(" )");
                sqls.add(builder.toString());
            }
            return sqls;
        }
    }

    public class DisposableBlobs
    implements Disposable {
        private final ArrayList<BLOB> blobList = new ArrayList();

        public void add(BLOB blob) {
            this.blobList.add(blob);
        }

        public void dispose() {
            this.blobList.forEach(blob -> {
                try {
                    blob.freeTemporary();
                }
                catch (SQLException ex) {
                    LOGGER.warn("Can't dispose blob " + blob.toString(), (Throwable)ex);
                }
            });
        }
    }

    public class OracleFromBuilder
    extends SQLBuilderBase.FromBuilderBase {
        public OracleFromBuilder() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (!StringUtils.isEmpty((CharSequence)this.passthrough)) {
                return this.passthrough;
            }
            if (!StringUtils.isEmpty((CharSequence)this.subquery)) {
                return "( " + this.subquery + ") " + OracleSQLBuilder.this.quote_for_identifiers() + "_subquery_alias_" + OracleSQLBuilder.this.quote_for_identifiers() + " ";
            }
            if (this.joins == null || this.joins.isEmpty()) {
                return this.tableName.toString(formatter);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(this.tableName.toString(formatter));
            for (SQLBuilder.JoinBuilder join : this.joins) {
                builder.append(" ");
                builder.append(join.toString(formatter));
            }
            return builder.toString();
        }
    }

    protected class OracleTableNameBuilder
    extends SQLBuilderBase.TableNameBuilderBase {
        protected OracleTableNameBuilder() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public boolean has_database() {
            return false;
        }

        public String toString() {
            return this.toString((Formatter<ExpressionBuilder.Value>)OracleSQLBuilder.this.formatter());
        }

        protected String databaseName2provider() {
            return null;
        }

        protected String schemaName2provider() {
            return this.schemaName;
        }

        protected String tableName2provider() {
            return OracleSQLBuilder.this.getProviderTableName(this.tableName);
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            if (formatter != null && formatter.canApply((Object)this)) {
                return formatter.format((Object)this);
            }
            if (this.has_schema()) {
                return OracleSQLBuilder.this.as_identifier(this.schemaName2provider()) + "." + OracleSQLBuilder.this.as_identifier(this.tableName2provider());
            }
            OracleConnectionParameters params = OracleSQLBuilder.this.getHelper().getConnectionParameters();
            if (params != null && StringUtils.isNotBlank((CharSequence)params.getUser())) {
                return OracleSQLBuilder.this.as_identifier(params.getUser()) + "." + OracleSQLBuilder.this.as_identifier(this.tableName2provider());
            }
            return OracleSQLBuilder.this.as_identifier(this.tableName2provider());
        }
    }

    public class OracleSelectBuilder
    extends SQLBuilderBase.SelectBuilderBase {
        public OracleSelectBuilder() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public String toString(Formatter<ExpressionBuilder.Value> formatter) {
            boolean involveWithLimitOrOffset;
            StringBuilder builder = new StringBuilder();
            if (!this.isValid(builder)) {
                throw new IllegalStateException(builder.toString());
            }
            boolean bl = involveWithLimitOrOffset = !(!this.has_offset() && !this.has_limit() || !this.has_aggregate_functions() && !this.has_group_by() && !this.has_order_by());
            if (involveWithLimitOrOffset) {
                builder.append("SELECT * FROM ( ");
                if (this.has_offset()) {
                    builder.append("SELECT a.*, ROWNUM rnum FROM ( ");
                }
            }
            builder.append("SELECT ");
            if (this.distinct) {
                builder.append("DISTINCT ");
            }
            boolean first = true;
            for (SQLBuilder.SelectColumnBuilder column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(column.toString(formatter));
            }
            if (this.has_from()) {
                builder.append(" FROM ");
                builder.append(this.from.toString(formatter));
            }
            if (this.has_where()) {
                builder.append(" WHERE ");
                if (OracleSQLBuilder.this.canBeBoolean(this.where.value())) {
                    builder.append(OracleSQLBuilder.this.formatAsBoolean(formatter, this.where.value()));
                } else {
                    builder.append(this.where.toString(formatter));
                }
            }
            if (!involveWithLimitOrOffset) {
                if (this.has_limit() || this.has_offset()) {
                    if (this.has_where()) {
                        builder.append(" AND ");
                    } else {
                        builder.append(" WHERE ");
                    }
                }
                if (this.has_limit()) {
                    builder.append(" ROWNUM <= ");
                    if (this.has_offset()) {
                        builder.append(this.offset + this.limit);
                    } else {
                        builder.append(this.limit);
                    }
                }
                if (this.has_offset()) {
                    builder.append(" AND rnum > ");
                    builder.append(this.offset);
                }
                if (this.has_group_by()) {
                    builder.append(" GROUP BY ");
                    builder.append(((ExpressionBuilder.Value)this.groupColumn.get(0)).toString(formatter));
                    for (int i = 1; i < this.groupColumn.size(); ++i) {
                        builder.append(", ");
                        builder.append(((ExpressionBuilder.Value)this.groupColumn.get(i)).toString(formatter));
                    }
                }
                if (this.has_order_by()) {
                    builder.append(" ORDER BY ");
                    first = true;
                    for (SQLBuilder.OrderByBuilder item : this.order_by) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append(", ");
                        }
                        builder.append(item.toString(formatter));
                    }
                }
            }
            if (involveWithLimitOrOffset) {
                if (this.has_order_by()) {
                    builder.append(" ORDER BY ");
                    first = true;
                    for (SQLBuilder.OrderByBuilder item : this.order_by) {
                        if (first) {
                            first = false;
                        } else {
                            builder.append(", ");
                        }
                        builder.append(item.toString(formatter));
                    }
                }
                builder.append(") a");
                if (this.has_limit()) {
                    builder.append(" WHERE ROWNUM <= ");
                    if (this.has_offset()) {
                        builder.append(this.offset + this.limit);
                    } else {
                        builder.append(this.limit);
                    }
                }
                if (this.has_offset()) {
                    builder.append(" )");
                    builder.append(" WHERE rnum > ");
                    builder.append(this.offset);
                }
            }
            return builder.toString();
        }
    }

    protected class OracleCreateTableBuilder
    extends SQLBuilderBase.CreateTableBuilderBase {
        protected OracleCreateTableBuilder() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public List<String> toStrings(Formatter formatter) {
            ArrayList<String> sqls = new ArrayList<String>();
            StringBuilder builder = new StringBuilder();
            builder.append("CREATE TABLE ");
            builder.append(this.table().toString());
            builder.append(" (");
            boolean first = true;
            ArrayList<String> pks = new ArrayList<String>();
            boolean automaticPrimaryKey = false;
            block6: for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                if (column.isGeometry()) {
                    builder.append(OracleSQLBuilder.this.as_identifier(column.getName()));
                    builder.append(" ");
                    builder.append(" SDO_GEOMETRY");
                    if (!column.allowNulls()) {
                        builder.append(" NOT NULL");
                    }
                } else {
                    builder.append(OracleSQLBuilder.this.as_identifier(column.getName()));
                    builder.append(" ");
                    builder.append(OracleSQLBuilder.this.sqltype(column.getType(), column.getSize(), column.getPrecision(), column.getScale(), column.getGeometryType(), column.getGeometrySubtype()));
                }
                if (column.isPrimaryKey()) {
                    if (column.isAutomatic()) {
                        automaticPrimaryKey = true;
                        pks.clear();
                        pks.add(column.getName());
                        continue;
                    }
                    if (automaticPrimaryKey) continue;
                    pks.add(column.getName());
                    continue;
                }
                if (column.isAutomatic()) {
                    builder.append(" GENERATED ALWAYS as IDENTITY(START with 1 INCREMENT by 1)");
                }
                if (column.getDefaultValue() == null || ExpressionUtils.isDynamicText((String)Objects.toString(column.getDefaultValue(), null))) {
                    if (!column.allowNulls()) continue;
                    builder.append(" DEFAULT NULL");
                    continue;
                }
                switch (column.getType()) {
                    case 11: {
                        builder.append(" DEFAULT ( TIMESTAMP '");
                        Timestamp dtimestamp = DataTypeUtils.toTimestamp((Object)column.getDefaultValue());
                        builder.append(MessageFormat.format("{0,date,yyyy-MM-dd HH:mm:ss.S}", dtimestamp));
                        builder.append("' )");
                        continue block6;
                    }
                    case 10: {
                        builder.append(" DEFAULT ( TIME '");
                        Time dtime = DataTypeUtils.toTime((Object)column.getDefaultValue());
                        builder.append(MessageFormat.format("{0,date,HH:mm:ss}", dtime));
                        builder.append("' )");
                        continue block6;
                    }
                    case 9: {
                        builder.append(" DEFAULT ( DATE '");
                        Date ddate = DataTypeUtils.toDate((Object)column.getDefaultValue());
                        builder.append(MessageFormat.format("{0,date,yyyy-MM-dd}", ddate));
                        builder.append("' )");
                        continue block6;
                    }
                    case 1: {
                        builder.append(" DEFAULT ( '");
                        builder.append(StringUtils.equalsIgnoreCase((CharSequence)Objects.toString(column.getDefaultValue()), (CharSequence)"true") ? "T" : "F");
                        builder.append("' )");
                        continue block6;
                    }
                }
                builder.append(" DEFAULT '");
                builder.append(Objects.toString(column.getDefaultValue(), ""));
                builder.append("'");
            }
            builder.append(" )");
            sqls.add(builder.toString());
            if (pks.size() > 0) {
                builder = new StringBuilder("ALTER TABLE ");
                builder.append(this.table().toString());
                builder.append(" ADD PRIMARY KEY (");
                for (int i = 0; i < pks.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(OracleSQLBuilder.this.as_identifier((String)pks.get(i)));
                }
                builder.append(")");
                sqls.add(builder.toString());
            }
            for (SQLBuilder.ColumnDescriptor column : this.columns) {
                if (!column.isGeometry()) continue;
                int gvsigType = column.getGeometryType();
                int gvsigSubtype = column.getGeometrySubtype();
                String sql = MessageFormat.format(OracleSQLBuilder.DELETE_FROM_OGIS_GEOMETRY_COLUMNS_QUERY, this.table().getSchema(), this.table().getName().toUpperCase(), column.getName());
                sqls.add(sql);
                sql = MessageFormat.format(OracleSQLBuilder.INSERT_OGIS_GEOMETRY_COLUMNS_QUERY, this.table().getSchema(), this.table().getName().toUpperCase(), column.getName(), Integer.toString(GeometryTypeUtils.toSFSGeometryTypeCode(gvsigType, gvsigSubtype)));
                sqls.add(sql);
                Envelope tablebbox = column.getTableBBox();
                if (tablebbox == null) continue;
                sql = SpatialIndexUtils.getSQLDeleteUserMetadata(this.table().getSchema(), this.table().getName(), column.getName());
                sqls.add(sql);
                sql = SpatialIndexUtils.getSQLInsertUserMetadata(this.table().getName(), tablebbox, column.getName(), (int)((Integer)column.getGeometrySRSId()));
                sqls.add(sql);
                sql = SpatialIndexUtils.getSQLCreateSpatialIndex(this.table().getName(), column.getName(), gvsigType, gvsigSubtype);
                sqls.add(sql);
            }
            return sqls;
        }
    }

    public class OracleUpdateTableStatisticsBuilderBase
    extends SQLBuilderBase.UpdateTableStatisticsBuilderBase {
        public OracleUpdateTableStatisticsBuilderBase() {
            super((SQLBuilderBase)OracleSQLBuilder.this);
        }

        public List<String> toStrings() {
            ArrayList<String> sqls = new ArrayList<String>();
            String sql = MessageFormat.format("ANALYZE TABLE {0} COMPUTE STATISTICS", this.table.toString());
            if (!StringUtils.isEmpty((CharSequence)sql)) {
                sqls.add(sql);
            }
            return sqls;
        }
    }

    private class OracleGeometryExpressionBuilder
    extends DelegatedGeometryExpressionBuilder {
        public OracleGeometryExpressionBuilder(GeometryExpressionBuilder expressionBuilder) {
            super(expressionBuilder);
        }

        public Formatter<ExpressionBuilder.Value> formatter() {
            return OracleSQLBuilder.this.formatter();
        }
    }
}

