/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.spi.SRSSolverBase;

public class OracleSRSSolver
extends SRSSolverBase {
    private static Properties translations;

    public OracleSRSSolver(JDBCHelper helper) {
        super(helper);
    }

    protected Object searchDatabaseCode(JDBCConnection connection, String applicationAbbrev) {
        try {
            String[] s = applicationAbbrev.split(":");
            String code_s = s[1].trim();
            try {
                int code_i = Integer.parseInt(code_s);
                return code_i;
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Problems searching database code from '" + applicationAbbrev + "'.", ex);
        }
    }

    protected String searchApplicationAbbrev(JDBCConnection connection, Integer databaseCode) {
        try {
            String s = Objects.toString(databaseCode, "0");
            String trans = this.getTranslation(s, null);
            if (trans == null) {
                return null;
            }
            return "EPSG:" + trans;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Problems searching application abbrev from '" + databaseCode + "'.", ex);
        }
    }

    private String getTranslation(String databaseCode, String defaultValue) {
        InputStream inStream;
        if (translations == null && (inStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/srids/oracle2epsg.properties")) != null) {
            translations = new Properties();
            try {
                translations.load(inStream);
            }
            catch (IOException ex) {
                logger.warn("Can't load srid translations", (Throwable)ex);
            }
        }
        if (translations == null) {
            return defaultValue;
        }
        return translations.getProperty(databaseCode, defaultValue);
    }
}

