/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.expressionbuilderformatter;

import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.oracle.dal.expressionbuilderformatter.AbstractClobOperator;

class Gt
extends AbstractClobOperator
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;
    private final SQLBuilder builder;

    public Gt(SQLBuilder builder, Formatter<ExpressionBuilder.Value> formatter) {
        this.builder = builder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.BinaryOperator) {
            return StringUtils.equalsIgnoreCase((CharSequence)">", (CharSequence)((ExpressionBuilder.BinaryOperator)value).name());
        }
        return false;
    }

    public String format(ExpressionBuilder.Value function) {
        ExpressionBuilder.BinaryOperator operator = (ExpressionBuilder.BinaryOperator)function;
        ExpressionBuilder.Value left = operator.left();
        ExpressionBuilder.Value right = operator.right();
        String p1 = left.toString(this.formatter);
        String p2 = right.toString(this.formatter);
        if (this.useLob(left) || this.useLob(right)) {
            String r = MessageFormat.format("dbms_lob.compare(({0}),({1})) > 0", p1, p2);
            return r;
        }
        String r = MessageFormat.format("( ({0}) > ({1}) )", p1, p2);
        return r;
    }
}

