/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.oracle.dal.operations;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleGetSRS {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleGetSRS.class);
    protected final JDBCHelper helper;
    protected final String database;
    protected final String schema;
    protected final String table;
    private JDBCConnection connection = null;

    public OracleGetSRS(JDBCHelper helper, String database, String schema, String table) {
        this.helper = helper;
        this.database = database;
        this.schema = schema;
        this.table = table;
    }

    public void begin() throws AccessResourceException {
        this.connection = this.helper.getConnection();
    }

    protected void clean() {
        JDBCConnection.closeQuietly((JDBCConnection)this.connection);
        this.connection = null;
    }

    public String execute() throws DataException {
        this.begin();
        StringBuilder srsQuery = new StringBuilder();
        srsQuery.append("select SRID from MDSYS.ALL_SDO_GEOM_METADATA where TABLE_NAME = UPPER('?');");
        PreparedStatement st = null;
        String srs = null;
        try {
            String sql = srsQuery.toString();
            st = this.connection.prepareStatement(sql);
            st.setString(1, this.table);
            ResultSet rs = JDBCUtils.executeQuery((PreparedStatement)st, (String)sql);
            if (rs.first()) {
                srs = rs.getString(0);
            }
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException("Can't get srs from table " + this.table, ex);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly((Statement)st);
        this.clean();
        return srs;
    }
}

